/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.surefire.shadefire.junit.SurefireTestSet;
import org.apache.maven.surefire.shadefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.shadefire.report.RunListener;
import org.apache.maven.surefire.shadefire.report.SimpleReportEntry;
import org.apache.maven.surefire.shadefire.testset.TestSetFailedException;

public class PojoTestSet
implements SurefireTestSet {
    private static final String TEST_METHOD_PREFIX = "test";
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Object testObject;
    private List testMethods;
    private Method setUpMethod;
    private Method tearDownMethod;
    private final Class testClass;

    public PojoTestSet(Class testClass) throws TestSetFailedException {
        if (testClass == null) {
            throw new NullPointerException("testClass is null");
        }
        this.testClass = testClass;
        try {
            this.testObject = testClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new TestSetFailedException("Unable to instantiate POJO '" + testClass + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException("Unable to instantiate POJO '" + testClass + "'", e);
        }
    }

    public void execute(RunListener reportManager, ClassLoader loader) throws TestSetFailedException {
        if (reportManager == null) {
            throw new NullPointerException("reportManager is null");
        }
        this.executeTestMethods(reportManager);
    }

    private void executeTestMethods(RunListener reportManager) {
        if (reportManager == null) {
            throw new NullPointerException("reportManager is null");
        }
        if (this.testMethods == null) {
            this.discoverTestMethods();
        }
        boolean abort = false;
        for (int i = 0; i < this.testMethods.size() && !abort; ++i) {
            abort = this.executeTestMethod((Method)this.testMethods.get(i), EMPTY_OBJECT_ARRAY, reportManager);
        }
    }

    private boolean executeTestMethod(Method method, Object[] args, RunListener reportManager) {
        if (method == null || args == null || reportManager == null) {
            throw new NullPointerException();
        }
        String userFriendlyMethodName = method.getName() + '(';
        if (args.length != 0) {
            userFriendlyMethodName = userFriendlyMethodName + "Reporter";
        }
        userFriendlyMethodName = userFriendlyMethodName + ')';
        SimpleReportEntry report = new SimpleReportEntry(this.testObject.getClass().getName(), this.getTestName(userFriendlyMethodName));
        reportManager.testStarting(report);
        try {
            this.setUpFixture();
        }
        catch (Throwable e) {
            report = SimpleReportEntry.withException(this.testObject.getClass().getName(), this.getTestName(userFriendlyMethodName), new PojoStackTraceWriter(this.testObject.getClass().getName(), method.getName(), e));
            reportManager.testFailed(report);
            return true;
        }
        try {
            method.invoke(this.testObject, args);
            report = new SimpleReportEntry(this.testObject.getClass().getName(), this.getTestName(userFriendlyMethodName));
            reportManager.testSucceeded(report);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            report = SimpleReportEntry.withException(this.testObject.getClass().getName(), this.getTestName(userFriendlyMethodName), new PojoStackTraceWriter(this.testObject.getClass().getName(), method.getName(), t));
            reportManager.testFailed(report);
        }
        catch (Throwable t) {
            report = SimpleReportEntry.withException(this.testObject.getClass().getName(), this.getTestName(userFriendlyMethodName), new PojoStackTraceWriter(this.testObject.getClass().getName(), method.getName(), t));
            reportManager.testFailed(report);
        }
        try {
            this.tearDownFixture();
        }
        catch (Throwable t) {
            report = SimpleReportEntry.withException(this.testObject.getClass().getName(), this.getTestName(userFriendlyMethodName), new PojoStackTraceWriter(this.testObject.getClass().getName(), method.getName(), t));
            reportManager.testFailed(report);
            return true;
        }
        return false;
    }

    private String getTestName(String testMethodName) {
        if (testMethodName == null) {
            throw new NullPointerException("testMethodName is null");
        }
        return this.getTestClass().getName() + "." + testMethodName;
    }

    private void setUpFixture() throws Throwable {
        if (this.setUpMethod != null) {
            this.setUpMethod.invoke(this.testObject, new Object[0]);
        }
    }

    private void tearDownFixture() throws Throwable {
        if (this.tearDownMethod != null) {
            this.tearDownMethod.invoke(this.testObject, new Object[0]);
        }
    }

    private void discoverTestMethods() {
        if (this.testMethods == null) {
            this.testMethods = new ArrayList();
            Method[] methods = this.getTestClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (PojoTestSet.isValidTestMethod(m)) {
                    String firstFour;
                    String simpleName = m.getName();
                    if (simpleName.length() <= 4 || !(firstFour = simpleName.substring(0, 4)).equals(TEST_METHOD_PREFIX)) continue;
                    this.testMethods.add(m);
                    continue;
                }
                if (m.getName().equals("setUp") && m.getParameterTypes().length == 0) {
                    this.setUpMethod = m;
                    continue;
                }
                if (!m.getName().equals("tearDown") || m.getParameterTypes().length != 0) continue;
                this.tearDownMethod = m;
            }
        }
    }

    private static boolean isValidTestMethod(Method m) {
        boolean isInstanceMethod = !Modifier.isStatic(m.getModifiers());
        boolean returnsVoid = m.getReturnType().equals(Void.TYPE);
        boolean hasNoParams = m.getParameterTypes().length == 0;
        return isInstanceMethod && returnsVoid && hasNoParams;
    }

    public String getName() {
        return this.testClass.getName();
    }

    public Class getTestClass() {
        return this.testClass;
    }
}

