/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import org.apache.maven.surefire.shadefire.util.NestedRuntimeException;

public class UrlUtils {
    private static final BitSet UNRESERVED = new BitSet(256);
    private static final int RADIX = 16;
    private static final int MASK = 15;
    private static final String ENCODING = "UTF-8";

    private UrlUtils() {
    }

    public static URL getURL(File file) throws MalformedURLException {
        URL url = file.toURL();
        try {
            byte[] bytes = url.toString().getBytes(ENCODING);
            StringBuffer buf = new StringBuffer(bytes.length);
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                if (b > 0 && UNRESERVED.get(b)) {
                    buf.append((char)b);
                    continue;
                }
                buf.append('%');
                buf.append(Character.forDigit(b >>> 4 & 0xF, 16));
                buf.append(Character.forDigit(b & 0xF, 16));
            }
            return new URL(buf.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new NestedRuntimeException(e);
        }
    }

    static {
        try {
            byte[] bytes = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'():/".getBytes(ENCODING);
            for (int i = 0; i < bytes.length; ++i) {
                UNRESERVED.set(bytes[i]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

