/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.report;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.maven.surefire.shadefire.report.ConsoleLogger;
import org.apache.maven.surefire.shadefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.shadefire.report.ReportEntry;
import org.apache.maven.surefire.shadefire.report.ReporterException;
import org.apache.maven.surefire.shadefire.report.RunListener;
import org.apache.maven.surefire.shadefire.util.internal.ByteBuffer;

public class AsynchRunListener
implements RunListener,
ConsoleOutputReceiver,
ConsoleLogger {
    private final LinkedBlockingQueue blockingQueue = new LinkedBlockingQueue();
    private final Processor processor = new Processor(this.blockingQueue);
    private final RunListener target;
    private final ConsoleOutputReceiver consoleOutputReceiver;
    private final Thread asynchRunListener;
    private static final Runnable poison = new Runnable(){

        public void run() {
        }
    };

    public AsynchRunListener(RunListener target, String role) {
        this.target = target;
        this.consoleOutputReceiver = (ConsoleOutputReceiver)((Object)target);
        this.asynchRunListener = new Thread((Runnable)this.processor, "AsynchRunListener" + role);
        this.asynchRunListener.start();
    }

    public void testSetStarting(final ReportEntry report) {
        this.blockingQueue.add(new Runnable(){

            public void run() {
                AsynchRunListener.this.target.testSetStarting(report);
            }
        });
    }

    public void testSetCompleted(final ReportEntry report) {
        this.blockingQueue.add(new Runnable(){

            public void run() {
                AsynchRunListener.this.target.testSetCompleted(report);
            }
        });
    }

    public void testStarting(final ReportEntry report) {
        this.blockingQueue.add(new Runnable(){

            public void run() {
                AsynchRunListener.this.target.testStarting(report);
            }
        });
    }

    public void testSucceeded(final ReportEntry report) {
        this.blockingQueue.add(new Runnable(){

            public void run() {
                AsynchRunListener.this.target.testSucceeded(report);
            }
        });
    }

    public void testAssumptionFailure(final ReportEntry report) {
        this.blockingQueue.add(new Runnable(){

            public void run() {
                AsynchRunListener.this.target.testAssumptionFailure(report);
            }
        });
    }

    public void testError(final ReportEntry report) {
        this.blockingQueue.add(new Runnable(){

            public void run() {
                AsynchRunListener.this.target.testError(report);
            }
        });
    }

    public void testFailed(final ReportEntry report) {
        this.blockingQueue.add(new Runnable(){

            public void run() {
                AsynchRunListener.this.target.testFailed(report);
            }
        });
    }

    public void testSkipped(final ReportEntry report) {
        this.blockingQueue.add(new Runnable(){

            public void run() {
                AsynchRunListener.this.target.testSkipped(report);
            }
        });
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        this.blockingQueue.add(new JoinableTestOutput(buf, off, len, stdout, this.consoleOutputReceiver));
    }

    public void info(final String message) {
        this.blockingQueue.add(new Runnable(){

            public void run() {
                ((ConsoleLogger)((Object)AsynchRunListener.this.consoleOutputReceiver)).info(message);
            }
        });
    }

    public void close() throws ReporterException {
        try {
            this.blockingQueue.add(poison);
            this.asynchRunListener.join();
            InterruptedException exception = this.processor.getException();
            if (exception != null) {
                throw exception;
            }
        }
        catch (InterruptedException e) {
            throw new ReporterException("When waiting", e);
        }
    }

    static class JoinableTestOutput
    implements Runnable {
        final byte[] buf;
        final int off;
        final int len;
        final boolean stdout;
        private final ConsoleOutputReceiver consoleOutputReceiver;

        JoinableTestOutput(byte[] buf, int off, int len, boolean stdout, ConsoleOutputReceiver consoleOutputReceiver) {
            this.buf = ByteBuffer.copy(buf, off, len);
            this.off = 0;
            this.len = len;
            this.stdout = stdout;
            this.consoleOutputReceiver = consoleOutputReceiver;
        }

        public void run() {
            this.consoleOutputReceiver.writeTestOutput(this.buf, this.off, this.len, this.stdout);
        }

        public JoinableTestOutput append(JoinableTestOutput other) {
            byte[] combined = ByteBuffer.join(this.buf, this.off, this.len, other.buf, other.off, other.len);
            return new JoinableTestOutput(combined, 0, combined.length, this.stdout, this.consoleOutputReceiver);
        }
    }

    static class Processor
    implements Runnable {
        private final LinkedBlockingQueue blockingQueue;
        private volatile InterruptedException exception;

        Processor(LinkedBlockingQueue blockingQueue) {
            this.blockingQueue = blockingQueue;
        }

        public void run() {
            try {
                Runnable take = (Runnable)this.blockingQueue.take();
                while (take != poison) {
                    take.run();
                    take = (Runnable)this.blockingQueue.take();
                }
            }
            catch (InterruptedException e) {
                this.exception = e;
            }
        }

        public InterruptedException getException() {
            return this.exception;
        }
    }
}

