/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.org.codehaus.plexus.util;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public final class SelectorUtils {
    public static final String PATTERN_HANDLER_PREFIX = "[";
    public static final String PATTERN_HANDLER_SUFFIX = "]";
    public static final String REGEX_HANDLER_PREFIX = "%regex[";
    public static final String ANT_HANDLER_PREFIX = "%ant[";
    private static SelectorUtils instance = new SelectorUtils();

    private SelectorUtils() {
    }

    public static SelectorUtils getInstance() {
        return instance;
    }

    public static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str, true);
    }

    public static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        if (pattern.length() > REGEX_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern.startsWith(REGEX_HANDLER_PREFIX) && pattern.endsWith(PATTERN_HANDLER_SUFFIX)) {
            return true;
        }
        if (pattern.length() > ANT_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern.startsWith(ANT_HANDLER_PREFIX) && pattern.endsWith(PATTERN_HANDLER_SUFFIX)) {
            pattern = pattern.substring(ANT_HANDLER_PREFIX.length(), pattern.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        String altStr = str.replace('\\', '/');
        return SelectorUtils.matchAntPathPatternStart(pattern, str, File.separator, isCaseSensitive) || SelectorUtils.matchAntPathPatternStart(pattern, altStr, "/", isCaseSensitive);
    }

    private static boolean matchAntPathPatternStart(String pattern, String str, String separator, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        if (str.startsWith(separator) != pattern.startsWith(separator)) {
            return false;
        }
        Vector patDirs = SelectorUtils.tokenizePath(pattern, separator);
        Vector strDirs = SelectorUtils.tokenizePath(str, separator);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.size() - 1;
        int strIdxEnd = strDirs.size() - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = (String)patDirs.elementAt(patIdxStart)).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (SelectorUtils.match(patDir, (String)strDirs.elementAt(strIdxStart), isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            return true;
        }
        return patIdxStart <= patIdxEnd;
    }

    public static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath(pattern, str, true);
    }

    public static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        if (pattern.length() > REGEX_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern.startsWith(REGEX_HANDLER_PREFIX) && pattern.endsWith(PATTERN_HANDLER_SUFFIX)) {
            pattern = pattern.substring(REGEX_HANDLER_PREFIX.length(), pattern.length() - PATTERN_HANDLER_SUFFIX.length());
            return str.matches(pattern);
        }
        if (pattern.length() > ANT_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern.startsWith(ANT_HANDLER_PREFIX) && pattern.endsWith(PATTERN_HANDLER_SUFFIX)) {
            pattern = pattern.substring(ANT_HANDLER_PREFIX.length(), pattern.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        return SelectorUtils.matchAntPathPattern(pattern, str, isCaseSensitive);
    }

    private static boolean matchAntPathPattern(String pattern, String str, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        if (str.startsWith(File.separator) != pattern.startsWith(File.separator)) {
            return false;
        }
        Vector patDirs = SelectorUtils.tokenizePath(pattern, File.separator);
        Vector strDirs = SelectorUtils.tokenizePath(str, File.separator);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.size() - 1;
        int strIdxEnd = strDirs.size() - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = (String)patDirs.elementAt(patIdxStart)).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (SelectorUtils.match(patDir, (String)strDirs.elementAt(strIdxStart), isCaseSensitive)) continue;
            patDirs = null;
            strDirs = null;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patDirs.elementAt(i).equals("**")) continue;
                patDirs = null;
                strDirs = null;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            patDirs = null;
            strDirs = null;
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = (String)patDirs.elementAt(patIdxEnd)).equals("**")) {
            if (!SelectorUtils.match(patDir, (String)strDirs.elementAt(strIdxEnd), isCaseSensitive)) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patDirs.elementAt(i).equals("**")) continue;
                patDirs = null;
                strDirs = null;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (!patDirs.elementAt(i).equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subStr;
                    String subPat = (String)patDirs.elementAt(patIdxStart + j + 1);
                    if (!SelectorUtils.match(subPat, subStr = (String)strDirs.elementAt(strIdxStart + i + j), isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patDirs.elementAt(i).equals("**")) continue;
            patDirs = null;
            strDirs = null;
            return false;
        }
        return true;
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str, true);
    }

    public static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || SelectorUtils.equals(ch2, strArr[i], isCaseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxStart], isCaseSensitive)) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxStart + i3 + j], isCaseSensitive)) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    private static boolean equals(char c1, char c2, boolean isCaseSensitive) {
        if (c1 == c2) {
            return true;
        }
        return !isCaseSensitive && (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2));
    }

    public static Vector tokenizePath(String path) {
        return SelectorUtils.tokenizePath(path, File.separator);
    }

    public static Vector tokenizePath(String path, String separator) {
        Vector<String> ret = new Vector<String>();
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.addElement(st.nextToken());
        }
        return ret;
    }

    public static boolean isOutOfDate(File src, File target, int granularity) {
        if (!src.exists()) {
            return false;
        }
        if (!target.exists()) {
            return true;
        }
        return src.lastModified() - (long)granularity > target.lastModified();
    }

    public static String removeWhitespace(String input) {
        StringBuffer result = new StringBuffer();
        if (input != null) {
            StringTokenizer st = new StringTokenizer(input);
            while (st.hasMoreTokens()) {
                result.append(st.nextToken());
            }
        }
        return result.toString();
    }
}

