/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import org.apache.maven.shared.utils.StringUtils;

public final class ReportTestCase {
    private String fullClassName;
    private String className;
    private String fullName;
    private String name;
    private float time;
    private String failureMessage;
    private String failureType;
    private String failureErrorLine;
    private String failureDetail;
    private boolean hasFailure;
    private boolean hasError;
    private boolean hasSkipped;

    public String getName() {
        return this.name;
    }

    public ReportTestCase setName(String name) {
        this.name = name;
        return this;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public ReportTestCase setFullClassName(String name) {
        this.fullClassName = name;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public ReportTestCase setClassName(String name) {
        this.className = name;
        return this;
    }

    public float getTime() {
        return this.time;
    }

    public ReportTestCase setTime(float time) {
        this.time = time;
        return this;
    }

    public String getFullName() {
        return this.fullName;
    }

    public ReportTestCase setFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    private ReportTestCase setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
        return this;
    }

    public String getFailureType() {
        return this.failureType;
    }

    public String getFailureErrorLine() {
        return this.failureErrorLine;
    }

    public ReportTestCase setFailureErrorLine(String failureErrorLine) {
        this.failureErrorLine = failureErrorLine;
        return this;
    }

    public String getFailureDetail() {
        return this.failureDetail;
    }

    public ReportTestCase setFailureDetail(String failureDetail) {
        this.failureDetail = failureDetail;
        return this;
    }

    public ReportTestCase setFailure(String message, String type) {
        this.hasFailure = StringUtils.isNotBlank((String)type);
        this.hasError = false;
        this.hasSkipped = false;
        return this.setFailureMessage(message).setFailureType(type);
    }

    public ReportTestCase setError(String message, String type) {
        this.hasFailure = false;
        this.hasError = StringUtils.isNotBlank((String)type);
        this.hasSkipped = false;
        return this.setFailureMessage(message).setFailureType(type);
    }

    public ReportTestCase setSkipped(String message) {
        this.hasFailure = false;
        this.hasError = false;
        this.hasSkipped = StringUtils.isNotBlank((String)message);
        return this.setFailureMessage(message).setFailureType("skipped");
    }

    public boolean isSuccessful() {
        return !this.hasFailure() && !this.hasError() && !this.hasSkipped();
    }

    public boolean hasFailure() {
        return this.hasFailure;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public boolean hasSkipped() {
        return this.hasSkipped;
    }

    public String toString() {
        return this.fullName;
    }

    private ReportTestCase setFailureType(String failureType) {
        this.failureType = failureType;
        return this;
    }
}

