/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.maven.surefire.junitcore.ConfigurableParallelComputer;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.Computer;
import org.junit.runner.JUnitCore;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JUnitCoreWrapper {
    JUnitCoreWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(TestsToRun testsToRun, JUnitCoreParameters jUnitCoreParameters, List<RunListener> listeners) throws TestSetFailedException {
        Computer computer = JUnitCoreWrapper.getComputer(jUnitCoreParameters);
        JUnitCore junitCore = new JUnitCore();
        for (RunListener runListener : listeners) {
            junitCore.addListener(runListener);
        }
        try {
            junitCore.run(computer, testsToRun.getLocatedClasses());
        }
        finally {
            JUnitCoreWrapper.closeIfConfigurable(computer);
            for (RunListener runListener : listeners) {
                junitCore.removeListener(runListener);
            }
        }
    }

    private static void closeIfConfigurable(Computer computer) throws TestSetFailedException {
        if (computer instanceof ConfigurableParallelComputer) {
            try {
                ((ConfigurableParallelComputer)computer).close();
            }
            catch (ExecutionException e) {
                throw new TestSetFailedException((Throwable)e);
            }
        }
    }

    private static Computer getComputer(JUnitCoreParameters jUnitCoreParameters) throws TestSetFailedException {
        if (jUnitCoreParameters.isNoThreading()) {
            return new Computer();
        }
        return JUnitCoreWrapper.getConfigurableParallelComputer(jUnitCoreParameters);
    }

    private static Computer getConfigurableParallelComputer(JUnitCoreParameters jUnitCoreParameters) throws TestSetFailedException {
        if (jUnitCoreParameters.isUseUnlimitedThreads().booleanValue()) {
            return new ConfigurableParallelComputer();
        }
        return new ConfigurableParallelComputer(jUnitCoreParameters.isParallelClasses() | jUnitCoreParameters.isParallelBoth(), jUnitCoreParameters.isParallelMethod() | jUnitCoreParameters.isParallelBoth(), jUnitCoreParameters.getThreadCount(), (boolean)jUnitCoreParameters.isPerCoreThreadCount());
    }
}

