/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.report.RunListener;
import org.junit.runner.Description;
import org.junit.runner.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitCoreRunListener
extends JUnit4RunListener {
    private final Map<String, TestSet> classMethodCounts;

    public JUnitCoreRunListener(RunListener reporter, Map<String, TestSet> classMethodCounts) {
        super(reporter);
        this.classMethodCounts = classMethodCounts;
    }

    public void testRunStarted(Description description) throws Exception {
        this.fillTestCountMap(description);
        this.reporter.testSetStarting(null);
    }

    public void testRunFinished(Result result) throws Exception {
        this.reporter.testSetCompleted(null);
    }

    private void fillTestCountMap(Description description) {
        ArrayList children = description.getChildren();
        TestSet testSet = new TestSet(description);
        Class itemTestClass = null;
        for (Description item : children) {
            if (item.isTest()) {
                testSet.incrementTestMethodCount();
                if (itemTestClass != null) continue;
                itemTestClass = item.getTestClass();
                continue;
            }
            if (item.getChildren().size() <= 0) continue;
            this.fillTestCountMap(item);
        }
        if (itemTestClass != null) {
            this.classMethodCounts.put(itemTestClass.getName(), testSet);
        }
    }
}

