/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.surefire.junitcore.ConcurrentPrintStream;
import org.apache.maven.surefire.junitcore.TestMethod;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.ReporterManagerFactory;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public abstract class ConcurrentReportingRunListener
extends RunListener {
    private final PrintStream orgSystemOut = System.out;
    private final PrintStream orgSystemErr = System.err;
    protected Map<Class, TestSet> classMethodCounts = new ConcurrentHashMap<Class, TestSet>();
    protected final ReporterManager reporterManager;
    protected final boolean reportImmediately;
    private final ConcurrentPrintStream out = new ConcurrentPrintStream(true);
    private final ConcurrentPrintStream err = new ConcurrentPrintStream(false);

    public ConcurrentReportingRunListener(ReporterManagerFactory reporterFactory, boolean reportImmediately) throws TestSetFailedException {
        this.reportImmediately = reportImmediately;
        this.reporterManager = reporterFactory.createReporterManager();
        System.setOut(this.out);
        System.setErr(this.err);
    }

    public void testRunStarted(Description description) throws Exception {
        TestMethod.fillTestCountMap(description, this.classMethodCounts);
    }

    public void testRunFinished(Result result) throws Exception {
        for (TestSet testSet : this.classMethodCounts.values()) {
            testSet.replay(this.reporterManager);
        }
        System.setOut(this.orgSystemOut);
        System.setErr(this.orgSystemErr);
        this.out.writeTo(this.orgSystemOut);
        this.err.writeTo(this.orgSystemErr);
    }

    protected TestMethod getTestMethod() {
        return TestMethod.getThreadTestMethod();
    }

    protected void detachTestMethodFromThread() {
        TestMethod.detachFromCurrentThread();
    }

    protected TestSet getTestSet(Description description) {
        return this.classMethodCounts.get(description.getTestClass());
    }

    public void testFailure(Failure failure) throws Exception {
        this.getOrCreateTestMethod(failure.getDescription()).testFailure(failure);
    }

    private TestMethod getOrCreateTestMethod(Description description) {
        TestMethod threadTestMethod = TestMethod.getThreadTestMethod();
        if (threadTestMethod != null) {
            return threadTestMethod;
        }
        TestSet testSet = this.getTestSet(description);
        return testSet.createTestMethod(description);
    }

    public void testAssumptionFailure(Failure failure) {
        TestMethod.getThreadTestMethod().testAssumptionFailure(failure);
    }

    public void testIgnored(Description description) throws Exception {
        TestSet testSet = this.getTestSet(description);
        TestMethod testMethod = this.getTestSet(description).createTestMethod(description);
        testMethod.testIgnored(description);
        testSet.incrementFinishedTests(this.reporterManager, this.reportImmediately);
    }

    public void testStarted(Description description) throws Exception {
        TestSet testSet = this.getTestSet(description);
        testSet.createTestMethod(description).attachToThread();
        this.checkIfTestSetCanBeReported(testSet);
        testSet.attachToThread();
    }

    public abstract void checkIfTestSetCanBeReported(TestSet var1);

    public void testFinished(Description description) throws Exception {
        this.getTestMethod().testFinished();
        TestSet.getThreadTestSet().incrementFinishedTests(this.reporterManager, this.reportImmediately);
        this.detachTestMethodFromThread();
    }

    public static ConcurrentReportingRunListener createInstance(ReporterManagerFactory reporterManagerFactory, boolean parallelClasses, boolean parallelBoth) throws TestSetFailedException {
        if (parallelClasses) {
            return new ClassesParallelRunListener(reporterManagerFactory);
        }
        return new MethodsParallelRunListener(reporterManagerFactory, !parallelBoth);
    }

    public static class MethodsParallelRunListener
    extends ConcurrentReportingRunListener {
        private volatile TestSet lastStarted;
        private final Object lock = new Object();

        public MethodsParallelRunListener(ReporterManagerFactory reporterFactory, boolean reportImmediately) throws TestSetFailedException {
            super(reporterFactory, reportImmediately);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkIfTestSetCanBeReported(TestSet testSetForTest) {
            Object object = this.lock;
            synchronized (object) {
                if (testSetForTest != this.lastStarted) {
                    if (this.lastStarted != null) {
                        this.lastStarted.setAllScheduled(this.reporterManager);
                    }
                    this.lastStarted = testSetForTest;
                }
            }
        }
    }

    public static class ClassesParallelRunListener
    extends ConcurrentReportingRunListener {
        public ClassesParallelRunListener(ReporterManagerFactory reporterFactory) throws TestSetFailedException {
            super(reporterFactory, false);
        }

        public void checkIfTestSetCanBeReported(TestSet testSetForTest) {
            TestSet currentlyAttached = TestSet.getThreadTestSet();
            if (currentlyAttached != null && currentlyAttached != testSetForTest) {
                currentlyAttached.setAllScheduled(this.reporterManager);
            }
        }
    }
}

