/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.maven.surefire.junitcore.LogicalStream;
import org.apache.maven.surefire.junitcore.TestMethod;

class ConcurrentPrintStream
extends PrintStream {
    private final boolean isStdout;
    private final LogicalStream defaultStream = new LogicalStream();

    ConcurrentPrintStream(boolean stdout) {
        super(new ByteArrayOutputStream());
        this.isStdout = stdout;
    }

    public void write(byte[] buf, int off, int len) {
        TestMethod threadTestMethod = TestMethod.getThreadTestMethod();
        if (threadTestMethod != null) {
            threadTestMethod.getLogicalStream().write(this.isStdout, buf, off, len);
        } else {
            ((ByteArrayOutputStream)this.out).write(buf, off, len);
        }
    }

    public void writeTo(PrintStream printStream) throws IOException {
        ((ByteArrayOutputStream)this.out).writeTo(printStream);
    }

    public void close() {
    }

    public void flush() {
    }
}

