/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Map;
import org.apache.maven.surefire.junitcore.ConcurrentRunListener;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.junitcore.ThreadSafe;
import org.apache.maven.surefire.report.ConsoleStream;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.testset.TestSetFailedException;

@ThreadSafe
public class MethodsParallelRunListener
extends ConcurrentRunListener {
    private volatile TestSet lastStarted;
    private final Object lock = new Object();

    public MethodsParallelRunListener(Map<String, TestSet> classMethodCounts, ReporterFactory reporterFactory, boolean reportImmediately, ConsoleStream consoleStream) throws TestSetFailedException {
        super(reporterFactory, consoleStream, reportImmediately, classMethodCounts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIfTestSetCanBeReported(TestSet testSetForTest) {
        Object object = this.lock;
        synchronized (object) {
            if (testSetForTest != this.lastStarted) {
                if (this.lastStarted != null) {
                    this.lastStarted.setAllScheduled(this.getRunListener());
                }
                this.lastStarted = testSetForTest;
            }
        }
    }
}

