/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.MasterProcessListener;
import org.apache.maven.surefire.booter.MasterProcessReader;
import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnitTestFailureListener;
import org.apache.maven.surefire.common.junit4.Notifier;
import org.apache.maven.surefire.common.junit48.FilterFactory;
import org.apache.maven.surefire.common.junit48.JUnit48Reflector;
import org.apache.maven.surefire.common.junit48.JUnit48TestChecker;
import org.apache.maven.surefire.junitcore.ConcurrentRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.JUnitCoreRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreWrapper;
import org.apache.maven.surefire.junitcore.NonConcurrentRunListener;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitCoreProvider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final JUnitCoreParameters jUnitCoreParameters;
    private final ScannerFilter scannerFilter;
    private final Collection<RunListener> customRunListeners;
    private final ProviderParameters providerParameters;
    private final ScanResult scanResult;
    private final int rerunFailingTestsCount;
    private final JUnit48Reflector jUnit48Reflector;
    private final RunOrderCalculator runOrderCalculator;
    private final TestListResolver testResolver;
    private final MasterProcessReader commandsReader;
    private TestsToRun testsToRun;

    public JUnitCoreProvider(ProviderParameters providerParameters) {
        this.commandsReader = providerParameters.isInsideFork() ? MasterProcessReader.getReader().setShutdown(providerParameters.getShutdown()) : null;
        this.providerParameters = providerParameters;
        this.testClassLoader = providerParameters.getTestClassLoader();
        this.scanResult = providerParameters.getScanResult();
        this.runOrderCalculator = providerParameters.getRunOrderCalculator();
        this.jUnitCoreParameters = new JUnitCoreParameters(providerParameters.getProviderProperties());
        this.scannerFilter = new JUnit48TestChecker(this.testClassLoader);
        this.testResolver = providerParameters.getTestRequest().getTestListResolver();
        this.rerunFailingTestsCount = providerParameters.getTestRequest().getRerunFailingTestsCount();
        String listeners = (String)providerParameters.getProviderProperties().get("listener");
        this.customRunListeners = Collections.unmodifiableCollection(JUnit4RunListenerFactory.createCustomListeners(listeners));
        this.jUnit48Reflector = new JUnit48Reflector(this.testClassLoader);
    }

    public Iterable<Class<?>> getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun;
    }

    private boolean isSingleThreaded() {
        return this.jUnitCoreParameters.isNoThreading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        Filter filter;
        if (this.isRerunFailingTests() && this.isFailFast()) {
            throw new TestSetFailedException("don't enable parameters rerunFailingTestsCount, skipAfterFailureCount");
        }
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        ConsoleLogger consoleLogger = this.providerParameters.getConsoleLogger();
        Filter filter2 = filter = this.jUnit48Reflector.isJUnit48Available() ? this.createJUnit48Filter() : null;
        if (this.testsToRun == null) {
            if (forkTestSet instanceof TestsToRun) {
                this.testsToRun = (TestsToRun)forkTestSet;
            } else if (forkTestSet instanceof Class) {
                Class theClass = (Class)forkTestSet;
                this.testsToRun = TestsToRun.fromClass((Class)theClass);
            } else {
                this.testsToRun = this.scanClassPath();
            }
        }
        Notifier notifier = new Notifier(this.createRunListener(reporterFactory, consoleLogger), this.getSkipAfterFailureCount());
        JUnitTestFailureListener testFailureListener = new JUnitTestFailureListener();
        notifier.addListener(testFailureListener);
        if (this.isFailFast() && this.commandsReader != null) {
            this.registerPleaseStopJunitListener(notifier);
        }
        try {
            JUnitCoreWrapper core = new JUnitCoreWrapper(notifier, this.jUnitCoreParameters, consoleLogger, this.isFailFast());
            if (this.commandsReader != null) {
                this.commandsReader.addShutdownListener(new MasterProcessListener(){

                    public void update(Command command) {
                        JUnitCoreProvider.this.testsToRun.markTestSetFinished();
                    }
                });
                this.commandsReader.awaitStarted();
            }
            core.execute(this.testsToRun, this.customRunListeners, filter);
            if (this.isRerunFailingTests()) {
                for (int i = 0; i < this.rerunFailingTestsCount && !testFailureListener.getAllFailures().isEmpty(); ++i) {
                    List<Failure> failures = testFailureListener.getAllFailures();
                    Map<Class<?>, Set<String>> failingTests = JUnit4ProviderUtil.generateFailingTests(failures, this.testClassLoader);
                    testFailureListener.reset();
                    FilterFactory filterFactory = new FilterFactory(this.testClassLoader);
                    Filter failingMethodsFilter = filterFactory.createFailingMethodFilter(failingTests);
                    core.execute(this.testsToRun, failingMethodsFilter);
                }
            }
            RunResult runResult = reporterFactory.close();
            return runResult;
        }
        finally {
            notifier.removeListeners();
            this.closeCommandsReader();
        }
    }

    private boolean isRerunFailingTests() {
        return this.rerunFailingTestsCount > 0;
    }

    private boolean isFailFast() {
        return this.providerParameters.getSkipAfterFailureCount() > 0;
    }

    private int getSkipAfterFailureCount() {
        return this.isFailFast() && !this.isRerunFailingTests() ? this.providerParameters.getSkipAfterFailureCount() : 0;
    }

    private void closeCommandsReader() {
        if (this.commandsReader != null) {
            this.commandsReader.stop();
        }
    }

    private MasterProcessListener registerPleaseStopJunitListener(final Notifier stoppable) {
        MasterProcessListener listener = new MasterProcessListener(){

            public void update(Command command) {
                stoppable.pleaseStop();
            }
        };
        this.commandsReader.addSkipNextListener(listener);
        return listener;
    }

    private JUnit4RunListener createRunListener(ReporterFactory reporterFactory, ConsoleLogger consoleLogger) throws TestSetFailedException {
        if (this.isSingleThreaded()) {
            NonConcurrentRunListener rm = new NonConcurrentRunListener(reporterFactory.createReporter());
            ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)rm);
            return rm;
        }
        ConcurrentHashMap<String, TestSet> testSetMap = new ConcurrentHashMap<String, TestSet>();
        ConcurrentRunListener listener = ConcurrentRunListener.createInstance(testSetMap, reporterFactory, this.isParallelTypes(), this.isParallelMethodsAndTypes(), consoleLogger);
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)listener);
        return new JUnitCoreRunListener(listener, testSetMap);
    }

    private boolean isParallelMethodsAndTypes() {
        return this.jUnitCoreParameters.isParallelMethods() && this.isParallelTypes();
    }

    private boolean isParallelTypes() {
        return this.jUnitCoreParameters.isParallelClasses() || this.jUnitCoreParameters.isParallelSuites();
    }

    private Filter createJUnit48Filter() {
        FilterFactory factory = new FilterFactory(this.testClassLoader);
        Filter groupFilter = factory.createGroupFilter(this.providerParameters.getProviderProperties());
        TestListResolver methodFilter = this.createMethodFilter();
        boolean onlyGroups = methodFilter == null || methodFilter.isEmpty();
        return onlyGroups ? groupFilter : factory.and(groupFilter, factory.createMethodFilter(methodFilter));
    }

    private TestsToRun scanClassPath() {
        TestsToRun scanned = this.scanResult.applyFilter(this.scannerFilter, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scanned);
    }

    private TestListResolver createMethodFilter() {
        return this.testResolver == null ? null : this.testResolver.createMethodFilters();
    }
}

