/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.maven.surefire.junitcore.AsynchronousRunner;
import org.apache.maven.surefire.junitcore.SynchronousRunner;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;
import org.junit.runner.Computer;
import org.junit.runner.Runner;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.RunnerScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ConfigurableParallelComputer
extends Computer {
    private static final ThreadFactory DAEMON_THREAD_FACTORY = DaemonThreadFactory.newDaemonThreadFactory();
    private final boolean fClasses;
    private final boolean fMethods;
    private final boolean fixedPool;
    private final ExecutorService fService;
    private final List<AsynchronousRunner> nonBlockers = Collections.synchronizedList(new ArrayList());

    public ConfigurableParallelComputer() {
        this(true, true, Executors.newCachedThreadPool(DAEMON_THREAD_FACTORY), false);
    }

    public ConfigurableParallelComputer(boolean fClasses, boolean fMethods) {
        this(fClasses, fMethods, Executors.newCachedThreadPool(DAEMON_THREAD_FACTORY), false);
    }

    public ConfigurableParallelComputer(boolean fClasses, boolean fMethods, Integer numberOfThreads, boolean perCore) {
        this(fClasses, fMethods, Executors.newFixedThreadPool(numberOfThreads * (perCore ? Runtime.getRuntime().availableProcessors() : 1), DAEMON_THREAD_FACTORY), true);
    }

    private ConfigurableParallelComputer(boolean fClasses, boolean fMethods, ExecutorService executorService, boolean fixedPool) {
        this.fClasses = fClasses;
        this.fMethods = fMethods;
        this.fService = executorService;
        this.fixedPool = fixedPool;
    }

    public void close() throws ExecutionException {
        for (AsynchronousRunner nonBlocker : this.nonBlockers) {
            nonBlocker.waitForCompletion();
        }
        this.fService.shutdown();
        try {
            if (!this.fService.awaitTermination(10L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Executor did not shut down within timeout");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Runner parallelize(Runner runner, RunnerScheduler runnerInterceptor) {
        if (runner instanceof ParentRunner) {
            ((ParentRunner)runner).setScheduler(runnerInterceptor);
        }
        return runner;
    }

    private RunnerScheduler getMethodInterceptor() {
        if (this.fClasses && this.fMethods) {
            AsynchronousRunner blockingAsynchronousRunner = new AsynchronousRunner(this.fService);
            this.nonBlockers.add(blockingAsynchronousRunner);
            return blockingAsynchronousRunner;
        }
        return this.fMethods ? new AsynchronousRunner(this.fService) : new SynchronousRunner();
    }

    private RunnerScheduler getClassInterceptor() {
        if (this.fClasses) {
            return this.fMethods ? new SynchronousRunner() : new AsynchronousRunner(this.fService);
        }
        return new SynchronousRunner();
    }

    public Runner getSuite(RunnerBuilder builder, Class<?>[] classes) throws InitializationError {
        Runner suite = super.getSuite(builder, (Class[])classes);
        return this.fClasses ? this.parallelize(suite, this.getClassInterceptor()) : suite;
    }

    protected Runner getRunner(RunnerBuilder builder, Class<?> testClass) throws Throwable {
        Runner runner = super.getRunner(builder, testClass);
        return this.fMethods && !this.isTestSuite(testClass) ? this.parallelize(runner, this.getMethodInterceptor()) : runner;
    }

    private boolean isTestSuite(Class<?> testClass) {
        Suite.SuiteClasses annotation = testClass.getAnnotation(Suite.SuiteClasses.class);
        return annotation != null;
    }

    public String toString() {
        return "ConfigurableParallelComputer{classes=" + this.fClasses + ", methods=" + this.fMethods + ", fixedPool=" + this.fixedPool + '}';
    }
}

