/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.surefire.junitcore.pc.ParallelComputerUtil;
import org.apache.maven.surefire.junitcore.pc.Scheduler;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategies;
import org.apache.maven.surefire.junitcore.pc.ShutdownResult;
import org.junit.runner.Description;
import org.junit.runners.model.RunnerScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingleThreadScheduler {
    private final ExecutorService pool = SingleThreadScheduler.newPool();
    private final Scheduler master = new Scheduler(null, SchedulingStrategies.createParallelSharedStrategy(this.pool));

    SingleThreadScheduler() {
    }

    private static ExecutorService newPool() {
        ThreadFactory factory = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "maven-surefire-plugin@NotThreadSafe");
            }
        };
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), factory);
    }

    RunnerScheduler newRunnerScheduler() {
        return new Scheduler(null, this.master, SchedulingStrategies.createParallelSharedStrategy(this.pool));
    }

    ShutdownResult describeStopped(boolean shutdownNow) {
        ShutdownResult shutdownResult = this.master.describeStopped(shutdownNow);
        return new ShutdownResult(this.copyExisting(shutdownResult.getTriggeredTests()), this.copyExisting(shutdownResult.getIncompleteTests()));
    }

    boolean shutdownThreadPoolsAwaitingKilled() {
        return this.master.shutdownThreadPoolsAwaitingKilled();
    }

    private Collection<Description> copyExisting(Collection<Description> descriptions) {
        ConcurrentLinkedQueue<Description> activeChildren = new ConcurrentLinkedQueue<Description>(descriptions);
        ParallelComputerUtil.removeUnusedDescriptions(activeChildren);
        return activeChildren;
    }
}

