/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.List;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.pc.ParallelComputer;
import org.apache.maven.surefire.junitcore.pc.ParallelComputerBuilder;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.Computer;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JUnitCoreWrapper {
    JUnitCoreWrapper() {
    }

    public static void execute(TestsToRun testsToRun, JUnitCoreParameters jUnitCoreParameters, List<RunListener> listeners, Filter filter) throws TestSetFailedException {
        JUnitCore junitCore = JUnitCoreWrapper.createJUnitCore(listeners);
        if (testsToRun.allowEagerReading()) {
            JUnitCoreWrapper.executeEager(testsToRun, filter, jUnitCoreParameters, junitCore);
        } else {
            JUnitCoreWrapper.executeLazy(testsToRun, filter, jUnitCoreParameters, junitCore);
        }
    }

    private static JUnitCore createJUnitCore(List<RunListener> listeners) {
        JUnitCore junitCore = new JUnitCore();
        for (RunListener runListener : listeners) {
            junitCore.addListener(runListener);
        }
        return junitCore;
    }

    private static void executeEager(TestsToRun testsToRun, Filter filter, JUnitCoreParameters jUnitCoreParameters, JUnitCore junitCore) throws TestSetFailedException {
        Class[] tests = testsToRun.getLocatedClasses();
        Computer computer = JUnitCoreWrapper.createComputer(jUnitCoreParameters);
        JUnitCoreWrapper.createRequestAndRun(filter, computer, junitCore, tests);
    }

    private static void executeLazy(TestsToRun testsToRun, Filter filter, JUnitCoreParameters jUnitCoreParameters, JUnitCore junitCore) throws TestSetFailedException {
        for (Class clazz : testsToRun) {
            Computer computer = JUnitCoreWrapper.createComputer(jUnitCoreParameters);
            JUnitCoreWrapper.createRequestAndRun(filter, computer, junitCore, clazz);
        }
    }

    private static void createRequestAndRun(Filter filter, Computer computer, JUnitCore junitCore, Class<?> ... classesToRun) throws TestSetFailedException {
        String timeoutMessage;
        Request req = Request.classes((Computer)computer, (Class[])classesToRun);
        if (filter != null && (req = new FilteringRequest(req, filter)).getRunner() == null) {
            return;
        }
        Result run = junitCore.run(req);
        JUnit4RunListener.rethrowAnyTestMechanismFailures(run);
        if (computer instanceof ParallelComputer && (timeoutMessage = ((ParallelComputer)computer).describeElapsedTimeout()).length() != 0) {
            throw new TestSetFailedException(timeoutMessage);
        }
    }

    private static Computer createComputer(JUnitCoreParameters parameters) throws TestSetFailedException {
        return parameters.isNoThreading() ? Computer.serial() : new ParallelComputerBuilder(parameters).buildComputer();
    }

    private static class FilteringRequest
    extends Request {
        private Runner filteredRunner;

        public FilteringRequest(Request req, Filter filter) {
            try {
                Runner runner = req.getRunner();
                filter.apply((Object)runner);
                this.filteredRunner = runner;
            }
            catch (NoTestsRemainException e) {
                this.filteredRunner = null;
            }
        }

        public Runner getRunner() {
            return this.filteredRunner;
        }
    }
}

