/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JUnitCoreParameters {
    public static final String PARALLEL_KEY = "parallel";
    public static final String PERCORETHREADCOUNT_KEY = "perCoreThreadCount";
    public static final String THREADCOUNT_KEY = "threadcount";
    public static final String THREADCOUNTSUITES_KEY = "threadcountsuites";
    public static final String THREADCOUNTCLASSES_KEY = "threadcountclasses";
    public static final String THREADCOUNTMETHODS_KEY = "threadcountmethods";
    public static final String USEUNLIMITEDTHREADS_KEY = "useUnlimitedThreads";
    public static final String PARALLEL_TIMEOUT_KEY = "paralleltimeout";
    public static final String PARALLEL_TIMEOUTFORCED_KEY = "paralleltimeoutforced";
    public static final String PARALLEL_OPTIMIZE_KEY = "paralleloptimization";
    private final String parallel;
    private final Boolean perCoreThreadCount;
    private final int threadCount;
    private final int threadCountSuites;
    private final int threadCountClasses;
    private final int threadCountMethods;
    private final double parallelTestsTimeoutInSeconds;
    private final double parallelTestsTimeoutForcedInSeconds;
    private final Boolean useUnlimitedThreads;
    private final boolean parallelOptimization;

    public JUnitCoreParameters(Properties properties) {
        this.parallel = properties.getProperty(PARALLEL_KEY, "none").toLowerCase();
        this.perCoreThreadCount = Boolean.valueOf(properties.getProperty(PERCORETHREADCOUNT_KEY, "true"));
        this.threadCount = Integer.valueOf(properties.getProperty(THREADCOUNT_KEY, "0"));
        this.threadCountMethods = Integer.valueOf(properties.getProperty(THREADCOUNTMETHODS_KEY, "0"));
        this.threadCountClasses = Integer.valueOf(properties.getProperty(THREADCOUNTCLASSES_KEY, "0"));
        this.threadCountSuites = Integer.valueOf(properties.getProperty(THREADCOUNTSUITES_KEY, "0"));
        this.useUnlimitedThreads = Boolean.valueOf(properties.getProperty(USEUNLIMITEDTHREADS_KEY, "false"));
        this.parallelTestsTimeoutInSeconds = Math.max(Double.valueOf(properties.getProperty(PARALLEL_TIMEOUT_KEY, "0")), 0.0);
        this.parallelTestsTimeoutForcedInSeconds = Math.max(Double.valueOf(properties.getProperty(PARALLEL_TIMEOUTFORCED_KEY, "0")), 0.0);
        this.parallelOptimization = Boolean.valueOf(properties.getProperty(PARALLEL_OPTIMIZE_KEY, "true"));
    }

    private static Collection<String> lowerCase(String ... elements) {
        ArrayList<String> lowerCase = new ArrayList<String>();
        for (String element : elements) {
            lowerCase.add(element.toLowerCase());
        }
        return lowerCase;
    }

    private boolean isAllParallel() {
        return "all".equals(this.parallel);
    }

    public boolean isParallelMethods() {
        return this.isAllParallel() || JUnitCoreParameters.lowerCase("both", "methods", "suitesAndMethods", "classesAndMethods").contains(this.parallel);
    }

    public boolean isParallelClasses() {
        return this.isAllParallel() || JUnitCoreParameters.lowerCase("both", "classes", "suitesAndClasses", "classesAndMethods").contains(this.parallel);
    }

    public boolean isParallelSuites() {
        return this.isAllParallel() || JUnitCoreParameters.lowerCase("suites", "suitesAndClasses", "suitesAndMethods").contains(this.parallel);
    }

    @Deprecated
    public boolean isParallelBoth() {
        return this.isParallelMethods() && this.isParallelClasses();
    }

    public Boolean isPerCoreThreadCount() {
        return this.perCoreThreadCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getThreadCountMethods() {
        return this.threadCountMethods;
    }

    public int getThreadCountClasses() {
        return this.threadCountClasses;
    }

    public int getThreadCountSuites() {
        return this.threadCountSuites;
    }

    public Boolean isUseUnlimitedThreads() {
        return this.useUnlimitedThreads;
    }

    public double getParallelTestsTimeoutInSeconds() {
        return this.parallelTestsTimeoutInSeconds;
    }

    public double getParallelTestsTimeoutForcedInSeconds() {
        return this.parallelTestsTimeoutForcedInSeconds;
    }

    public boolean isNoThreading() {
        return !this.isParallelismSelected();
    }

    public boolean isParallelismSelected() {
        return this.isParallelSuites() || this.isParallelClasses() || this.isParallelMethods();
    }

    public boolean isParallelOptimization() {
        return this.parallelOptimization;
    }

    public String toString() {
        return "parallel='" + this.parallel + '\'' + ", perCoreThreadCount=" + this.perCoreThreadCount + ", threadCount=" + this.threadCount + ", useUnlimitedThreads=" + this.useUnlimitedThreads + ", threadCountSuites=" + this.threadCountSuites + ", threadCountClasses=" + this.threadCountClasses + ", threadCountMethods=" + this.threadCountMethods + ", parallelOptimization=" + this.parallelOptimization;
    }
}

