/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.maven.surefire.api.report.LegacyPojoStackTraceWriter;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.SimpleReportEntry;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.junit.JUnit3Reporter;
import org.apache.maven.surefire.junit.SurefireTestSetExecutor;
import org.apache.maven.surefire.report.ClassMethodIndexer;

public class PojoTestSetExecutor
implements SurefireTestSetExecutor {
    private static final String TEST_METHOD_PREFIX = "test";
    private static final String SETUP_METHOD_NAME = "setUp";
    private static final String TEARDOWN_METHOD_NAME = "tearDown";
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final JUnit3Reporter reporter;

    public PojoTestSetExecutor(JUnit3Reporter reporter) {
        this.reporter = Objects.requireNonNull(reporter, "reportManager is null");
    }

    @Override
    public void execute(Class<?> testClass, ClassLoader loader) throws TestSetFailedException {
        ClassMethodIndexer indexer;
        long testRunId;
        Method testMethod;
        boolean abort;
        DiscoveredTestMethods discoveredTestMethods = this.discoverTestMethods(Objects.requireNonNull(testClass));
        Iterator<Method> iterator = discoveredTestMethods.testMethods.iterator();
        while (iterator.hasNext() && !(abort = this.executeTestMethod(testClass, testMethod = iterator.next(), testRunId = (indexer = this.reporter.getClassMethodIndexer()).indexClassMethod(testClass.getName(), testMethod.getName()), discoveredTestMethods))) {
        }
    }

    private boolean executeTestMethod(Class<?> testClass, Method method, long testRunId, DiscoveredTestMethods methods) throws TestSetFailedException {
        LegacyPojoStackTraceWriter stackTraceWriter;
        Object testObject;
        try {
            testObject = testClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new TestSetFailedException("Unable to instantiate POJO '" + testClass + "'.", (Throwable)e);
        }
        String testClassName = testClass.getName();
        String methodName = method.getName();
        String userFriendlyMethodName = methodName + "()";
        String testName = this.getTestName(testClassName, userFriendlyMethodName);
        this.reporter.testStarting((ReportEntry)new SimpleReportEntry(RunMode.NORMAL_RUN, Long.valueOf(testRunId), testClassName, null, testName, null));
        try {
            this.setUpFixture(testObject, methods);
        }
        catch (Throwable e) {
            LegacyPojoStackTraceWriter stackTraceWriter2 = new LegacyPojoStackTraceWriter(testClassName, methodName, e);
            this.reporter.testFailed((ReportEntry)SimpleReportEntry.withException((RunMode)RunMode.NORMAL_RUN, (Long)testRunId, (String)testClassName, null, (String)testName, null, (StackTraceWriter)stackTraceWriter2));
            return true;
        }
        try {
            method.invoke(testObject, EMPTY_OBJECT_ARRAY);
            this.reporter.testSucceeded((ReportEntry)new SimpleReportEntry(RunMode.NORMAL_RUN, Long.valueOf(testRunId), testClassName, null, testName, null));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            LegacyPojoStackTraceWriter stackTraceWriter3 = new LegacyPojoStackTraceWriter(testClassName, methodName, t);
            this.reporter.testFailed((ReportEntry)SimpleReportEntry.withException((RunMode)RunMode.NORMAL_RUN, (Long)testRunId, (String)testClassName, null, (String)testName, null, (StackTraceWriter)stackTraceWriter3));
        }
        catch (Throwable t) {
            stackTraceWriter = new LegacyPojoStackTraceWriter(testClassName, methodName, t);
            this.reporter.testFailed((ReportEntry)SimpleReportEntry.withException((RunMode)RunMode.NORMAL_RUN, (Long)testRunId, (String)testClassName, null, (String)testName, null, (StackTraceWriter)stackTraceWriter));
        }
        try {
            this.tearDownFixture(testObject, methods);
        }
        catch (Throwable t) {
            stackTraceWriter = new LegacyPojoStackTraceWriter(testClassName, methodName, t);
            this.reporter.testFailed((ReportEntry)SimpleReportEntry.withException((RunMode)RunMode.NORMAL_RUN, (Long)testRunId, (String)testClassName, null, (String)testName, null, (StackTraceWriter)stackTraceWriter));
            return true;
        }
        return false;
    }

    private String getTestName(String testClassName, String testMethodName) {
        return testClassName + "." + Objects.requireNonNull(testMethodName, "testMethodName is null");
    }

    private void setUpFixture(Object testObject, DiscoveredTestMethods methods) throws Throwable {
        if (methods.setUpMethod != null) {
            methods.setUpMethod.invoke(testObject, new Object[0]);
        }
    }

    private void tearDownFixture(Object testObject, DiscoveredTestMethods methods) throws Throwable {
        if (methods.tearDownMethod != null) {
            methods.tearDownMethod.invoke(testObject, new Object[0]);
        }
    }

    private DiscoveredTestMethods discoverTestMethods(Class<?> testClass) {
        DiscoveredTestMethods methods = new DiscoveredTestMethods();
        for (Method m : testClass.getMethods()) {
            if (!PojoTestSetExecutor.isNoArgsInstanceMethod(m)) continue;
            if (PojoTestSetExecutor.isValidTestMethod(m)) {
                methods.testMethods.add(m);
                continue;
            }
            if (SETUP_METHOD_NAME.equals(m.getName())) {
                methods.setUpMethod = m;
                continue;
            }
            if (!TEARDOWN_METHOD_NAME.equals(m.getName())) continue;
            methods.tearDownMethod = m;
        }
        return methods;
    }

    private static boolean isNoArgsInstanceMethod(Method m) {
        boolean isInstanceMethod = !Modifier.isStatic(m.getModifiers());
        boolean returnsVoid = m.getReturnType().equals(Void.TYPE);
        boolean hasNoParams = m.getParameterTypes().length == 0;
        return isInstanceMethod && returnsVoid && hasNoParams;
    }

    private static boolean isValidTestMethod(Method m) {
        return m.getName().startsWith(TEST_METHOD_PREFIX);
    }

    private static class DiscoveredTestMethods {
        final Collection<Method> testMethods = new ArrayList<Method>();
        Method setUpMethod;
        Method tearDownMethod;

        private DiscoveredTestMethods() {
        }
    }
}

