/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import javax.annotation.Nonnull;

final class ProcessInfo {
    static final ProcessInfo INVALID_PROCESS_INFO = new ProcessInfo(null, 0L);
    static final ProcessInfo ERR_PROCESS_INFO = new ProcessInfo(null, 0L);
    private final String pid;
    private final long time;

    @Nonnull
    static ProcessInfo unixProcessInfo(String pid, long etime) {
        return new ProcessInfo(pid, etime);
    }

    @Nonnull
    static ProcessInfo windowsProcessInfo(String pid, long startTimestamp) {
        return new ProcessInfo(pid, startTimestamp);
    }

    @Nonnull
    static ProcessInfo processHandleInfo(String pid, long startTimeMillis) {
        return new ProcessInfo(pid, startTimeMillis);
    }

    private ProcessInfo(String pid, long time) {
        this.pid = pid;
        this.time = time;
    }

    boolean canUse() {
        return !this.isError();
    }

    boolean isInvalid() {
        return this == INVALID_PROCESS_INFO;
    }

    boolean isError() {
        return this == ERR_PROCESS_INFO;
    }

    String getPID() {
        this.checkValid();
        return this.pid;
    }

    long getTime() {
        this.checkValid();
        return this.time;
    }

    boolean isTimeEqualTo(ProcessInfo that) {
        this.checkValid();
        that.checkValid();
        return this.time == that.time;
    }

    boolean isTimeBefore(ProcessInfo that) {
        this.checkValid();
        that.checkValid();
        return this.time < that.time;
    }

    private void checkValid() {
        if (!this.canUse()) {
            throw new IllegalStateException("invalid process info");
        }
    }
}

