/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.lang.reflect.Method;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.apache.maven.surefire.booter.ProcessChecker;
import org.apache.maven.surefire.booter.ProcessInfo;

final class ProcessHandleChecker
implements ProcessChecker {
    private static final boolean AVAILABLE;
    private static final Method PROCESS_HANDLE_OF;
    private static final Method PROCESS_HANDLE_IS_ALIVE;
    private static final Method PROCESS_HANDLE_INFO;
    private static final Method INFO_START_INSTANT;
    private static final Method INSTANT_TO_EPOCH_MILLI;
    private final long pid;
    private final Object processHandle;
    private volatile Object initialStartInstant;
    private volatile boolean stopped;

    ProcessHandleChecker(@Nonnull String pid) {
        this.pid = Long.parseLong(pid);
        try {
            Optional optionalObject = (Optional)PROCESS_HANDLE_OF.invoke(null, this.pid);
            this.processHandle = optionalObject.orElse(null);
            this.initialStartInstant = this.getInitialStartInstant();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize ProcessHandleChecker for PID " + pid, e);
        }
    }

    static boolean isAvailable() {
        return AVAILABLE;
    }

    @Override
    public boolean canUse() {
        return AVAILABLE && !this.stopped;
    }

    @Override
    public boolean isProcessAlive() {
        if (!this.canUse()) {
            throw new IllegalStateException("irrelevant to call isProcessAlive()");
        }
        try {
            Object info;
            Optional optionalInstant;
            boolean isAlive = (Boolean)ReflectionUtils.invokeMethodWithArray((Object)this.processHandle, (Method)PROCESS_HANDLE_IS_ALIVE, (Object[])new Object[0]);
            if (!isAlive) {
                return false;
            }
            if (this.initialStartInstant != null && (optionalInstant = (Optional)ReflectionUtils.invokeMethodWithArray((Object)(info = ReflectionUtils.invokeMethodWithArray((Object)this.processHandle, (Method)PROCESS_HANDLE_INFO, (Object[])new Object[0])), (Method)INFO_START_INSTANT, (Object[])new Object[0])).isPresent()) {
                Object currentStartInstant = optionalInstant.get();
                return currentStartInstant.equals(this.initialStartInstant);
            }
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private Object getInitialStartInstant() {
        try {
            Object info = ReflectionUtils.invokeMethodWithArray((Object)this.processHandle, (Method)PROCESS_HANDLE_INFO, (Object[])new Object[0]);
            Optional optionalInstant = (Optional)ReflectionUtils.invokeMethodWithArray((Object)info, (Method)INFO_START_INSTANT, (Object[])new Object[0]);
            return optionalInstant.orElse(null);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Override
    public void destroyActiveCommands() {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    @Override
    public ProcessInfo processInfo() {
        Object startInstant = this.getInitialStartInstant();
        if (startInstant == null || INSTANT_TO_EPOCH_MILLI == null) {
            return null;
        }
        try {
            long startTimeMillis = (Long)ReflectionUtils.invokeMethodWithArray((Object)startInstant, (Method)INSTANT_TO_EPOCH_MILLI, (Object[])new Object[0]);
            return ProcessInfo.processHandleInfo(String.valueOf(this.pid), startTimeMillis);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public String toString() {
        String args = "pid=" + this.pid + ", stopped=" + this.stopped + ", hasHandle=" + (this.processHandle != null);
        if (this.initialStartInstant != null) {
            args = args + ", startInstant=" + this.initialStartInstant;
        }
        return "ProcessHandleChecker{" + args + "}";
    }

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class processHandleClass = ReflectionUtils.tryLoadClass((ClassLoader)classLoader, (String)"java.lang.ProcessHandle");
        Class processHandleInfoClass = ReflectionUtils.tryLoadClass((ClassLoader)classLoader, (String)"java.lang.ProcessHandle$Info");
        Class optionalClass = ReflectionUtils.tryLoadClass((ClassLoader)classLoader, (String)"java.util.Optional");
        Class instantClass = ReflectionUtils.tryLoadClass((ClassLoader)classLoader, (String)"java.time.Instant");
        Method processHandleOf = null;
        Method processHandleIsAlive = null;
        Method processHandleInfo = null;
        Method infoStartInstant = null;
        Method optionalIsPresent = null;
        Method optionalGet = null;
        Method optionalOrElse = null;
        Method instantToEpochMilli = null;
        if (processHandleClass != null && processHandleInfoClass != null && optionalClass != null) {
            processHandleOf = ReflectionUtils.tryGetMethod((Class)processHandleClass, (String)"of", (Class[])new Class[]{Long.TYPE});
            processHandleIsAlive = ReflectionUtils.tryGetMethod((Class)processHandleClass, (String)"isAlive", (Class[])new Class[0]);
            processHandleInfo = ReflectionUtils.tryGetMethod((Class)processHandleClass, (String)"info", (Class[])new Class[0]);
            infoStartInstant = ReflectionUtils.tryGetMethod((Class)processHandleInfoClass, (String)"startInstant", (Class[])new Class[0]);
            optionalIsPresent = ReflectionUtils.tryGetMethod((Class)optionalClass, (String)"isPresent", (Class[])new Class[0]);
            optionalGet = ReflectionUtils.tryGetMethod((Class)optionalClass, (String)"get", (Class[])new Class[0]);
            optionalOrElse = ReflectionUtils.tryGetMethod((Class)optionalClass, (String)"orElse", (Class[])new Class[]{Object.class});
            if (instantClass != null) {
                instantToEpochMilli = ReflectionUtils.tryGetMethod((Class)instantClass, (String)"toEpochMilli", (Class[])new Class[0]);
            }
        }
        AVAILABLE = processHandleOf != null && processHandleIsAlive != null && processHandleInfo != null && infoStartInstant != null && optionalIsPresent != null && optionalGet != null && optionalOrElse != null;
        PROCESS_HANDLE_OF = processHandleOf;
        PROCESS_HANDLE_IS_ALIVE = processHandleIsAlive;
        PROCESS_HANDLE_INFO = processHandleInfo;
        INFO_START_INSTANT = infoStartInstant;
        INSTANT_TO_EPOCH_MILLI = instantToEpochMilli;
    }
}

