/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

public class IsolatedClassLoader
extends URLClassLoader {
    private ClassLoader parent = ClassLoader.getSystemClassLoader();
    private Set urls = new HashSet();
    private boolean childDelegation = true;

    public IsolatedClassLoader() {
        super(new URL[0], (ClassLoader)null);
    }

    public IsolatedClassLoader(ClassLoader parent, boolean childDelegation) {
        super(new URL[0], parent);
        this.childDelegation = childDelegation;
    }

    public IsolatedClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public void addURL(URL url) {
        if (!this.urls.contains(url)) {
            super.addURL(url);
        } else {
            this.urls.add(url);
        }
    }

    public synchronized Class loadClass(String className) throws ClassNotFoundException {
        Class<?> c;
        if (this.childDelegation) {
            ClassNotFoundException ex;
            block6: {
                c = this.findLoadedClass(className);
                ex = null;
                if (c == null) {
                    try {
                        c = this.findClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        ex = e;
                        if (this.parent == null) break block6;
                        c = this.parent.loadClass(className);
                    }
                }
            }
            if (c == null) {
                throw ex;
            }
        } else {
            c = super.loadClass(className);
        }
        return c;
    }
}

