/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testset;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.maven.surefire.shade.api.org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.surefire.shade.api.org.apache.maven.shared.utils.io.MatchPatterns;
import org.apache.maven.surefire.shade.api.org.apache.maven.shared.utils.io.SelectorUtils;

@Deprecated
public final class ResolvedTest {
    private static final String CLASS_FILE_EXTENSION = ".class";
    private static final String JAVA_FILE_EXTENSION = ".java";
    private static final String WILDCARD_PATH_PREFIX = "**/";
    private static final String WILDCARD_FILENAME_POSTFIX = ".*";
    private final String classPattern;
    private final String methodPattern;
    private final boolean isRegexTestClassPattern;
    private final boolean isRegexTestMethodPattern;
    private final String description;
    private final ClassMatcher classMatcher = new ClassMatcher();
    private final MethodMatcher methodMatcher = new MethodMatcher();

    public ResolvedTest(String classPattern, String methodPattern, boolean isRegex) {
        classPattern = ResolvedTest.tryBlank(classPattern);
        methodPattern = ResolvedTest.tryBlank(methodPattern);
        this.description = ResolvedTest.description(classPattern, methodPattern, isRegex);
        if (isRegex && classPattern != null) {
            classPattern = ResolvedTest.wrapRegex(classPattern);
        }
        if (isRegex && methodPattern != null) {
            methodPattern = ResolvedTest.wrapRegex(methodPattern);
        }
        this.classPattern = ResolvedTest.reformatClassPattern(classPattern, isRegex);
        this.methodPattern = methodPattern;
        this.isRegexTestClassPattern = isRegex;
        this.isRegexTestMethodPattern = isRegex;
        this.methodMatcher.sanityCheck();
    }

    public ResolvedTest(Type type, String pattern, boolean isRegex) {
        pattern = ResolvedTest.tryBlank(pattern);
        boolean isClass = type == Type.CLASS;
        this.description = ResolvedTest.description(isClass ? pattern : null, !isClass ? pattern : null, isRegex);
        if (isRegex && pattern != null) {
            pattern = ResolvedTest.wrapRegex(pattern);
        }
        this.classPattern = isClass ? ResolvedTest.reformatClassPattern(pattern, isRegex) : null;
        this.methodPattern = !isClass ? pattern : null;
        this.isRegexTestClassPattern = isRegex && isClass;
        this.isRegexTestMethodPattern = isRegex && !isClass;
        this.methodMatcher.sanityCheck();
    }

    public String getTestClassPattern() {
        return this.classPattern;
    }

    public boolean hasTestClassPattern() {
        return this.classPattern != null;
    }

    public String getTestMethodPattern() {
        return this.methodPattern;
    }

    public boolean hasTestMethodPattern() {
        return this.methodPattern != null;
    }

    public boolean isRegexTestClassPattern() {
        return this.isRegexTestClassPattern;
    }

    public boolean isRegexTestMethodPattern() {
        return this.isRegexTestMethodPattern;
    }

    public boolean isEmpty() {
        return this.classPattern == null && this.methodPattern == null;
    }

    public boolean matchAsInclusive(String testClassFile, String methodName) {
        testClassFile = ResolvedTest.tryBlank(testClassFile);
        methodName = ResolvedTest.tryBlank(methodName);
        return this.isEmpty() || this.alwaysInclusiveQuietly(testClassFile) || this.match(testClassFile, methodName);
    }

    public boolean matchAsExclusive(String testClassFile, String methodName) {
        testClassFile = ResolvedTest.tryBlank(testClassFile);
        methodName = ResolvedTest.tryBlank(methodName);
        return !this.isEmpty() && this.canMatchExclusive(testClassFile, methodName) && this.match(testClassFile, methodName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedTest that = (ResolvedTest)o;
        return (this.classPattern == null ? that.classPattern == null : this.classPattern.equals(that.classPattern)) && (this.methodPattern == null ? that.methodPattern == null : this.methodPattern.equals(that.methodPattern));
    }

    public int hashCode() {
        int result = this.classPattern != null ? this.classPattern.hashCode() : 0;
        result = 31 * result + (this.methodPattern != null ? this.methodPattern.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.isEmpty() ? "" : this.description;
    }

    private static String description(String clazz, String method, boolean isRegex) {
        String description = clazz == null && method == null ? null : (clazz == null ? "#" + method : (method == null ? clazz : clazz + "#" + method));
        return isRegex && description != null ? ResolvedTest.wrapRegex(description) : description;
    }

    private boolean canMatchExclusive(String testClassFile, String methodName) {
        return this.canMatchExclusiveMethods(testClassFile, methodName) || this.canMatchExclusiveClasses(testClassFile, methodName) || this.canMatchExclusiveAll(testClassFile, methodName);
    }

    private boolean canMatchExclusiveMethods(String testClassFile, String methodName) {
        return testClassFile == null && methodName != null && this.classPattern == null && this.methodPattern != null;
    }

    private boolean canMatchExclusiveClasses(String testClassFile, String methodName) {
        return testClassFile != null && methodName == null && this.classPattern != null && this.methodPattern == null;
    }

    private boolean canMatchExclusiveAll(String testClassFile, String methodName) {
        return testClassFile != null && methodName != null && (this.classPattern != null || this.methodPattern != null);
    }

    private boolean alwaysInclusiveQuietly(String testClassFile) {
        return testClassFile == null && this.classPattern != null;
    }

    private boolean match(String testClassFile, String methodName) {
        return this.matchClass(testClassFile) && this.matchMethod(methodName);
    }

    private boolean matchClass(String testClassFile) {
        return this.classPattern == null || this.classMatcher.matchTestClassFile(testClassFile);
    }

    private boolean matchMethod(String methodName) {
        return this.methodPattern == null || methodName == null || this.methodMatcher.matchMethodName(methodName);
    }

    private static String tryBlank(String s) {
        if (s == null) {
            return null;
        }
        String trimmed = s.trim();
        return StringUtils.isEmpty(trimmed) ? null : trimmed;
    }

    private static String reformatClassPattern(String s, boolean isRegex) {
        if (s != null && !isRegex) {
            String path = ResolvedTest.convertToPath(s);
            if ((path = ResolvedTest.fromFullyQualifiedClass(path)) != null && !path.startsWith(WILDCARD_PATH_PREFIX)) {
                path = WILDCARD_PATH_PREFIX + path;
            }
            return path;
        }
        return s;
    }

    private static String convertToPath(String className) {
        if (StringUtils.isBlank(className)) {
            return null;
        }
        if (className.endsWith(JAVA_FILE_EXTENSION)) {
            className = className.substring(0, className.length() - JAVA_FILE_EXTENSION.length()) + CLASS_FILE_EXTENSION;
        }
        return className;
    }

    static String wrapRegex(String unwrapped) {
        return "%regex[" + unwrapped + "]";
    }

    static String fromFullyQualifiedClass(String cls) {
        if (cls.endsWith(CLASS_FILE_EXTENSION)) {
            String className = cls.substring(0, cls.length() - CLASS_FILE_EXTENSION.length());
            return className.replace('.', '/') + CLASS_FILE_EXTENSION;
        }
        if (!cls.contains("/")) {
            if (cls.endsWith(WILDCARD_FILENAME_POSTFIX)) {
                String clsName = cls.substring(0, cls.length() - WILDCARD_FILENAME_POSTFIX.length());
                return clsName.contains(".") ? clsName.replace('.', '/') + WILDCARD_FILENAME_POSTFIX : cls;
            }
            return cls.replace('.', '/');
        }
        return cls;
    }

    private static void checkIllegalCharacters(String ... expressions) {
        for (String expression : expressions) {
            if (!expression.contains("#")) continue;
            throw new IllegalArgumentException("Extra '#' in regex: " + expression);
        }
    }

    private static void throwSanityError(IllegalArgumentException e) {
        throw new IllegalArgumentException("%regex[] usage rule violation, valid regex rules:\n * <classNameRegex>#<methodNameRegex> - where both regex can be individually evaluated as a regex\n * you may use at most 1 '#' to in one regex filter. " + e.getLocalizedMessage(), e);
    }

    private final class MethodMatcher {
        private volatile Pattern cache;

        private MethodMatcher() {
        }

        boolean matchMethodName(String methodName) {
            if (ResolvedTest.this.isRegexTestMethodPattern()) {
                this.fetchCache();
                return this.cache.matcher(methodName).matches();
            }
            return SelectorUtils.matchPath(ResolvedTest.this.methodPattern, methodName);
        }

        void sanityCheck() {
            if (ResolvedTest.this.isRegexTestMethodPattern() && ResolvedTest.this.hasTestMethodPattern()) {
                try {
                    ResolvedTest.checkIllegalCharacters(new String[]{ResolvedTest.this.methodPattern});
                    this.fetchCache();
                }
                catch (IllegalArgumentException e) {
                    ResolvedTest.throwSanityError(e);
                }
            }
        }

        private void fetchCache() {
            if (this.cache == null) {
                int from = "%regex[".length();
                int to = ResolvedTest.this.methodPattern.length() - "]".length();
                String pattern = ResolvedTest.this.methodPattern.substring(from, to);
                this.cache = Pattern.compile(pattern);
            }
        }
    }

    private final class ClassMatcher {
        private volatile MatchPatterns cache;

        private ClassMatcher() {
        }

        boolean matchTestClassFile(String testClassFile) {
            return ResolvedTest.this.isRegexTestClassPattern() ? this.matchClassRegexPatter(testClassFile) : this.matchClassPatter(testClassFile);
        }

        private MatchPatterns of(String ... sources) {
            if (this.cache == null) {
                try {
                    ResolvedTest.checkIllegalCharacters(sources);
                    this.cache = MatchPatterns.from(sources);
                }
                catch (IllegalArgumentException e) {
                    ResolvedTest.throwSanityError(e);
                }
            }
            return this.cache;
        }

        private boolean matchClassPatter(String testClassFile) {
            String classPattern = ResolvedTest.this.classPattern;
            if (File.separatorChar != '/') {
                testClassFile = testClassFile.replace('/', File.separatorChar);
                classPattern = classPattern.replace('/', File.separatorChar);
            }
            if (classPattern.endsWith(ResolvedTest.WILDCARD_FILENAME_POSTFIX) || classPattern.endsWith(ResolvedTest.CLASS_FILE_EXTENSION)) {
                return this.of(classPattern).matches(testClassFile, true);
            }
            String[] classPatterns = new String[]{classPattern + ResolvedTest.CLASS_FILE_EXTENSION, classPattern};
            return this.of(classPatterns).matches(testClassFile, true);
        }

        private boolean matchClassRegexPatter(String testClassFile) {
            String realFile = File.separatorChar == '/' ? testClassFile : testClassFile.replace('/', File.separatorChar);
            return this.of(ResolvedTest.this.classPattern).matches(realFile, true);
        }
    }

    public static enum Type {
        CLASS,
        METHOD;

    }
}

