/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util;

import java.util.Collections;
import java.util.List;
import org.apache.maven.surefire.testset.BatchParameters;
import org.apache.maven.surefire.util.TestListTransformer;

public class BatchTestListTransformer
implements TestListTransformer {
    private final int numberOfBatches;
    private final int batchNumber;

    public BatchTestListTransformer(BatchParameters batchParameters) {
        this(batchParameters.getNumberOfBatches(), batchParameters.getBatchNumber());
    }

    public BatchTestListTransformer(int numberOfBatches, int batchNumber) {
        if (numberOfBatches < 0 || batchNumber < 0) {
            throw new IllegalArgumentException("Invalid batch setting. Number of batches and batch number have to be positive");
        }
        this.numberOfBatches = numberOfBatches;
        this.batchNumber = batchNumber;
    }

    public List transformTestList(List testClasses) {
        int to;
        if (testClasses == null || this.numberOfBatches < 1) {
            return Collections.emptyList();
        }
        int size = testClasses.size();
        int batchSize = Math.max(1, size / this.numberOfBatches);
        int from = Math.max(0, (this.batchNumber - 1) * batchSize);
        if (this.batchNumber == this.numberOfBatches) {
            batchSize += size % this.numberOfBatches;
        }
        if (from > (to = Math.min(size, from + batchSize))) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(testClasses.subList(from, to));
    }
}

