/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testset;

public class BatchParameters {
    public static BatchParameters EMPTY_PARAMETERS = new BatchParameters(0, 0, false);
    private final int numberOfBatches;
    private final int batchNumber;
    private final boolean batchingEnabled;

    public static Builder builder() {
        return new Builder();
    }

    private BatchParameters(Builder builder) {
        this(builder.numberOfBatches, builder.batchNumber, builder.batchingEnabled);
    }

    private BatchParameters(int numberOfBatches, int batchNumber, boolean batchingEnabled) {
        this.numberOfBatches = numberOfBatches;
        this.batchNumber = batchNumber;
        this.batchingEnabled = batchingEnabled;
    }

    public int getNumberOfBatches() {
        return this.numberOfBatches;
    }

    public int getBatchNumber() {
        return this.batchNumber;
    }

    public boolean isBatchingEnabled() {
        return this.batchingEnabled;
    }

    public String toString() {
        return "BatchParameters{numberOfBatches=" + this.numberOfBatches + ", batchNumber=" + this.batchNumber + ", batchingEnabled=" + this.batchingEnabled + '}';
    }

    public static class Builder {
        private int numberOfBatches;
        private int batchNumber;
        private boolean batchingEnabled;

        public Builder numberOfBatches(int n) {
            this.numberOfBatches = n;
            return this;
        }

        public Builder batchNumber(int n) {
            this.batchNumber = n;
            return this;
        }

        public Builder batchingEnabled(boolean b) {
            this.batchingEnabled = b;
            return this;
        }

        public BatchParameters build() {
            return new BatchParameters(this);
        }
    }
}

