/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.util.Properties;
import org.apache.maven.surefire.booter.DirectoryScannerParametersAware;
import org.apache.maven.surefire.booter.ProviderPropertiesAware;
import org.apache.maven.surefire.booter.ReporterConfigurationAware;
import org.apache.maven.surefire.booter.SurefireClassLoadersAware;
import org.apache.maven.surefire.booter.TestArtifactInfoAware;
import org.apache.maven.surefire.booter.TestRequestAware;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.ReporterManagerFactory;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.util.DefaultDirectoryScanner;
import org.apache.maven.surefire.util.DirectoryScanner;

public class BaseProviderFactory
implements DirectoryScannerParametersAware,
ReporterConfigurationAware,
SurefireClassLoadersAware,
TestRequestAware,
ProviderPropertiesAware,
ProviderParameters,
TestArtifactInfoAware {
    private Properties providerProperties;
    private DirectoryScannerParameters directoryScannerParameters;
    private ReporterConfiguration reporterConfiguration;
    private ClassLoader testClassLoader;
    private ClassLoader surefireClassLoader;
    private TestRequest testRequest;
    private TestArtifactInfo testArtifactInfo;

    public DirectoryScanner getDirectoryScanner() {
        if (this.directoryScannerParameters == null) {
            return null;
        }
        return new DefaultDirectoryScanner(this.directoryScannerParameters.getTestClassesDirectory(), this.directoryScannerParameters.getIncludes(), this.directoryScannerParameters.getExcludes(), this.directoryScannerParameters.getRunOrder(), this.directoryScannerParameters.getBatchParameters());
    }

    public ReporterFactory getReporterFactory() {
        ReporterManagerFactory reporterManagerFactory = new ReporterManagerFactory(this.surefireClassLoader, this.reporterConfiguration);
        if (this.providerProperties != null) {
            reporterManagerFactory.getGlobalRunStatistics().initResultsFromProperties(this.providerProperties);
        }
        return reporterManagerFactory;
    }

    public void setDirectoryScannerParameters(DirectoryScannerParameters directoryScannerParameters) {
        this.directoryScannerParameters = directoryScannerParameters;
    }

    public void setReporterConfiguration(ReporterConfiguration reporterConfiguration) {
        this.reporterConfiguration = reporterConfiguration;
    }

    public void setClassLoaders(ClassLoader surefireClassLoader, ClassLoader testClassLoader) {
        this.surefireClassLoader = surefireClassLoader;
        this.testClassLoader = testClassLoader;
    }

    public void setTestRequest(TestRequest testRequest) {
        this.testRequest = testRequest;
    }

    public DirectoryScannerParameters getDirectoryScannerParameters() {
        return this.directoryScannerParameters;
    }

    public ReporterConfiguration getReporterConfiguration() {
        return this.reporterConfiguration;
    }

    public TestRequest getTestRequest() {
        return this.testRequest;
    }

    public ClassLoader getTestClassLoader() {
        return this.testClassLoader;
    }

    public void setProviderProperties(Properties providerProperties) {
        this.providerProperties = providerProperties;
    }

    public Properties getProviderProperties() {
        return this.providerProperties;
    }

    public TestArtifactInfo getTestArtifactInfo() {
        return this.testArtifactInfo;
    }

    public void setTestArtifactInfo(TestArtifactInfo testArtifactInfo) {
        this.testArtifactInfo = testArtifactInfo;
    }
}

