/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ForkedBooter;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.util.UrlUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class ForkConfiguration {
    public static final String FORK_ONCE = "once";
    public static final String FORK_ALWAYS = "always";
    public static final String FORK_NEVER = "never";
    private final Classpath bootClasspathConfiguration;
    private final String forkMode;
    private Properties systemProperties;
    private String jvmExecutable;
    private String argLine;
    private Map environmentVariables;
    private File workingDirectory;
    private File tempDirectory;
    private boolean debug;
    private String debugLine;

    public ForkConfiguration(Classpath bootClasspathConfiguration, String forkMode, File tmpDir) {
        this.bootClasspathConfiguration = bootClasspathConfiguration;
        this.forkMode = ForkConfiguration.getForkMode(forkMode);
        this.tempDirectory = tmpDir;
    }

    public Classpath getBootClasspath() {
        return this.bootClasspathConfiguration;
    }

    private static String getForkMode(String forkMode) {
        if ("pertest".equalsIgnoreCase(forkMode)) {
            return FORK_ALWAYS;
        }
        if ("none".equalsIgnoreCase(forkMode)) {
            return FORK_NEVER;
        }
        if (forkMode.equals(FORK_NEVER) || forkMode.equals(FORK_ONCE) || forkMode.equals(FORK_ALWAYS)) {
            return forkMode;
        }
        throw new IllegalArgumentException("Fork mode " + forkMode + " is not a legal value");
    }

    public boolean isForking() {
        return !FORK_NEVER.equals(this.forkMode);
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = (Properties)systemProperties.clone();
    }

    public void setJvmExecutable(String jvmExecutable) {
        this.jvmExecutable = jvmExecutable;
    }

    public void setArgLine(String argLine) {
        this.argLine = argLine;
    }

    public void setDebugLine(String debugLine) {
        this.debugLine = debugLine;
    }

    public void setEnvironmentVariables(Map environmentVariables) {
        this.environmentVariables = new HashMap(environmentVariables);
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public String getForkMode() {
        return this.forkMode;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public Commandline createCommandLine(List classPath, ClassLoaderConfiguration classpathConfiguration) throws SurefireBooterForkException {
        return this.createCommandLine(classPath, classpathConfiguration.isManifestOnlyJarRequestedAndUsable());
    }

    public Commandline createCommandLine(List classPath, boolean useJar) throws SurefireBooterForkException {
        Commandline cli = new Commandline();
        cli.setExecutable(this.jvmExecutable);
        if (this.argLine != null) {
            cli.createArg().setLine(this.stripNewLines(this.argLine));
        }
        if (this.environmentVariables != null) {
            Iterator iter = this.environmentVariables.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)this.environmentVariables.get(key);
                cli.addEnvironment(key, value);
            }
        }
        if (this.getDebugLine() != null && !"".equals(this.getDebugLine())) {
            cli.createArg().setLine(this.getDebugLine());
        }
        if (useJar) {
            File jarFile;
            try {
                jarFile = this.createJar(classPath);
            }
            catch (IOException e) {
                throw new SurefireBooterForkException("Error creating archive file", (Throwable)e);
            }
            cli.createArg().setValue("-jar");
            cli.createArg().setValue(jarFile.getAbsolutePath());
        } else {
            cli.createArg().setValue("-classpath");
            cli.createArg().setValue(StringUtils.join(classPath.iterator(), (String)File.pathSeparator));
            cli.createArg().setValue(ForkedBooter.class.getName());
        }
        cli.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
        return cli;
    }

    public File createJar(List classPath) throws IOException {
        File file = File.createTempFile("surefirebooter", ".jar", this.tempDirectory);
        if (!this.debug) {
            file.deleteOnExit();
        }
        FileOutputStream fos = new FileOutputStream(file);
        JarOutputStream jos = new JarOutputStream(fos);
        jos.setLevel(0);
        JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
        jos.putNextEntry(je);
        Manifest man = new Manifest();
        String cp = "";
        Iterator it = classPath.iterator();
        while (it.hasNext()) {
            String el = (String)it.next();
            cp = cp + UrlUtils.getURL((File)new File(el)).toExternalForm() + " ";
        }
        man.getMainAttributes().putValue("Manifest-Version", "1.0");
        man.getMainAttributes().putValue("Class-Path", cp.trim());
        man.getMainAttributes().putValue("Main-Class", ForkedBooter.class.getName());
        man.write(jos);
        jos.close();
        return file;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String stripNewLines(String argline) {
        return argline.replace("\n", " ").replace("\r", " ");
    }

    public String getDebugLine() {
        return this.debugLine;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }
}

