/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.StreamConsumer;

public class ThreadedStreamConsumer
implements StreamConsumer {
    private final BlockingQueue<String> items = new LinkedBlockingQueue<String>();
    private static final String poison = "Pioson";
    private final Thread thread;
    private final Pumper pumper;

    public ThreadedStreamConsumer(StreamConsumer target) {
        this.pumper = new Pumper(this.items, target);
        this.thread = new Thread((Runnable)this.pumper, "ThreadedStreamConsumer");
        this.thread.start();
    }

    public void consumeLine(String s) {
        this.items.add(s);
        if (this.items.size() > 10000) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void close() {
        try {
            this.items.add(poison);
            this.thread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.pumper.getThrowable() != null) {
            throw new RuntimeException(this.pumper.getThrowable());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pumper
    implements Runnable {
        private final BlockingQueue<String> queue;
        private final StreamConsumer target;
        private volatile Throwable throwable;

        Pumper(BlockingQueue<String> queue, StreamConsumer target) {
            this.queue = queue;
            this.target = target;
        }

        @Override
        public void run() {
            try {
                String item = this.queue.take();
                while (item != ThreadedStreamConsumer.poison) {
                    this.target.consumeLine(item);
                    item = this.queue.take();
                }
            }
            catch (Throwable t) {
                this.throwable = t;
            }
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

