/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import java.util.LinkedHashSet;
import org.apache.maven.surefire.common.junit48.CombinedCategoryFilter;
import org.apache.maven.surefire.common.junit48.RequestedTest;
import org.apache.maven.surefire.testset.ResolvedTest;
import org.apache.maven.surefire.testset.TestListResolver;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

final class MethodFilter
extends Filter {
    private final CombinedCategoryFilter combinedFilter;

    MethodFilter(String requestString) {
        this(new TestListResolver(requestString));
    }

    MethodFilter(TestListResolver testResolver) {
        LinkedHashSet<Filter> includedFilters = new LinkedHashSet<Filter>();
        LinkedHashSet<Filter> excludedFilters = new LinkedHashSet<Filter>();
        for (ResolvedTest test : testResolver.getIncludedPatterns()) {
            includedFilters.add(new RequestedTest(test));
        }
        for (ResolvedTest test : testResolver.getExcludedPatterns()) {
            excludedFilters.add(new RequestedTest(test));
        }
        this.combinedFilter = new CombinedCategoryFilter(includedFilters, excludedFilters);
    }

    public boolean shouldRun(Description description) {
        if (description.isEmpty()) {
            return false;
        }
        if (description.isTest()) {
            return this.combinedFilter.shouldRun(description);
        }
        for (Description o : description.getChildren()) {
            if (!this.combinedFilter.shouldRun(o) && !this.shouldRun(o)) continue;
            return true;
        }
        return false;
    }

    public String describe() {
        return this.combinedFilter.describe();
    }
}

