/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.shared.utils.io.SelectorUtils;
import org.apache.maven.surefire.group.match.AndGroupMatcher;
import org.apache.maven.surefire.group.match.GroupMatcher;
import org.apache.maven.surefire.group.match.InverseGroupMatcher;
import org.apache.maven.surefire.group.parse.GroupMatcherParser;
import org.apache.maven.surefire.group.parse.ParseException;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFactory {
    private final ClassLoader testClassLoader;

    public FilterFactory(ClassLoader testClassLoader) {
        this.testClassLoader = testClassLoader;
    }

    public Filter createGroupFilter(Properties providerProperties) {
        String groups = providerProperties.getProperty("groups");
        String excludedGroups = providerProperties.getProperty("excludegroups");
        GroupMatcher included = null;
        if (groups != null && groups.trim().length() > 0) {
            try {
                included = new GroupMatcherParser(groups).parse();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid group expression: '" + groups + "'. Reason: " + e.getMessage(), e);
            }
        }
        GroupMatcher excluded = null;
        if (excludedGroups != null && excludedGroups.trim().length() > 0) {
            try {
                excluded = new GroupMatcherParser(excludedGroups).parse();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid group expression: '" + excludedGroups + "'. Reason: " + e.getMessage(), e);
            }
        }
        if (included != null && this.testClassLoader != null) {
            included.loadGroupClasses(this.testClassLoader);
        }
        if (excluded != null && this.testClassLoader != null) {
            excluded.loadGroupClasses(this.testClassLoader);
        }
        return new GroupMatcherCategoryFilter(included, excluded);
    }

    public Filter createMethodFilter(String requestedTestMethod) {
        return new MethodFilter(requestedTestMethod);
    }

    public Filter createFailingMethodFilter(Map<Class<?>, Set<String>> failingClassMethodMap) {
        return new FailingMethodFilter(failingClassMethodMap);
    }

    public Filter and(Filter filter1, Filter filter2) {
        return new AndFilter(filter1, filter2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CombinedCategoryFilter
    extends Filter {
        private final List<Filter> includedFilters;
        private final List<Filter> excludedFilters;

        public CombinedCategoryFilter(List<Filter> includedFilters, List<Filter> excludedFilters) {
            this.includedFilters = includedFilters;
            this.excludedFilters = excludedFilters;
        }

        public boolean shouldRun(Description description) {
            return !(!this.includedFilters.isEmpty() && !this.inOneOfFilters(this.includedFilters, description) || !this.excludedFilters.isEmpty() && this.inOneOfFilters(this.excludedFilters, description));
        }

        private boolean inOneOfFilters(List<Filter> filters, Description description) {
            for (Filter f : filters) {
                if (!f.shouldRun(description)) continue;
                return true;
            }
            return false;
        }

        public String describe() {
            StringBuilder sb = new StringBuilder();
            if (!this.includedFilters.isEmpty()) {
                sb.append("(");
                sb.append(this.joinFilters(this.includedFilters, " OR "));
                sb.append(")");
                if (!this.excludedFilters.isEmpty()) {
                    sb.append(" AND ");
                }
            }
            if (!this.excludedFilters.isEmpty()) {
                sb.append("NOT (");
                sb.append(this.joinFilters(this.includedFilters, " OR "));
                sb.append(")");
            }
            return sb.toString();
        }

        private String joinFilters(List<Filter> filters, String sep) {
            boolean isFirst = true;
            StringBuilder sb = new StringBuilder();
            for (Filter f : filters) {
                if (!isFirst) {
                    sb.append(sep);
                }
                sb.append(f.describe());
                isFirst = false;
            }
            return sb.toString();
        }
    }

    private static class AndFilter
    extends Filter {
        private final Filter filter1;
        private final Filter filter2;

        public AndFilter(Filter filter1, Filter filter2) {
            this.filter1 = filter1;
            this.filter2 = filter2;
        }

        public boolean shouldRun(Description description) {
            return this.filter1.shouldRun(description) && this.filter2.shouldRun(description);
        }

        public String describe() {
            return this.filter1.describe() + " AND " + this.filter2.describe();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroupMatcherCategoryFilter
    extends Filter {
        private final AndGroupMatcher matcher;

        public GroupMatcherCategoryFilter(GroupMatcher included, GroupMatcher excluded) {
            InverseGroupMatcher invertedExclude;
            InverseGroupMatcher inverseGroupMatcher = invertedExclude = excluded == null ? null : new InverseGroupMatcher(excluded);
            if (included != null || invertedExclude != null) {
                this.matcher = new AndGroupMatcher(new GroupMatcher[0]);
                if (included != null) {
                    this.matcher.addMatcher(included);
                }
                if (invertedExclude != null) {
                    this.matcher.addMatcher((GroupMatcher)invertedExclude);
                }
            } else {
                this.matcher = null;
            }
        }

        public boolean shouldRun(Description description) {
            if (description.getMethodName() == null || description.getTestClass() == null) {
                return this.shouldRun(description, null, null);
            }
            return this.shouldRun(description, Description.createSuiteDescription((Class)description.getTestClass()), description.getTestClass());
        }

        private static void findSuperclassCategories(Set<Class<?>> cats, Class<?> clazz) {
            if (clazz != null && clazz.getSuperclass() != null) {
                Category cat = clazz.getSuperclass().getAnnotation(Category.class);
                if (cat != null) {
                    Collections.addAll(cats, cat.value());
                } else {
                    GroupMatcherCategoryFilter.findSuperclassCategories(cats, clazz.getSuperclass());
                }
            }
        }

        private boolean shouldRun(Description description, Description parent, Class<?> parentClass) {
            ArrayList children;
            Class testClass;
            if (this.matcher == null) {
                return true;
            }
            HashSet<Class<Object>> cats = new HashSet<Class<Object>>();
            Category cat = (Category)description.getAnnotation(Category.class);
            if (cat != null) {
                Collections.addAll(cats, cat.value());
            }
            if (parent != null && (cat = (Category)parent.getAnnotation(Category.class)) != null) {
                Collections.addAll(cats, cat.value());
            }
            if (parentClass != null) {
                GroupMatcherCategoryFilter.findSuperclassCategories(cats, parentClass);
            }
            if ((testClass = description.getTestClass()) != null && (cat = testClass.getAnnotation(Category.class)) != null) {
                Collections.addAll(cats, cat.value());
            }
            cats.removeAll(Collections.singleton(null));
            boolean result = this.matcher.enabled(cats.toArray(new Class[cats.size()]));
            if (!result && (children = description.getChildren()) != null) {
                for (Description child : children) {
                    if (!this.shouldRun(child, description, null)) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }

        public String describe() {
            return this.matcher == null ? "ANY" : this.matcher.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FailingMethodFilter
    extends Filter {
        private final Map<Class<?>, Set<String>> failingClassMethodMap;

        public FailingMethodFilter(Map<Class<?>, Set<String>> failingClassMethodMap) {
            this.failingClassMethodMap = failingClassMethodMap;
        }

        public boolean shouldRun(Description description) {
            return this.isDescriptionMatch(description);
        }

        private boolean isDescriptionMatch(Description description) {
            if (description.getTestClass() == null || description.getMethodName() == null) {
                for (Description childrenDescription : description.getChildren()) {
                    if (!this.isDescriptionMatch(childrenDescription)) continue;
                    return true;
                }
                return false;
            }
            Set<String> testMethods = this.failingClassMethodMap.get(description.getTestClass());
            return testMethods != null && testMethods.contains(description.getMethodName());
        }

        public String describe() {
            return "By failing class method";
        }
    }

    private static class MethodFilter
    extends Filter {
        private final String requestedTestMethod;

        public MethodFilter(String requestedTestMethod) {
            this.requestedTestMethod = requestedTestMethod;
        }

        public boolean shouldRun(Description description) {
            for (Description o : description.getChildren()) {
                if (!this.isDescriptionMatch(o) && !this.shouldRun(o)) continue;
                return true;
            }
            return this.isDescriptionMatch(description);
        }

        private boolean isDescriptionMatch(Description description) {
            return description.getMethodName() != null && SelectorUtils.match((String)this.requestedTestMethod, (String)description.getMethodName());
        }

        public String describe() {
            return "By method" + this.requestedTestMethod;
        }
    }
}

