/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.verifier.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.io.IOUtil;

public class ResourceExtractor {
    public static File simpleExtractResources(Class<?> cl, String resourcePath) throws IOException {
        String tempDirPath = System.getProperty("maven.test.tmpdir", System.getProperty("java.io.tmpdir"));
        File tempDir = new File(tempDirPath);
        File testDir = new File(tempDir, resourcePath);
        FileUtils.deleteDirectory((File)testDir);
        testDir = ResourceExtractor.extractResourcePath(cl, resourcePath, tempDir, false);
        return testDir;
    }

    public static File extractResourcePath(String resourcePath, File dest) throws IOException {
        return ResourceExtractor.extractResourcePath(ResourceExtractor.class, resourcePath, dest);
    }

    public static File extractResourcePath(Class<?> cl, String resourcePath, File dest) throws IOException {
        return ResourceExtractor.extractResourcePath(cl, resourcePath, dest, false);
    }

    public static File extractResourcePath(Class<?> cl, String resourcePath, File tempDir, boolean alwaysExtract) throws IOException {
        File dest = new File(tempDir, resourcePath);
        return ResourceExtractor.extractResourceToDestination(cl, resourcePath, dest, alwaysExtract);
    }

    public static File extractResourceToDestination(Class<?> cl, String resourcePath, File destination, boolean alwaysExtract) throws IOException {
        URL url = cl.getResource(resourcePath);
        if (url == null) {
            throw new IllegalArgumentException("Resource not found: " + resourcePath);
        }
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            File jarFile = ResourceExtractor.getJarFileFromUrl(url);
            ResourceExtractor.extractResourcePathFromJar(cl, jarFile, resourcePath, destination);
        } else {
            try {
                File resourceFile = new File(new URI(url.toExternalForm()));
                if (!alwaysExtract) {
                    return resourceFile;
                }
                if (resourceFile.isDirectory()) {
                    FileUtils.copyDirectoryStructure((File)resourceFile, (File)destination);
                } else {
                    FileUtils.copyFile((File)resourceFile, (File)destination);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Couldn't convert URL to File:" + url, e);
            }
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractResourcePathFromJar(Class<?> cl, File jarFile, String resourcePath, File dest) throws IOException {
        ZipFile z = new ZipFile(jarFile, 1);
        String zipStyleResourcePath = resourcePath.substring(1) + "/";
        ZipEntry ze = z.getEntry(zipStyleResourcePath);
        if (ze != null) {
            Enumeration<? extends ZipEntry> entries = z.entries();
            while (entries.hasMoreElements()) {
                ze = entries.nextElement();
                if (!ze.getName().startsWith(zipStyleResourcePath)) continue;
                String relativePath = ze.getName().substring(zipStyleResourcePath.length());
                File destFile = new File(dest, relativePath);
                if (ze.isDirectory()) {
                    destFile.mkdirs();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(destFile);
                try {
                    IOUtil.copy((InputStream)z.getInputStream(ze), (OutputStream)fos);
                }
                finally {
                    IOUtil.close((OutputStream)fos);
                    z.close();
                }
            }
        } else {
            FileOutputStream fos = new FileOutputStream(dest);
            try {
                IOUtil.copy((InputStream)cl.getResourceAsStream(resourcePath), (OutputStream)fos);
            }
            finally {
                IOUtil.close((OutputStream)fos);
                z.close();
            }
        }
    }

    private static File getJarFileFromUrl(URL url) {
        if (!"jar".equalsIgnoreCase(url.getProtocol())) {
            throw new IllegalArgumentException("This is not a Jar URL:" + url.toString());
        }
        String resourceFilePath = url.getFile();
        int index = resourceFilePath.indexOf("!");
        if (index == -1) {
            throw new RuntimeException("Bug! " + url.toExternalForm() + " does not have a '!'");
        }
        String jarFileURI = resourceFilePath.substring(0, index);
        try {
            File jarFile = new File(new URI(jarFileURI));
            return jarFile;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bug! URI failed to parse: " + jarFileURI, e);
        }
    }
}

