/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.verifier;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.verifier.Embedded3xLauncher;
import org.apache.maven.shared.verifier.ForkedLauncher;
import org.apache.maven.shared.verifier.LauncherException;
import org.apache.maven.shared.verifier.MavenLauncher;
import org.apache.maven.shared.verifier.VerificationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Verifier {
    private static final String LOG_FILENAME = "log.txt";
    private static final String[] DEFAULT_CLI_ARGUMENTS = new String[]{"-e", "--batch-mode"};
    private static final String CLEAN_CLI_ARGUMENT = "org.apache.maven.plugins:maven-clean-plugin:clean";
    private String localRepo;
    private final String basedir;
    private final String[] defaultCliArguments;
    private List<String> cliArguments = new ArrayList<String>();
    private Properties systemProperties = new Properties();
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    private Properties verifierProperties = new Properties();
    private boolean autoclean = true;
    private String localRepoLayout = "default";
    private Boolean forkJvm;
    private String logFileName = "log.txt";
    private String mavenHome;
    private boolean mavenDebug = false;
    private String forkMode;
    private boolean debugJvm = false;
    private boolean useWrapper;
    private static MavenLauncher embeddedLauncher;
    private static final String MARKER = "${artifact:";

    public Verifier(String basedir) throws VerificationException {
        this(basedir, null);
    }

    public Verifier(String basedir, boolean debug) throws VerificationException {
        this(basedir, null, debug);
    }

    public Verifier(String basedir, String settingsFile) throws VerificationException {
        this(basedir, settingsFile, false);
    }

    public Verifier(String basedir, String settingsFile, boolean debug) throws VerificationException {
        this(basedir, settingsFile, debug, DEFAULT_CLI_ARGUMENTS);
    }

    public Verifier(String basedir, String settingsFile, boolean debug, String[] defaultCliArguments) throws VerificationException {
        this(basedir, settingsFile, debug, null, defaultCliArguments);
    }

    public Verifier(String basedir, String settingsFile, boolean debug, boolean forkJvm) throws VerificationException {
        this(basedir, settingsFile, debug, forkJvm, DEFAULT_CLI_ARGUMENTS);
    }

    public Verifier(String basedir, String settingsFile, boolean debug, boolean forkJvm, String[] defaultCliArguments) throws VerificationException {
        this(basedir, settingsFile, debug, forkJvm, defaultCliArguments, null);
    }

    public Verifier(String basedir, String settingsFile, boolean debug, String mavenHome) throws VerificationException {
        this(basedir, settingsFile, debug, null, DEFAULT_CLI_ARGUMENTS, mavenHome);
    }

    public Verifier(String basedir, String settingsFile, boolean debug, String mavenHome, String[] defaultCliArguments) throws VerificationException {
        this(basedir, settingsFile, debug, null, defaultCliArguments, mavenHome);
    }

    private Verifier(String basedir, String settingsFile, boolean debug, Boolean forkJvm, String[] defaultCliArguments, String mavenHome) throws VerificationException {
        this.basedir = basedir;
        this.forkJvm = forkJvm;
        this.forkMode = System.getProperty("verifier.forkMode");
        this.findLocalRepo(settingsFile);
        if (mavenHome == null) {
            this.mavenHome = System.getProperty("maven.home");
            this.useWrapper = Files.exists(Paths.get(this.getBasedir(), "mvnw"), new LinkOption[0]);
        } else {
            this.mavenHome = mavenHome;
            this.useWrapper = false;
        }
        if (StringUtils.isEmpty((String)mavenHome) && StringUtils.isEmpty((String)this.forkMode)) {
            this.forkMode = "auto";
        }
        this.defaultCliArguments = defaultCliArguments == null ? new String[]{} : (String[])defaultCliArguments.clone();
    }

    public void setLocalRepo(String localRepo) {
        this.localRepo = localRepo;
    }

    @Deprecated
    public void resetStreams() {
    }

    @Deprecated
    public void displayStreamBuffers() {
    }

    public void verify(boolean chokeOnErrorOutput) throws VerificationException {
        List<String> lines = this.loadFile(this.getBasedir(), "expected-results.txt", false);
        for (String line : lines) {
            this.verifyExpectedResult(line);
        }
        if (chokeOnErrorOutput) {
            this.verifyErrorFreeLog();
        }
    }

    public void verifyErrorFreeLog() throws VerificationException {
        List<String> lines = this.loadFile(this.getBasedir(), this.getLogFileName(), false);
        for (String line : lines) {
            if (!Verifier.stripAnsi(line).contains("[ERROR]") || Verifier.isVelocityError(line)) continue;
            throw new VerificationException("Error in execution: " + line);
        }
    }

    private static boolean isVelocityError(String line) {
        return line.contains("VM_global_library.vm") || line.contains("VM #") && line.contains("macro");
    }

    public void verifyTextInLog(String text) throws VerificationException {
        List<String> lines = this.loadFile(this.getBasedir(), this.getLogFileName(), false);
        boolean result = false;
        for (String line : lines) {
            if (!Verifier.stripAnsi(line).contains(text)) continue;
            result = true;
            break;
        }
        if (!result) {
            throw new VerificationException("Text not found in log: " + text);
        }
    }

    public static String stripAnsi(String msg) {
        return msg.replaceAll("\u001b\\[[;\\d]*[ -/]*[@-~]", "");
    }

    public Properties loadProperties(String filename) throws VerificationException {
        Properties properties = new Properties();
        File propertiesFile = new File(this.getBasedir(), filename);
        try (FileInputStream fis = new FileInputStream(propertiesFile);){
            properties.load(fis);
        }
        catch (IOException e) {
            throw new VerificationException("Error reading properties file", e);
        }
        return properties;
    }

    public List<String> loadLines(String filename, String encoding) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = this.getReader(filename, encoding);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0) continue;
                lines.add(line);
            }
        }
        return lines;
    }

    private BufferedReader getReader(String filename, String encoding) throws IOException {
        File file = new File(this.getBasedir(), filename);
        if (StringUtils.isNotEmpty((String)encoding)) {
            return Files.newBufferedReader(file.toPath(), Charset.forName(encoding));
        }
        return Files.newBufferedReader(file.toPath());
    }

    public List<String> loadFile(String basedir, String filename, boolean hasCommand) throws VerificationException {
        return this.loadFile(new File(basedir, filename), hasCommand);
    }

    public List<String> loadFile(File file, boolean hasCommand) throws VerificationException {
        ArrayList<String> lines = new ArrayList<String>();
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line = reader.readLine();
                while (line != null) {
                    if (!(line = line.trim()).startsWith("#") && line.length() != 0) {
                        lines.addAll(this.replaceArtifacts(line, hasCommand));
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                throw new VerificationException(e);
            }
        }
        return lines;
    }

    private List<String> replaceArtifacts(String line, boolean hasCommand) {
        int index = line.indexOf(MARKER);
        if (index >= 0) {
            String filespec;
            String newLine = line.substring(0, index);
            if ((index = line.indexOf("}", index)) < 0) {
                throw new IllegalArgumentException("line does not contain ending artifact marker: '" + line + "'");
            }
            String artifact = line.substring(newLine.length() + MARKER.length(), index);
            newLine = newLine + this.getArtifactPath(artifact);
            newLine = newLine + line.substring(index + 1);
            ArrayList<String> l = new ArrayList<String>();
            l.add(newLine);
            int endIndex = newLine.lastIndexOf(47);
            String command = null;
            if (hasCommand) {
                int startIndex = newLine.indexOf(32);
                command = newLine.substring(0, startIndex);
                filespec = newLine.substring(startIndex + 1, endIndex);
            } else {
                filespec = newLine;
            }
            File dir = new File(filespec);
            Verifier.addMetadataToList(dir, hasCommand, l, command);
            Verifier.addMetadataToList(dir.getParentFile(), hasCommand, l, command);
            return l;
        }
        return Collections.singletonList(line);
    }

    private static void addMetadataToList(File dir, boolean hasCommand, List<String> l, String command) {
        if (dir.exists() && dir.isDirectory()) {
            String[] files;
            for (String file : files = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("maven-metadata") && name.endsWith(".xml");
                }
            })) {
                if (hasCommand) {
                    l.add(command + " " + new File(dir, file).getPath());
                    continue;
                }
                l.add(new File(dir, file).getPath());
            }
        }
    }

    private String getArtifactPath(String artifact) {
        StringTokenizer tok = new StringTokenizer(artifact, ":");
        if (tok.countTokens() != 4) {
            throw new IllegalArgumentException("Artifact must have 4 tokens: '" + artifact + "'");
        }
        String[] a = new String[4];
        for (int i = 0; i < 4; ++i) {
            a[i] = tok.nextToken();
        }
        String groupId = a[0];
        String artifactId = a[1];
        String version = a[2];
        String ext = a[3];
        return this.getArtifactPath(groupId, artifactId, version, ext);
    }

    public String getArtifactPath(String groupId, String artifactId, String version, String ext) {
        return this.getArtifactPath(groupId, artifactId, version, ext, null);
    }

    public String getArtifactPath(String gid, String aid, String version, String ext, String classifier) {
        String repositoryPath;
        if (classifier != null && classifier.length() == 0) {
            classifier = null;
        }
        if ("maven-plugin".equals(ext)) {
            ext = "jar";
        }
        if ("coreit-artifact".equals(ext)) {
            ext = "jar";
            classifier = "it";
        }
        if ("test-jar".equals(ext)) {
            ext = "jar";
            classifier = "tests";
        }
        if ("legacy".equals(this.localRepoLayout)) {
            repositoryPath = gid + "/" + ext + "s/" + aid + "-" + version + "." + ext;
        } else if ("default".equals(this.localRepoLayout)) {
            repositoryPath = gid.replace('.', '/');
            repositoryPath = repositoryPath + "/" + aid + "/" + version;
            repositoryPath = repositoryPath + "/" + aid + "-" + version;
            if (classifier != null) {
                repositoryPath = repositoryPath + "-" + classifier;
            }
            repositoryPath = repositoryPath + "." + ext;
        } else {
            throw new IllegalStateException("Unknown layout: " + this.localRepoLayout);
        }
        return this.localRepo + "/" + repositoryPath;
    }

    public List<String> getArtifactFileNameList(String org, String name, String version, String ext) {
        ArrayList<String> files = new ArrayList<String>();
        String artifactPath = this.getArtifactPath(org, name, version, ext);
        File dir = new File(artifactPath);
        files.add(artifactPath);
        Verifier.addMetadataToList(dir, false, files, null);
        Verifier.addMetadataToList(dir.getParentFile(), false, files, null);
        return files;
    }

    public String getArtifactMetadataPath(String gid, String aid, String version) {
        return this.getArtifactMetadataPath(gid, aid, version, "maven-metadata-local.xml");
    }

    public String getArtifactMetadataPath(String gid, String aid, String version, String filename) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.localRepo);
        buffer.append('/');
        if ("default".equals(this.localRepoLayout)) {
            buffer.append(gid.replace('.', '/'));
            buffer.append('/');
            if (aid != null) {
                buffer.append(aid);
                buffer.append('/');
                if (version != null) {
                    buffer.append(version);
                    buffer.append('/');
                }
            }
        } else {
            throw new IllegalStateException("Unsupported repository layout: " + this.localRepoLayout);
        }
        buffer.append(filename);
        return buffer.toString();
    }

    public String getArtifactMetadataPath(String gid, String aid) {
        return this.getArtifactMetadataPath(gid, aid, null);
    }

    private static String retrieveLocalRepo(String settingsXmlPath) throws VerificationException {
        UserModelReader userModelReader = new UserModelReader();
        String userHome = System.getProperty("user.home");
        String repo = null;
        File userXml = settingsXmlPath != null ? new File(settingsXmlPath) : new File(userHome, ".m2/settings.xml");
        if (userXml.exists()) {
            userModelReader.parse(userXml);
            String localRepository = userModelReader.getLocalRepository();
            if (localRepository != null) {
                repo = new File(localRepository).getAbsolutePath();
            }
        }
        return repo;
    }

    public void deleteArtifact(String org, String name, String version, String ext) throws IOException {
        List<String> files = this.getArtifactFileNameList(org, name, version, ext);
        for (String fileName : files) {
            FileUtils.forceDelete((File)new File(fileName));
        }
    }

    public void deleteArtifacts(String gid) throws IOException {
        String path;
        if ("default".equals(this.localRepoLayout)) {
            path = gid.replace('.', '/');
        } else if ("legacy".equals(this.localRepoLayout)) {
            path = gid;
        } else {
            throw new IllegalStateException("Unsupported repository layout: " + this.localRepoLayout);
        }
        FileUtils.deleteDirectory((File)new File(this.localRepo, path));
    }

    public void deleteArtifacts(String gid, String aid, String version) throws IOException {
        if (!"default".equals(this.localRepoLayout)) {
            throw new IllegalStateException("Unsupported repository layout: " + this.localRepoLayout);
        }
        String path = gid.replace('.', '/') + '/' + aid + '/' + version;
        FileUtils.deleteDirectory((File)new File(this.localRepo, path));
    }

    public void deleteDirectory(String path) throws IOException {
        FileUtils.deleteDirectory((File)new File(this.getBasedir(), path));
    }

    public void writeFile(String path, String contents) throws IOException {
        FileUtils.fileWrite((String)new File(this.getBasedir(), path).getAbsolutePath(), (String)"UTF-8", (String)contents);
    }

    public File filterFile(String srcPath, String dstPath, String fileEncoding) throws IOException {
        return this.filterFile(srcPath, dstPath, fileEncoding, this.newDefaultFilterMap());
    }

    public File filterFile(String srcPath, String dstPath, String fileEncoding, Map<String, String> filterMap) throws IOException {
        File srcFile = new File(this.getBasedir(), srcPath);
        String data = FileUtils.fileRead((File)srcFile, (String)fileEncoding);
        for (Map.Entry<String, String> entry : filterMap.entrySet()) {
            data = StringUtils.replace((String)data, (String)entry.getKey(), (String)entry.getValue());
        }
        File dstFile = new File(this.getBasedir(), dstPath);
        dstFile.getParentFile().mkdirs();
        FileUtils.fileWrite((String)dstFile.getPath(), (String)fileEncoding, (String)data);
        return dstFile;
    }

    @Deprecated
    public File filterFile(String srcPath, String dstPath, String fileEncoding, Properties filterProperties) throws IOException {
        return this.filterFile(srcPath, dstPath, fileEncoding, (Map<String, String>)filterProperties);
    }

    @Deprecated
    public Properties newDefaultFilterProperties() {
        Properties filterProperties = new Properties();
        filterProperties.putAll(this.newDefaultFilterMap());
        return filterProperties;
    }

    public Map<String, String> newDefaultFilterMap() {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        String basedir = new File(this.getBasedir()).getAbsolutePath();
        filterMap.put("@basedir@", basedir);
        String baseurl = basedir;
        if (!baseurl.startsWith("/")) {
            baseurl = '/' + baseurl;
        }
        baseurl = "file://" + baseurl.replace('\\', '/');
        filterMap.put("@baseurl@", baseurl);
        return filterMap;
    }

    public void verifyFilePresent(String file) throws VerificationException {
        this.verifyFilePresence(file, true);
    }

    public void verifyFileContentMatches(String file, String regex) throws VerificationException {
        this.verifyFilePresent(file);
        try {
            String content = FileUtils.fileRead((String)file);
            if (!Pattern.matches(regex, content)) {
                throw new VerificationException("Content of " + file + " does not match " + regex);
            }
        }
        catch (IOException e) {
            throw new VerificationException("Could not read from " + file, e);
        }
    }

    public void verifyFileNotPresent(String file) throws VerificationException {
        this.verifyFilePresence(file, false);
    }

    private void verifyArtifactPresence(boolean wanted, String groupId, String artifactId, String version, String ext) throws VerificationException {
        List<String> files = this.getArtifactFileNameList(groupId, artifactId, version, ext);
        for (String fileName : files) {
            this.verifyFilePresence(fileName, wanted);
        }
    }

    public void verifyArtifactPresent(String groupId, String artifactId, String version, String ext) throws VerificationException {
        this.verifyArtifactPresence(true, groupId, artifactId, version, ext);
    }

    public void verifyArtifactNotPresent(String groupId, String artifactId, String version, String ext) throws VerificationException {
        this.verifyArtifactPresence(false, groupId, artifactId, version, ext);
    }

    private void verifyExpectedResult(String line) throws VerificationException {
        boolean wanted = true;
        if (line.startsWith("!")) {
            line = line.substring(1);
            wanted = false;
        }
        this.verifyFilePresence(line, wanted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyFilePresence(String filePath, boolean wanted) throws VerificationException {
        if (filePath.indexOf("!/") > 0) {
            String urlString = "jar:file:" + this.getBasedir() + "/" + filePath;
            InputStream is = null;
            try {
                URL url = new URL(urlString);
                is = url.openStream();
                if (is == null) {
                    if (!wanted) return;
                    throw new VerificationException("Expected JAR resource was not found: " + filePath);
                }
                if (wanted) return;
                throw new VerificationException("Unwanted JAR resource was found: " + filePath);
            }
            catch (MalformedURLException e) {
                throw new VerificationException("Error looking for JAR resource", e);
            }
            catch (IOException e) {
                if (!wanted) return;
                throw new VerificationException("Error looking for JAR resource: " + filePath);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        File expectedFile = new File(filePath);
        if (!expectedFile.isAbsolute() && !expectedFile.getPath().startsWith(File.separator)) {
            expectedFile = new File(this.getBasedir(), filePath);
        }
        if (filePath.indexOf(42) > -1) {
            File parent = expectedFile.getParentFile();
            if (!parent.exists()) {
                if (!wanted) return;
                throw new VerificationException("Expected file pattern was not found: " + expectedFile.getPath());
            }
            String shortNamePattern = expectedFile.getName().replaceAll("\\*", ".*");
            String[] candidates = parent.list();
            boolean found = false;
            if (candidates != null) {
                for (String candidate : candidates) {
                    if (!candidate.matches(shortNamePattern)) continue;
                    found = true;
                    break;
                }
            }
            if (!found && wanted) {
                throw new VerificationException("Expected file pattern was not found: " + expectedFile.getPath());
            }
            if (!found || wanted) return;
            throw new VerificationException("Unwanted file pattern was found: " + expectedFile.getPath());
        }
        if (!expectedFile.exists()) {
            if (!wanted) return;
            throw new VerificationException("Expected file was not found: " + expectedFile.getPath());
        }
        if (wanted) return;
        throw new VerificationException("Unwanted file was found: " + expectedFile.getPath());
    }

    @Deprecated
    public void executeGoal(String goal) throws VerificationException {
        this.executeGoal(goal, this.environmentVariables);
    }

    @Deprecated
    public void executeGoal(String goal, Map<String, String> envVars) throws VerificationException {
        this.executeGoals(Collections.singletonList(goal), envVars);
    }

    @Deprecated
    public void executeGoals(List<String> goals) throws VerificationException {
        this.executeGoals(goals, this.environmentVariables);
    }

    public String getExecutable() {
        if (this.mavenHome != null) {
            return this.mavenHome + "/bin/mvn";
        }
        return "mvn";
    }

    @Deprecated
    public void executeGoals(List<String> goals, Map<String, String> envVars) throws VerificationException {
        this.cliArguments.addAll(goals);
        this.environmentVariables.putAll(envVars);
        this.execute();
    }

    public void execute() throws VerificationException {
        int ret;
        boolean useMavenRepoLocal;
        ArrayList<String> args = new ArrayList<String>();
        Collections.addAll(args, this.defaultCliArguments);
        if (this.mavenDebug) {
            args.add("-X");
        }
        if (useMavenRepoLocal = Boolean.valueOf(this.verifierProperties.getProperty("use.mavenRepoLocal", "true")).booleanValue()) {
            args.add("-Dmaven.repo.local=" + this.localRepo);
        }
        if (this.autoclean) {
            args.add(CLEAN_CLI_ARGUMENT);
        }
        for (String cliArgument : this.cliArguments) {
            args.add(cliArgument.replace("${basedir}", this.getBasedir()));
        }
        File logFile = new File(this.getBasedir(), this.getLogFileName());
        try {
            MavenLauncher launcher = this.getMavenLauncher(this.environmentVariables);
            String[] cliArgs = args.toArray(new String[0]);
            ret = launcher.run(cliArgs, this.systemProperties, this.getBasedir(), logFile);
        }
        catch (LauncherException e) {
            throw new VerificationException("Failed to execute Maven", e);
        }
        catch (IOException e) {
            throw new VerificationException(e);
        }
        if (ret > 0) {
            throw new VerificationException("Exit code was non-zero: " + ret + "; command line and log = \n" + new File(this.mavenHome, "bin/mvn") + " " + StringUtils.join(args.iterator(), (String)" ") + "\n" + Verifier.getLogContents(logFile));
        }
    }

    protected MavenLauncher getMavenLauncher(Map<String, String> envVars) throws LauncherException {
        boolean fork;
        if (this.useWrapper) {
            fork = true;
        } else if (this.forkJvm != null) {
            fork = this.forkJvm;
        } else if (envVars.isEmpty() && "auto".equalsIgnoreCase(this.forkMode) || "embedded".equalsIgnoreCase(this.forkMode)) {
            fork = false;
            try {
                this.initEmbeddedLauncher();
            }
            catch (Exception e) {
                fork = true;
            }
        } else {
            fork = true;
        }
        if (!fork) {
            if (!envVars.isEmpty()) {
                throw new LauncherException("Environment variables are not supported in embedded runtime");
            }
            this.initEmbeddedLauncher();
            return embeddedLauncher;
        }
        return new ForkedLauncher(this.mavenHome, envVars, this.debugJvm, this.useWrapper);
    }

    private void initEmbeddedLauncher() throws LauncherException {
        if (embeddedLauncher == null) {
            if (StringUtils.isEmpty((String)this.mavenHome)) {
                embeddedLauncher = Embedded3xLauncher.createFromClasspath();
            } else {
                String defaultClasspath = System.getProperty("maven.bootclasspath");
                String defaultClassworldConf = System.getProperty("classworlds.conf");
                embeddedLauncher = Embedded3xLauncher.createFromMavenHome(this.mavenHome, defaultClassworldConf, Verifier.parseClasspath(defaultClasspath));
            }
        }
    }

    private static List<URL> parseClasspath(String classpath) throws LauncherException {
        if (classpath == null) {
            return null;
        }
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            try {
                classpathUrls.add(new File(st.nextToken()).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new LauncherException("Invalid launcher classpath " + classpath, e);
            }
        }
        return classpathUrls;
    }

    public String getMavenVersion() throws VerificationException {
        try {
            return this.getMavenLauncher(Collections.emptyMap()).getMavenVersion();
        }
        catch (IOException | LauncherException e) {
            throw new VerificationException(e);
        }
    }

    private static String getLogContents(File logFile) {
        try {
            return FileUtils.fileRead((File)logFile);
        }
        catch (IOException e) {
            return "(Error reading log contents: " + e.getMessage() + ")";
        }
    }

    private void findLocalRepo(String settingsFile) throws VerificationException {
        File repoDir;
        if (this.localRepo == null) {
            this.localRepo = System.getProperty("maven.repo.local");
        }
        if (this.localRepo == null) {
            this.localRepo = Verifier.retrieveLocalRepo(settingsFile);
        }
        if (this.localRepo == null) {
            this.localRepo = System.getProperty("user.home") + "/.m2/repository";
        }
        if (!(repoDir = new File(this.localRepo)).exists()) {
            repoDir.mkdirs();
        }
        this.localRepo = repoDir.getAbsolutePath();
        this.localRepoLayout = System.getProperty("maven.repo.local.layout", "default");
    }

    public void verifyArtifactContent(String groupId, String artifactId, String version, String ext, String content) throws IOException, VerificationException {
        String fileName = this.getArtifactPath(groupId, artifactId, version, ext);
        if (!content.equals(FileUtils.fileRead((String)fileName))) {
            throw new VerificationException("Content of " + fileName + " does not equal " + content);
        }
    }

    @Deprecated
    public List<String> getCliOptions() {
        return this.cliArguments;
    }

    @Deprecated
    public void setCliOptions(List<String> cliOptions) {
        this.cliArguments = cliOptions;
    }

    @Deprecated
    public void addCliOption(String option) {
        this.addCliArgument(option);
    }

    public void addCliArgument(String cliArgument) {
        this.cliArguments.add(cliArgument);
    }

    public void addCliArguments(String ... cliArguments) {
        Collections.addAll(this.cliArguments, cliArguments);
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void setSystemProperty(String key, String value) {
        if (value != null) {
            this.systemProperties.setProperty(key, value);
        } else {
            this.systemProperties.remove(key);
        }
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void setEnvironmentVariable(String key, String value) {
        if (value != null) {
            this.environmentVariables.put(key, value);
        } else {
            this.environmentVariables.remove(key);
        }
    }

    public Properties getVerifierProperties() {
        return this.verifierProperties;
    }

    public void setVerifierProperties(Properties verifierProperties) {
        this.verifierProperties = verifierProperties;
    }

    public boolean isAutoclean() {
        return this.autoclean;
    }

    public void setAutoclean(boolean autoclean) {
        this.autoclean = autoclean;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        if (StringUtils.isEmpty((String)logFileName)) {
            throw new IllegalArgumentException("log file name unspecified");
        }
        this.logFileName = logFileName;
    }

    @Deprecated
    public void setDebug(boolean debug) {
    }

    @Deprecated
    public boolean isMavenDebug() {
        return this.mavenDebug;
    }

    @Deprecated
    public void setMavenDebug(boolean mavenDebug) {
        this.mavenDebug = mavenDebug;
    }

    public void setForkJvm(boolean forkJvm) {
        this.forkJvm = forkJvm;
    }

    public boolean isDebugJvm() {
        return this.debugJvm;
    }

    public void setDebugJvm(boolean debugJvm) {
        this.debugJvm = debugJvm;
    }

    public String getLocalRepoLayout() {
        return this.localRepoLayout;
    }

    public void setLocalRepoLayout(String localRepoLayout) {
        this.localRepoLayout = localRepoLayout;
    }

    public String getLocalRepository() {
        return this.localRepo;
    }

    static class UserModelReader
    extends DefaultHandler {
        private String localRepository;
        private StringBuilder currentBody = new StringBuilder();

        UserModelReader() {
        }

        public void parse(File file) throws VerificationException {
            try {
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                SAXParser parser = saxFactory.newSAXParser();
                InputSource is = new InputSource(new FileInputStream(file));
                parser.parse(is, (DefaultHandler)this);
            }
            catch (FileNotFoundException e) {
                throw new VerificationException("file not found path : " + file.getAbsolutePath(), e);
            }
            catch (IOException e) {
                throw new VerificationException(" IOException path : " + file.getAbsolutePath(), e);
            }
            catch (ParserConfigurationException e) {
                throw new VerificationException(e);
            }
            catch (SAXException e) {
                throw new VerificationException("Parsing exception for file " + file.getAbsolutePath(), e);
            }
        }

        @Override
        public void warning(SAXParseException spe) {
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            throw new SAXException(spe);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            throw new SAXException(spe);
        }

        public String getLocalRepository() {
            return this.localRepository;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currentBody.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String rawName) throws SAXException {
            if ("localRepository".equals(rawName)) {
                if (this.notEmpty(this.currentBody.toString())) {
                    this.localRepository = this.currentBody.toString().trim();
                } else {
                    throw new SAXException("Invalid mavenProfile entry. Missing one or more fields: {localRepository}.");
                }
            }
            this.currentBody = new StringBuilder();
        }

        private boolean notEmpty(String test) {
            return test != null && test.trim().length() > 0;
        }

        public void reset() {
            this.currentBody = null;
            this.localRepository = null;
        }
    }
}

