/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.it;

import [Ljava.lang.String;;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.Permission;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.Assert;
import org.apache.maven.it.VerificationException;
import org.apache.maven.it.util.FileUtils;
import org.apache.maven.it.util.IOUtil;
import org.apache.maven.it.util.StringUtils;
import org.apache.maven.it.util.cli.CommandLineException;
import org.apache.maven.it.util.cli.CommandLineUtils;
import org.apache.maven.it.util.cli.Commandline;
import org.apache.maven.it.util.cli.WriterStreamConsumer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Verifier {
    private static final String LOG_FILENAME = "log.txt";
    public String localRepo;
    private final String basedir;
    private final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
    private final ByteArrayOutputStream errStream = new ByteArrayOutputStream();
    private PrintStream originalOut;
    private PrintStream originalErr;
    private List cliOptions = new ArrayList();
    private Properties systemProperties = new Properties();
    private Properties verifierProperties = new Properties();
    private boolean autoclean = true;
    private static String localRepoLayout = "default";
    private boolean debug;
    private boolean forkJvm = true;
    private String logFileName = "log.txt";
    private String defaultMavenHome;
    private boolean mavenDebug = false;

    public Verifier(String basedir, String settingsFile) throws VerificationException {
        this(basedir, settingsFile, false);
    }

    public Verifier(String basedir, String settingsFile, boolean debug) throws VerificationException {
        this(basedir, settingsFile, debug, true);
    }

    public Verifier(String basedir, String settingsFile, boolean debug, boolean forkJvm) throws VerificationException {
        this.basedir = basedir;
        this.debug = debug;
        this.forkJvm = forkJvm;
        if (!debug) {
            this.originalOut = System.out;
            System.setOut(new PrintStream(this.outStream));
            this.originalErr = System.err;
            System.setErr(new PrintStream(this.errStream));
        }
        this.findLocalRepo(settingsFile);
        this.findDefaultMavenHome();
    }

    private void findDefaultMavenHome() throws VerificationException {
        this.defaultMavenHome = System.getProperty("maven.home");
        if (this.defaultMavenHome == null) {
            try {
                Properties envVars = CommandLineUtils.getSystemEnvVars();
                this.defaultMavenHome = envVars.getProperty("M2_HOME");
            }
            catch (IOException e) {
                throw new VerificationException("Cannot read system environment variables.", e);
            }
        }
    }

    public Verifier(String basedir) throws VerificationException {
        this(basedir, null);
    }

    public Verifier(String basedir, boolean debug) throws VerificationException {
        this(basedir, null, debug);
    }

    public void setLocalRepo(String localRepo) {
        this.localRepo = localRepo;
    }

    public void resetStreams() {
        if (!this.debug) {
            System.setOut(this.originalOut);
            System.setErr(this.originalErr);
        }
    }

    public void displayStreamBuffers() {
        String err;
        String out = this.outStream.toString();
        if (out != null && out.trim().length() > 0) {
            System.out.println("----- Standard Out -----");
            System.out.println(out);
        }
        if ((err = this.errStream.toString()) != null && err.trim().length() > 0) {
            System.err.println("----- Standard Error -----");
            System.err.println(err);
        }
    }

    public void verify(boolean chokeOnErrorOutput) throws VerificationException {
        List lines = this.loadFile(this.getBasedir(), "expected-results.txt", false);
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            this.verifyExpectedResult(line);
        }
        if (chokeOnErrorOutput) {
            this.verifyErrorFreeLog();
        }
    }

    public void verifyErrorFreeLog() throws VerificationException {
        List lines = this.loadFile(this.getBasedir(), this.getLogFileName(), false);
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            if (line.indexOf("[ERROR]") < 0 || Verifier.isVelocityError(line)) continue;
            throw new VerificationException("Error in execution: " + line);
        }
    }

    private static boolean isVelocityError(String line) {
        if (line.indexOf("VM_global_library.vm") >= 0) {
            return true;
        }
        return line.indexOf("VM #") >= 0 && line.indexOf("macro") >= 0;
    }

    public void verifyTextInLog(String text) throws VerificationException {
        List lines = this.loadFile(this.getBasedir(), this.getLogFileName(), false);
        boolean result = false;
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            if (line.indexOf(text) < 0) continue;
            result = true;
            break;
        }
        if (!result) {
            throw new VerificationException("Text not found in log: " + text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties(String filename) throws VerificationException {
        Properties properties;
        block6: {
            properties = new Properties();
            try {
                File propertiesFile = new File(this.getBasedir(), filename);
                if (!propertiesFile.exists()) break block6;
                FileInputStream fis = new FileInputStream(propertiesFile);
                try {
                    properties.load(fis);
                }
                finally {
                    fis.close();
                }
            }
            catch (FileNotFoundException e) {
                throw new VerificationException("Error reading properties file", e);
            }
            catch (IOException e) {
                throw new VerificationException("Error reading properties file", e);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadLines(String filename, String encoding) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        File file = new File(this.getBasedir(), filename);
        BufferedReader reader = null;
        try {
            String line;
            reader = StringUtils.isNotEmpty(encoding) ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding)) : new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0) continue;
                lines.add(line);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close(reader);
        return lines;
    }

    public List loadFile(String basedir, String filename, boolean hasCommand) throws VerificationException {
        return this.loadFile(new File(basedir, filename), hasCommand);
    }

    public List loadFile(File file, boolean hasCommand) throws VerificationException {
        ArrayList lines = new ArrayList();
        if (file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                while (line != null) {
                    if (!(line = line.trim()).startsWith("#") && line.length() != 0) {
                        lines.addAll(this.replaceArtifacts(line, hasCommand));
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (FileNotFoundException e) {
                throw new VerificationException(e);
            }
            catch (IOException e) {
                throw new VerificationException(e);
            }
        }
        return lines;
    }

    private List replaceArtifacts(String line, boolean hasCommand) {
        String MARKER = "${artifact:";
        int index = line.indexOf(MARKER);
        if (index >= 0) {
            String filespec;
            String newLine = line.substring(0, index);
            if ((index = line.indexOf("}", index)) < 0) {
                throw new IllegalArgumentException("line does not contain ending artifact marker: '" + line + "'");
            }
            String artifact = line.substring(newLine.length() + MARKER.length(), index);
            newLine = newLine + this.getArtifactPath(artifact);
            newLine = newLine + line.substring(index + 1);
            ArrayList<String> l = new ArrayList<String>();
            l.add(newLine);
            int endIndex = newLine.lastIndexOf(47);
            String command = null;
            if (hasCommand) {
                int startIndex = newLine.indexOf(32);
                command = newLine.substring(0, startIndex);
                filespec = newLine.substring(startIndex + 1, endIndex);
            } else {
                filespec = newLine;
            }
            File dir = new File(filespec);
            Verifier.addMetadataToList(dir, hasCommand, l, command);
            Verifier.addMetadataToList(dir.getParentFile(), hasCommand, l, command);
            return l;
        }
        return Collections.singletonList(line);
    }

    private static void addMetadataToList(File dir, boolean hasCommand, List l, String command) {
        if (dir.exists() && dir.isDirectory()) {
            String[] files = dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("maven-metadata") && name.endsWith(".xml");
                }
            });
            for (int i = 0; i < files.length; ++i) {
                if (hasCommand) {
                    l.add(command + " " + new File(dir, files[i]).getPath());
                    continue;
                }
                l.add(new File(dir, files[i]).getPath());
            }
        }
    }

    private String getArtifactPath(String artifact) {
        StringTokenizer tok = new StringTokenizer(artifact, ":");
        if (tok.countTokens() != 4) {
            throw new IllegalArgumentException("Artifact must have 4 tokens: '" + artifact + "'");
        }
        String[] a = new String[4];
        for (int i = 0; i < 4; ++i) {
            a[i] = tok.nextToken();
        }
        String org = a[0];
        String name = a[1];
        String version = a[2];
        String ext = a[3];
        return this.getArtifactPath(org, name, version, ext);
    }

    public String getArtifactPath(String org, String name, String version, String ext) {
        String repositoryPath;
        if ("maven-plugin".equals(ext)) {
            ext = "jar";
        }
        String classifier = null;
        if ("coreit-artifact".equals(ext)) {
            ext = "jar";
            classifier = "it";
        }
        if ("test-jar".equals(ext)) {
            ext = "jar";
            classifier = "tests";
        }
        if ("legacy".equals(localRepoLayout)) {
            repositoryPath = org + "/" + ext + "s/" + name + "-" + version + "." + ext;
        } else if ("default".equals(localRepoLayout)) {
            repositoryPath = org.replace('.', '/');
            repositoryPath = repositoryPath + "/" + name + "/" + version;
            repositoryPath = repositoryPath + "/" + name + "-" + version;
            if (classifier != null) {
                repositoryPath = repositoryPath + "-" + classifier;
            }
            repositoryPath = repositoryPath + "." + ext;
        } else {
            throw new IllegalStateException("Unknown layout: " + localRepoLayout);
        }
        return this.localRepo + "/" + repositoryPath;
    }

    public List getArtifactFileNameList(String org, String name, String version, String ext) {
        ArrayList<String> files = new ArrayList<String>();
        String artifactPath = this.getArtifactPath(org, name, version, ext);
        File dir = new File(artifactPath);
        files.add(artifactPath);
        Verifier.addMetadataToList(dir, false, files, null);
        Verifier.addMetadataToList(dir.getParentFile(), false, files, null);
        return files;
    }

    public String getArtifactMetadataPath(String gid, String aid, String version) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.localRepo);
        buffer.append('/');
        if ("default".equals(localRepoLayout)) {
            buffer.append(gid.replace('.', '/'));
            buffer.append('/');
            buffer.append(aid);
            buffer.append('/');
            if (version != null) {
                buffer.append(version);
                buffer.append('/');
            }
        } else {
            throw new IllegalStateException("Unsupported repository layout: " + localRepoLayout);
        }
        buffer.append("maven-metadata-local.xml");
        return buffer.toString();
    }

    public String getArtifactMetadataPath(String gid, String aid) {
        return this.getArtifactMetadataPath(gid, aid, null);
    }

    public void executeHook(String filename) throws VerificationException {
        try {
            File f = new File(this.getBasedir(), filename);
            if (!f.exists()) {
                return;
            }
            List lines = this.loadFile(f, true);
            Iterator i = lines.iterator();
            while (i.hasNext()) {
                String line = this.resolveCommandLineArg((String)i.next());
                this.executeCommand(line);
            }
        }
        catch (VerificationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VerificationException(e);
        }
    }

    private void executeCommand(String line) throws VerificationException {
        String cmd;
        int index = line.indexOf(" ");
        String args = null;
        if (index >= 0) {
            cmd = line.substring(0, index);
            args = line.substring(index + 1);
        } else {
            cmd = line;
        }
        if ("rm".equals(cmd)) {
            System.out.println("Removing file: " + args);
            File f = new File(args);
            if (f.exists() && !f.delete()) {
                throw new VerificationException("Error removing file - delete failed");
            }
        } else if ("rmdir".equals(cmd)) {
            System.out.println("Removing directory: " + args);
            try {
                File f = new File(args);
                FileUtils.deleteDirectory(f);
            }
            catch (IOException e) {
                throw new VerificationException("Error removing directory - delete failed");
            }
        } else if ("svn".equals(cmd)) {
            Verifier.launchSubversion(line, this.getBasedir());
        } else {
            throw new VerificationException("unknown command: " + cmd);
        }
    }

    public static void launchSubversion(String line, String basedir) throws VerificationException {
        try {
            Commandline cli = new Commandline(line);
            cli.setWorkingDirectory(basedir);
            FileWriter logWriter = new FileWriter(new File(basedir, LOG_FILENAME));
            WriterStreamConsumer out = new WriterStreamConsumer(logWriter);
            WriterStreamConsumer err = new WriterStreamConsumer(logWriter);
            System.out.println("Command: " + Commandline.toString(cli.getCommandline()));
            int ret = CommandLineUtils.executeCommandLine(cli, out, err);
            ((Writer)logWriter).close();
            if (ret > 0) {
                System.err.println("Exit code: " + ret);
                throw new VerificationException();
            }
        }
        catch (CommandLineException e) {
            throw new VerificationException(e);
        }
        catch (IOException e) {
            throw new VerificationException(e);
        }
    }

    private static String retrieveLocalRepo(String settingsXmlPath) throws VerificationException {
        File userXml;
        UserModelReader userModelReader = new UserModelReader();
        String userHome = System.getProperty("user.home");
        String repo = null;
        if (settingsXmlPath != null) {
            System.out.println("Using settings from " + settingsXmlPath);
            userXml = new File(settingsXmlPath);
        } else {
            userXml = new File(userHome, ".m2/settings.xml");
        }
        if (userXml.exists()) {
            userModelReader.parse(userXml);
            String localRepository = userModelReader.getLocalRepository();
            if (localRepository != null) {
                repo = new File(localRepository).getAbsolutePath();
            }
        }
        return repo;
    }

    public void deleteArtifact(String org, String name, String version, String ext) throws IOException {
        List files = this.getArtifactFileNameList(org, name, version, ext);
        Iterator i = files.iterator();
        while (i.hasNext()) {
            String fileName = (String)i.next();
            FileUtils.forceDelete(new File(fileName));
        }
    }

    public void deleteArtifacts(String gid) throws IOException {
        String path;
        if ("default".equals(localRepoLayout)) {
            path = gid.replace('.', '/');
        } else if ("legacy".equals(localRepoLayout)) {
            path = gid;
        } else {
            throw new IllegalStateException("Unsupported repository layout: " + localRepoLayout);
        }
        FileUtils.deleteDirectory(new File(this.localRepo, path));
    }

    public void deleteDirectory(String path) throws IOException {
        FileUtils.deleteDirectory(new File(this.getBasedir(), path));
    }

    public void writeFile(String path, String contents) throws IOException {
        FileUtils.fileWrite(new File(this.getBasedir(), path).getAbsolutePath(), "UTF-8", contents);
    }

    public File filterFile(String srcPath, String dstPath, String fileEncoding, Map filterProperties) throws IOException {
        File srcFile = new File(this.getBasedir(), srcPath);
        String data = FileUtils.fileRead(srcFile, fileEncoding);
        Iterator it = filterProperties.keySet().iterator();
        while (it.hasNext()) {
            String token = (String)it.next();
            String value = String.valueOf(filterProperties.get(token));
            data = StringUtils.replace(data, token, value);
        }
        File dstFile = new File(this.getBasedir(), dstPath);
        FileUtils.fileWrite(dstFile.getPath(), fileEncoding, data);
        return dstFile;
    }

    public Properties newDefaultFilterProperties() {
        Properties filterProperties = new Properties();
        String basedir = new File(this.getBasedir()).getAbsolutePath();
        filterProperties.put("@basedir@", basedir);
        String baseurl = basedir;
        if (!baseurl.startsWith("/")) {
            baseurl = '/' + baseurl;
        }
        baseurl = "file://" + baseurl.replace('\\', '/');
        filterProperties.put("@baseurl@", baseurl);
        return filterProperties;
    }

    public void assertFilePresent(String file) {
        try {
            this.verifyExpectedResult(file, true);
        }
        catch (VerificationException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void assertFileMatches(String file, String regex) {
        this.assertFilePresent(file);
        try {
            String content = FileUtils.fileRead(file);
            if (!Pattern.matches(regex, content)) {
                Assert.fail((String)("Content of " + file + " does not match " + regex));
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void assertFileNotPresent(String file) {
        try {
            this.verifyExpectedResult(file, false);
        }
        catch (VerificationException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void verifyArtifactPresence(boolean wanted, String org, String name, String version, String ext) {
        List files = this.getArtifactFileNameList(org, name, version, ext);
        Iterator i = files.iterator();
        while (i.hasNext()) {
            String fileName = (String)i.next();
            try {
                this.verifyExpectedResult(fileName, wanted);
            }
            catch (VerificationException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    public void assertArtifactPresent(String org, String name, String version, String ext) {
        this.verifyArtifactPresence(true, org, name, version, ext);
    }

    public void assertArtifactNotPresent(String org, String name, String version, String ext) {
        this.verifyArtifactPresence(false, org, name, version, ext);
    }

    private void verifyExpectedResult(String line) throws VerificationException {
        boolean wanted = true;
        if (line.startsWith("!")) {
            line = line.substring(1);
            wanted = false;
        }
        this.verifyExpectedResult(line, wanted);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyExpectedResult(String line, boolean wanted) throws VerificationException {
        if (line.indexOf("!/") > 0) {
            String urlString = "jar:file:" + this.getBasedir() + "/" + line;
            InputStream is = null;
            try {
                URL url = new URL(urlString);
                is = url.openStream();
                if (is == null) {
                    if (!wanted) return;
                    throw new VerificationException("Expected JAR resource was not found: " + line);
                }
                if (wanted) return;
                throw new VerificationException("Unwanted JAR resource was found: " + line);
            }
            catch (MalformedURLException e) {
                throw new VerificationException("Error looking for JAR resource", e);
            }
            catch (IOException e) {
                throw new VerificationException("Error looking for JAR resource", e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        System.err.println("WARN: error closing stream: " + e);
                    }
                }
            }
        }
        File expectedFile = new File(line);
        if (!expectedFile.isAbsolute() && !expectedFile.getPath().startsWith(File.separator)) {
            expectedFile = new File(this.getBasedir(), line);
        }
        if (line.indexOf(42) > -1) {
            File parent = expectedFile.getParentFile();
            if (!parent.exists()) {
                if (!wanted) return;
                throw new VerificationException("Expected file pattern was not found: " + expectedFile.getPath());
            }
            String shortNamePattern = expectedFile.getName().replaceAll("\\*", ".*");
            String[] candidates = parent.list();
            boolean found = false;
            if (candidates != null) {
                for (int i = 0; i < candidates.length; ++i) {
                    if (!candidates[i].matches(shortNamePattern)) continue;
                    found = true;
                    break;
                }
            }
            if (!found && wanted) {
                throw new VerificationException("Expected file pattern was not found: " + expectedFile.getPath());
            }
            if (!found || wanted) return;
            throw new VerificationException("Unwanted file pattern was found: " + expectedFile.getPath());
        }
        if (!expectedFile.exists()) {
            if (!wanted) return;
            throw new VerificationException("Expected file was not found: " + expectedFile.getPath());
        }
        if (wanted) return;
        throw new VerificationException("Unwanted file was found: " + expectedFile.getPath());
    }

    public void executeGoal(String goal) throws VerificationException {
        this.executeGoal(goal, Collections.EMPTY_MAP);
    }

    public void executeGoal(String goal, Map envVars) throws VerificationException {
        this.executeGoals(Arrays.asList(goal), envVars);
    }

    public void executeGoals(List goals) throws VerificationException {
        this.executeGoals(goals, Collections.EMPTY_MAP);
    }

    public String getExecutable() {
        String mavenHome = this.defaultMavenHome;
        if (mavenHome != null) {
            return mavenHome + "/bin/mvn";
        }
        File f = new File(System.getProperty("user.home"), "m2/bin/mvn");
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return "mvn";
    }

    public void executeGoals(List goals, Map envVars) throws VerificationException {
        int ret;
        if (goals.size() == 0) {
            throw new VerificationException("No goals specified");
        }
        ArrayList<String> allGoals = new ArrayList<String>();
        if (this.autoclean) {
            allGoals.add("org.apache.maven.plugins:maven-clean-plugin:clean");
        }
        allGoals.addAll(goals);
        Commandline cli = null;
        File logFile = new File(this.getBasedir(), this.getLogFileName());
        try {
            String key;
            cli = this.createCommandLine();
            Iterator<Object> i = envVars.keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                cli.addEnvironment(key, (String)envVars.get(key));
            }
            if (envVars.get("JAVA_HOME") == null) {
                cli.addEnvironment("JAVA_HOME", System.getProperty("java.home"));
            }
            cli.addEnvironment("MAVEN_TERMINATE_CMD", "on");
            cli.setWorkingDirectory(this.getBasedir());
            Iterator it = this.cliOptions.iterator();
            while (it.hasNext()) {
                key = String.valueOf(it.next());
                String resolvedArg = this.resolveCommandLineArg(key);
                cli.createArgument().setLine(resolvedArg);
            }
            cli.createArgument().setValue("-e");
            cli.createArgument().setValue("--batch-mode");
            if (this.mavenDebug) {
                cli.createArgument().setValue("--debug");
            }
            i = this.systemProperties.keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                String value = this.systemProperties.getProperty(key);
                cli.createArgument().setValue("-D" + key + "=" + value);
            }
            boolean useMavenRepoLocal = Boolean.valueOf(this.verifierProperties.getProperty("use.mavenRepoLocal", "true"));
            if (useMavenRepoLocal) {
                cli.createArgument().setValue("-Dmaven.repo.local=" + this.localRepo);
            }
            Iterator i2 = allGoals.iterator();
            while (i2.hasNext()) {
                cli.createArgument().setValue((String)i2.next());
            }
            ret = this.runCommandLine(cli, logFile);
        }
        catch (CommandLineException e) {
            throw new VerificationException("Failed to execute Maven: " + cli, e);
        }
        catch (IOException e) {
            throw new VerificationException(e);
        }
        if (ret > 0) {
            System.err.println("Exit code: " + ret);
            throw new VerificationException("Exit code was non-zero: " + ret + "; command line and log = \n" + cli + "\n" + Verifier.getLogContents(logFile));
        }
    }

    public String getMavenVersion() throws VerificationException {
        File log;
        Commandline cmd = this.createCommandLine();
        cmd.addArguments(new String[]{"--version"});
        try {
            log = File.createTempFile("maven", "log");
        }
        catch (IOException e) {
            throw new VerificationException("Error creating temp file", e);
        }
        try {
            this.runCommandLine(cmd, log);
        }
        catch (CommandLineException e) {
            throw new VerificationException("Error running commandline " + cmd.toString(), e);
        }
        catch (IOException e) {
            throw new VerificationException("IO Error communicating with commandline " + cmd.toString(), e);
        }
        String version = null;
        List logLines = this.loadFile(log, false);
        log.delete();
        Iterator it = logLines.iterator();
        while (version == null && it.hasNext()) {
            String line = (String)it.next();
            String MAVEN_VERSION = "Maven version: ";
            if (line.regionMatches(true, 0, "Maven version: ", 0, "Maven version: ".length()) && (version = line.substring("Maven version: ".length()).trim()).indexOf(32) >= 0) {
                version = version.substring(0, version.indexOf(32));
            }
            String NEW_MAVEN_VERSION = "Apache Maven ";
            if (!line.regionMatches(true, 0, "Apache Maven ", 0, "Apache Maven ".length()) || (version = line.substring("Apache Maven ".length()).trim()).indexOf(32) < 0) continue;
            version = version.substring(0, version.indexOf(32));
        }
        if (version == null) {
            throw new VerificationException("Illegal maven output: String 'Maven version: ' not found in the following output:\n" + StringUtils.join(logLines.iterator(), "\n"));
        }
        return version;
    }

    private Commandline createCommandLine() {
        Commandline cmd = new Commandline();
        String executable = this.getExecutable();
        if (executable.endsWith("/bin/mvn")) {
            cmd.addEnvironment("M2_HOME", executable.substring(0, executable.length() - 8));
        }
        cmd.setExecutable(executable);
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runCommandLine(Commandline cli, File logFile) throws CommandLineException, IOException {
        class ExitSecurityException
        extends SecurityException {
            private int status;

            public ExitSecurityException(int status) {
                this.status = status;
            }

            public int getStatus() {
                return this.status;
            }
        }
        int n;
        URLClassLoader cl;
        if (this.forkJvm) {
            FileWriter logWriter = new FileWriter(logFile);
            WriterStreamConsumer out = new WriterStreamConsumer(logWriter);
            WriterStreamConsumer err = new WriterStreamConsumer(logWriter);
            try {
                int n2 = CommandLineUtils.executeCommandLine(cli, out, err);
                return n2;
            }
            finally {
                ((Writer)logWriter).close();
            }
        }
        String mavenHome = this.defaultMavenHome;
        if (mavenHome == null) {
            mavenHome = System.getProperty("user.home") + "/local/apache-maven-2.1-SNAPSHOT";
        }
        File coreDir = new File(mavenHome, "core/boot");
        File[] files = coreDir.listFiles();
        File classWorldFile = null;
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i].getName().indexOf("plexus-classworlds") < 0) continue;
            classWorldFile = files[i];
            break;
        }
        if (classWorldFile == null) {
            throw new CommandLineException("Cannot find plexus-classworlds in " + coreDir);
        }
        try {
            cl = new URLClassLoader(new URL[]{classWorldFile.toURI().toURL()}, null);
        }
        catch (MalformedURLException e) {
            throw new CommandLineException("Cannot conver to url: " + classWorldFile, e);
        }
        Class<?> c = cl.loadClass("org.codehaus.plexus.classworlds.launcher.Launcher");
        Method m = c.getMethod("mainWithExitCode", String;.class);
        SecurityManager oldSm = System.getSecurityManager();
        try {
            System.setSecurityManager(new SecurityManager(){

                public void checkPermission(Permission perm) {
                }

                public void checkExit(int status) {
                    throw new ExitSecurityException(status);
                }
            });
        }
        catch (AccessControlException e) {
            throw new CommandLineException("Error isntalling securitymanager", e);
        }
        cli.createArgument().setValue("-f");
        cli.createArgument().setValue(cli.getWorkingDirectory().getAbsolutePath() + "/pom.xml");
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        String oldCwConf = System.getProperty("classworlds.conf");
        String oldMavenHome = System.getProperty("maven.home");
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            FileOutputStream logWriter = new FileOutputStream(logFile);
            System.setOut(new PrintStream(logWriter));
            System.setErr(new PrintStream(logWriter));
            System.setProperty("classworlds.conf", new File(mavenHome, "bin/m2.conf").getAbsolutePath());
            System.setProperty("maven.home", mavenHome);
            n = (Integer)m.invoke(null, new Object[]{cli.getArguments()});
        }
        catch (ExitSecurityException e) {
            int n3;
            try {
                oldOut.println("exit security exception caught: status=" + e.getStatus());
                n3 = e.getStatus();
            }
            catch (Throwable throwable) {
                try {
                    System.setOut(oldOut);
                    System.setErr(oldErr);
                    if (oldCwConf == null) {
                        System.getProperties().remove("classworlds.conf");
                    } else {
                        System.setProperty("classworlds.conf", oldCwConf);
                    }
                    if (oldMavenHome == null) {
                        System.getProperties().remove("maven.home");
                    } else {
                        System.setProperty("maven.home", oldMavenHome);
                    }
                    Thread.currentThread().setContextClassLoader(oldCl);
                    System.setSecurityManager(oldSm);
                    throw throwable;
                }
                catch (ClassNotFoundException e2) {
                    throw new CommandLineException("Cannot load classworlds launcher", e2);
                }
                catch (NoSuchMethodException e3) {
                    throw new CommandLineException("Cannot find classworlds launcher's main method", e3);
                }
                catch (IllegalArgumentException e4) {
                    throw new CommandLineException("Error executing classworlds launcher's main method", e4);
                }
                catch (InvocationTargetException e5) {
                    if (e5.getCause() instanceof ExitSecurityException) {
                        return ((ExitSecurityException)e5.getCause()).getStatus();
                    }
                    throw new CommandLineException("Error executing classworlds launcher's main method", e5);
                }
                catch (IllegalAccessException e6) {
                    throw new CommandLineException("Error executing classworlds launcher's main method", e6);
                }
            }
            System.setOut(oldOut);
            System.setErr(oldErr);
            if (oldCwConf == null) {
                System.getProperties().remove("classworlds.conf");
            } else {
                System.setProperty("classworlds.conf", oldCwConf);
            }
            if (oldMavenHome == null) {
                System.getProperties().remove("maven.home");
            } else {
                System.setProperty("maven.home", oldMavenHome);
            }
            Thread.currentThread().setContextClassLoader(oldCl);
            System.setSecurityManager(oldSm);
            return n3;
        }
        System.setOut(oldOut);
        System.setErr(oldErr);
        if (oldCwConf == null) {
            System.getProperties().remove("classworlds.conf");
        } else {
            System.setProperty("classworlds.conf", oldCwConf);
        }
        if (oldMavenHome == null) {
            System.getProperties().remove("maven.home");
        } else {
            System.setProperty("maven.home", oldMavenHome);
        }
        Thread.currentThread().setContextClassLoader(oldCl);
        System.setSecurityManager(oldSm);
        return n;
    }

    private static String getLogContents(File logFile) {
        try {
            return FileUtils.fileRead(logFile);
        }
        catch (IOException e) {
            return "(Error reading log contents: " + e.getMessage() + ")";
        }
    }

    private String resolveCommandLineArg(String key) {
        String result = key.replaceAll("\\$\\{basedir\\}", this.getBasedir());
        if (result.indexOf("\\\\") >= 0) {
            result = result.replaceAll("\\\\", "\\");
        }
        result = result.replaceAll("\\/\\/", "\\/");
        return result;
    }

    private static List discoverIntegrationTests(String directory) throws VerificationException {
        try {
            ArrayList<String> tests = new ArrayList<String>();
            List subTests = FileUtils.getFiles(new File(directory), "**/goals.txt", null);
            Iterator i = subTests.iterator();
            while (i.hasNext()) {
                File testCase = (File)i.next();
                tests.add(testCase.getParent());
            }
            return tests;
        }
        catch (IOException e) {
            throw new VerificationException(directory + " is not a valid test case container", e);
        }
    }

    private void displayLogFile() {
        System.out.println("Log file contents:");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(this.getBasedir(), this.getLogFileName())));
            String line = reader.readLine();
            while (line != null) {
                System.out.println(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: " + e);
        }
        catch (IOException e) {
            System.err.println("Error: " + e);
        }
    }

    public static void main(String[] args) throws VerificationException {
        String basedir = System.getProperty("user.dir");
        List<String> tests = null;
        ArrayList<String> argsList = new ArrayList<String>();
        String settingsFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-D")) {
                int index = args[i].indexOf("=");
                if (index >= 0) {
                    System.setProperty(args[i].substring(2, index), args[i].substring(index + 1));
                    continue;
                }
                System.setProperty(args[i].substring(2), "true");
                continue;
            }
            if ("-s".equals(args[i]) || "--settings".equals(args[i])) {
                if (i == args.length - 1) {
                    throw new IllegalStateException("missing argument to -s");
                }
                settingsFile = args[++i];
                continue;
            }
            if (args[i].startsWith("-")) {
                System.out.println("skipping unrecognised argument: " + args[i]);
                continue;
            }
            argsList.add(args[i]);
        }
        if (argsList.size() == 0) {
            if (FileUtils.fileExists(basedir + File.separator + "integration-tests.txt")) {
                try {
                    tests = FileUtils.loadFile(new File(basedir, "integration-tests.txt"));
                }
                catch (IOException e) {
                    System.err.println("Unable to load integration tests file");
                    System.err.println(e.getMessage());
                    System.exit(2);
                }
            } else {
                tests = Verifier.discoverIntegrationTests(".");
            }
        } else {
            tests = new ArrayList(argsList.size());
            DecimalFormat fmt = new DecimalFormat("0000");
            for (int i = 0; i < argsList.size(); ++i) {
                String test = (String)argsList.get(i);
                if (test.endsWith(",")) {
                    test = test.substring(0, test.length() - 1);
                }
                if (StringUtils.isNumeric(test)) {
                    test = "it" + fmt.format(Integer.valueOf(test));
                    test.trim();
                    tests.add(test);
                    continue;
                }
                if ("it".startsWith(test)) {
                    if ((test = test.trim()).length() <= 0) continue;
                    tests.add(test);
                    continue;
                }
                if (FileUtils.fileExists(test) && new File(test).isDirectory()) {
                    tests.addAll(Verifier.discoverIntegrationTests(test));
                    continue;
                }
                System.err.println("[WARNING] rejecting " + test + " as an invalid test or test source directory");
            }
        }
        if (tests.size() == 0) {
            System.out.println("No tests to run");
        }
        int exitCode = 0;
        ArrayList<String> failed = new ArrayList<String>();
        Iterator i = tests.iterator();
        while (i.hasNext()) {
            String test = (String)i.next();
            System.out.print(test + "... ");
            String dir = basedir + "/" + test;
            if (!new File(dir, "goals.txt").exists()) {
                System.err.println("Test " + test + " in " + dir + " does not exist");
                System.exit(2);
            }
            Verifier verifier = new Verifier(dir);
            verifier.findLocalRepo(settingsFile);
            System.out.println("Using default local repository: " + verifier.localRepo);
            try {
                Verifier.runIntegrationTest(verifier);
            }
            catch (Throwable e) {
                verifier.resetStreams();
                System.out.println("FAILED");
                verifier.displayStreamBuffers();
                System.out.println(">>>>>> Error Stacktrace:");
                e.printStackTrace(System.out);
                System.out.println("<<<<<< Error Stacktrace");
                verifier.displayLogFile();
                exitCode = 1;
                failed.add(test);
            }
        }
        System.out.println(tests.size() - failed.size() + "/" + tests.size() + " passed");
        if (!failed.isEmpty()) {
            System.out.println("Failed tests: " + failed);
        }
        System.exit(exitCode);
    }

    private void findLocalRepo(String settingsFile) throws VerificationException {
        File repoDir;
        if (this.localRepo == null) {
            this.localRepo = System.getProperty("maven.repo.local");
        }
        if (this.localRepo == null) {
            this.localRepo = Verifier.retrieveLocalRepo(settingsFile);
        }
        if (this.localRepo == null) {
            this.localRepo = System.getProperty("user.home") + "/.m2/repository";
        }
        if (!(repoDir = new File(this.localRepo)).exists()) {
            repoDir.mkdirs();
        }
        this.localRepo = repoDir.getAbsolutePath();
    }

    private static void runIntegrationTest(Verifier verifier) throws VerificationException {
        verifier.executeHook("prebuild-hook.txt");
        Properties properties = verifier.loadProperties("system.properties");
        Properties controlProperties = verifier.loadProperties("verifier.properties");
        boolean chokeOnErrorOutput = Boolean.valueOf(controlProperties.getProperty("failOnErrorOutput", "true"));
        List goals = verifier.loadFile(verifier.getBasedir(), "goals.txt", false);
        List cliOptions = verifier.loadFile(verifier.getBasedir(), "cli-options.txt", false);
        verifier.setCliOptions(cliOptions);
        verifier.setSystemProperties(properties);
        verifier.setVerifierProperties(controlProperties);
        verifier.executeGoals(goals);
        verifier.executeHook("postbuild-hook.txt");
        System.out.println("*** Verifying: fail when [ERROR] detected? " + chokeOnErrorOutput + " ***");
        verifier.verify(chokeOnErrorOutput);
        verifier.resetStreams();
        System.out.println("OK");
    }

    public void assertArtifactContents(String org, String artifact, String version, String type, String contents) throws IOException {
        String fileName = this.getArtifactPath(org, artifact, version, type);
        Assert.assertEquals((String)contents, (String)FileUtils.fileRead(fileName));
    }

    public List getCliOptions() {
        return this.cliOptions;
    }

    public void setCliOptions(List cliOptions) {
        this.cliOptions = cliOptions;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Properties getVerifierProperties() {
        return this.verifierProperties;
    }

    public void setVerifierProperties(Properties verifierProperties) {
        this.verifierProperties = verifierProperties;
    }

    public boolean isAutoclean() {
        return this.autoclean;
    }

    public void setAutoclean(boolean autoclean) {
        this.autoclean = autoclean;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        if (StringUtils.isEmpty(logFileName)) {
            throw new IllegalArgumentException("log file name unspecified");
        }
        this.logFileName = logFileName;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isMavenDebug() {
        return this.mavenDebug;
    }

    public void setMavenDebug(boolean mavenDebug) {
        this.mavenDebug = mavenDebug;
    }

    static class UserModelReader
    extends DefaultHandler {
        private String localRepository;
        private StringBuffer currentBody = new StringBuffer();

        UserModelReader() {
        }

        public void parse(File file) throws VerificationException {
            try {
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                SAXParser parser = saxFactory.newSAXParser();
                InputSource is = new InputSource(new FileInputStream(file));
                parser.parse(is, (DefaultHandler)this);
            }
            catch (FileNotFoundException e) {
                throw new VerificationException(e);
            }
            catch (IOException e) {
                throw new VerificationException(e);
            }
            catch (ParserConfigurationException e) {
                throw new VerificationException(e);
            }
            catch (SAXException e) {
                throw new VerificationException(e);
            }
        }

        public void warning(SAXParseException spe) {
            this.printParseError("Warning", spe);
        }

        public void error(SAXParseException spe) {
            this.printParseError("Error", spe);
        }

        public void fatalError(SAXParseException spe) {
            this.printParseError("Fatal Error", spe);
        }

        private final void printParseError(String type, SAXParseException spe) {
            System.err.println(type + " [line " + spe.getLineNumber() + ", row " + spe.getColumnNumber() + "]: " + spe.getMessage());
        }

        public String getLocalRepository() {
            return this.localRepository;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currentBody.append(ch, start, length);
        }

        public void endElement(String uri, String localName, String rawName) throws SAXException {
            if ("localRepository".equals(rawName)) {
                if (this.notEmpty(this.currentBody.toString())) {
                    this.localRepository = this.currentBody.toString().trim();
                } else {
                    throw new SAXException("Invalid mavenProfile entry. Missing one or more fields: {localRepository}.");
                }
            }
            this.currentBody = new StringBuffer();
        }

        private boolean notEmpty(String test) {
            return test != null && test.trim().length() > 0;
        }

        public void reset() {
            this.currentBody = null;
            this.localRepository = null;
        }
    }
}

