/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.shared.model.ImportModel;
import org.apache.maven.shared.model.ModelMarshaller;
import org.apache.maven.shared.model.ModelProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlImportModel
implements ImportModel {
    private String id;
    private List<ModelProperty> modelProperties;

    public XmlImportModel(String id, InputStream inputStream, String baseUri) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("id: null");
        }
        this.id = id;
        this.modelProperties = ModelMarshaller.marshallXmlToModelProperties(inputStream, baseUri, null);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<ModelProperty> getModelProperties() {
        return this.modelProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlImportModel that = (XmlImportModel)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.modelProperties != null ? ((Object)this.modelProperties).hashCode() : 0);
        return result;
    }
}

