/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.maven.shared.model.ModelProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelMarshaller {
    private ModelMarshaller() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ModelProperty> marshallXmlToModelProperties(InputStream inputStream, String baseUri, Set<String> collections) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream: null");
        }
        if (baseUri == null) throw new IllegalArgumentException("baseUri: null");
        if (baseUri.trim().length() == 0) {
            throw new IllegalArgumentException("baseUri: null");
        }
        if (collections == null) {
            collections = Collections.emptySet();
        }
        ArrayList<ModelProperty> modelProperties = new ArrayList<ModelProperty>();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", "false");
        xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", "false");
        Uri uri = new Uri(baseUri);
        String tagName = baseUri;
        String tagValue = null;
        int depth = 0;
        XMLStreamReader xmlStreamReader = null;
        try {
            xmlStreamReader = xmlInputFactory.createXMLStreamReader(inputStream);
            HashMap<String, String> attributes = new HashMap<String, String>();
            while (true) {
                int type = xmlStreamReader.getEventType();
                switch (type) {
                    case 4: {
                        String tmp = xmlStreamReader.getText();
                        if (tmp == null || tmp.trim().length() == 0) break;
                        tagValue = tmp;
                        break;
                    }
                    case 1: {
                        ++depth;
                        if (!tagName.equals(baseUri)) {
                            modelProperties.add(new ModelProperty(tagName, tagValue));
                            if (!attributes.isEmpty()) {
                                for (Map.Entry e : attributes.entrySet()) {
                                    modelProperties.add(new ModelProperty((String)e.getKey(), (String)e.getValue()));
                                }
                                attributes.clear();
                            }
                        }
                        if (collections.contains((tagName = uri.getUriFor(xmlStreamReader.getName().getLocalPart(), depth)) + "#collection")) {
                            tagName = tagName + "#collection";
                            uri.addTag(xmlStreamReader.getName().getLocalPart() + "#collection");
                        } else if (collections.contains(tagName + "#set")) {
                            tagName = tagName + "#set";
                            uri.addTag(xmlStreamReader.getName().getLocalPart() + "#set");
                        } else {
                            uri.addTag(xmlStreamReader.getName().getLocalPart());
                        }
                        tagValue = null;
                    }
                    case 10: {
                        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                            attributes.put(tagName + "#property/" + xmlStreamReader.getAttributeName(i).getLocalPart(), xmlStreamReader.getAttributeValue(i));
                        }
                        break;
                    }
                    case 2: {
                        --depth;
                        if (tagValue != null) break;
                        tagValue = "";
                        break;
                    }
                    case 8: {
                        modelProperties.add(new ModelProperty(tagName, tagValue));
                        if (!attributes.isEmpty()) {
                            for (Map.Entry e : attributes.entrySet()) {
                                modelProperties.add(new ModelProperty((String)e.getKey(), (String)e.getValue()));
                            }
                            attributes.clear();
                        }
                        ArrayList<ModelProperty> arrayList = modelProperties;
                        return arrayList;
                    }
                }
                xmlStreamReader.next();
                continue;
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(":" + e.toString());
        }
        finally {
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {}
        }
    }

    public static String unmarshalModelPropertiesToXml(List<ModelProperty> modelProperties, String baseUri) throws IOException {
        if (modelProperties == null || modelProperties.isEmpty()) {
            throw new IllegalArgumentException("modelProperties: null or empty");
        }
        if (baseUri == null || baseUri.trim().length() == 0) {
            throw new IllegalArgumentException("baseUri: null or empty");
        }
        int basePosition = baseUri.length();
        StringBuffer sb = new StringBuffer();
        List<Object> lastUriTags = new ArrayList();
        int n = 1;
        for (ModelProperty mp : modelProperties) {
            ModelProperty peekProperty;
            String uri = mp.getUri();
            if (uri.contains("#property")) continue;
            if (!uri.startsWith(baseUri)) {
                throw new IllegalArgumentException("Passed in model property that does not match baseUri: Property URI = " + uri + ", Base URI = " + baseUri);
            }
            List<String> tagNames = ModelMarshaller.getTagNamesFromUri(basePosition, uri);
            if (lastUriTags.size() > tagNames.size()) {
                for (int i = lastUriTags.size() - 1; i >= tagNames.size(); --i) {
                    sb.append(ModelMarshaller.toEndTag((String)lastUriTags.get(i - 1)));
                }
            }
            String tag = tagNames.get(tagNames.size() - 1);
            ArrayList<ModelProperty> attributes = new ArrayList<ModelProperty>();
            for (int peekIndex = modelProperties.indexOf(mp) + 1; peekIndex < modelProperties.size() && peekIndex <= modelProperties.size() - 1 && (peekProperty = modelProperties.get(peekIndex)).getUri().contains("#property"); ++peekIndex) {
                attributes.add(peekProperty);
            }
            sb.append(ModelMarshaller.toStartTag(tag, attributes));
            if (mp.getResolvedValue() != null) {
                sb.append(mp.getResolvedValue());
                sb.append(ModelMarshaller.toEndTag(tag));
                n = 2;
            } else if (!attributes.isEmpty()) {
                int pi = modelProperties.indexOf(mp) + attributes.size() + 1;
                if (pi <= modelProperties.size() - 1 && !(peekProperty = modelProperties.get(pi)).getUri().startsWith(mp.getUri())) {
                    if (mp.getResolvedValue() != null) {
                        sb.append(mp.getResolvedValue());
                    }
                    sb.append(ModelMarshaller.toEndTag(tag));
                    n = 2;
                }
            } else {
                n = 1;
            }
            lastUriTags = tagNames;
        }
        for (int i = lastUriTags.size() - n; i >= 1; --i) {
            sb.append(ModelMarshaller.toEndTag((String)lastUriTags.get(i)));
        }
        return sb.toString();
    }

    private static List<String> getTagNamesFromUri(int basePosition, String uri) {
        return Arrays.asList(uri.substring(basePosition).replaceAll("#collection", "").replaceAll("#set", "").split("/"));
    }

    private static String toStartTag(String value, List<ModelProperty> attributes) {
        StringBuffer sb = new StringBuffer();
        sb.append("\r\n<").append(value);
        if (attributes != null) {
            for (ModelProperty attribute : attributes) {
                sb.append(" ").append(attribute.getUri().substring(attribute.getUri().indexOf("#property/") + 10)).append("=\"").append(attribute.getResolvedValue()).append("\" ");
            }
        }
        sb.append(">");
        return sb.toString();
    }

    private static String toEndTag(String value) {
        if (value.trim().length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("</").append(value).append(">");
        return sb.toString();
    }

    private static class Uri {
        List<String> uris = new LinkedList<String>();

        Uri(String baseUri) {
            this.uris.add(baseUri);
        }

        String getUriFor(String tag, int depth) {
            this.setUrisToDepth(depth);
            StringBuffer sb = new StringBuffer();
            for (String tagName : this.uris) {
                sb.append(tagName).append("/");
            }
            sb.append(tag);
            return sb.toString();
        }

        void addTag(String tag) {
            this.uris.add(tag);
        }

        void setUrisToDepth(int depth) {
            this.uris = new LinkedList<String>(this.uris.subList(0, depth));
        }
    }
}

