/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterpolatorProperty {
    private final String key;
    private final String value;
    private String tag;

    public InterpolatorProperty(String key, String value) {
        this(key, value, null);
    }

    public InterpolatorProperty(String key, String value, String tag) {
        if (key == null) {
            throw new IllegalArgumentException("key: null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value: null");
        }
        this.key = key;
        this.value = value;
        this.tag = tag;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterpolatorProperty that = (InterpolatorProperty)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "Key = " + this.key + ", Value = " + this.value + ", Hash = " + this.hashCode();
    }

    public static List<InterpolatorProperty> toInterpolatorProperties(Properties properties, String tag) {
        if (properties == null) {
            throw new IllegalArgumentException("properties: null");
        }
        ArrayList<InterpolatorProperty> interpolatorProperties = new ArrayList<InterpolatorProperty>();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            interpolatorProperties.add(new InterpolatorProperty("${" + e.getKey() + "}", (String)e.getValue(), tag));
        }
        return interpolatorProperties;
    }
}

