/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.classes;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.shared.jar.classes.JarClasses;
import org.apache.maven.shared.jar.classes.JarVersionedRuntime;

public class JarVersionedRuntimes {
    private NavigableMap<Integer, JarVersionedRuntime> versionedRuntimeMap;

    public JarVersionedRuntimes(NavigableMap<Integer, JarVersionedRuntime> versionedRuntimeMap) {
        this.versionedRuntimeMap = versionedRuntimeMap;
    }

    public NavigableMap<Integer, JarVersionedRuntime> getVersionedRuntimeMap() {
        return this.versionedRuntimeMap;
    }

    public JarVersionedRuntime getJarVersionedRuntime(Integer version) {
        return (JarVersionedRuntime)this.versionedRuntimeMap.get(version);
    }

    public JarClasses getJarClasses(Integer version) {
        return ((JarVersionedRuntime)this.versionedRuntimeMap.get(version)).getJarClasses();
    }

    public Set<Integer> getRuntimeVersionsAsSet() {
        return this.versionedRuntimeMap.keySet();
    }

    public JarVersionedRuntime getBestFitJarVersionedRuntime(Integer version) {
        Objects.requireNonNull(version, "version cannot be null");
        Map.Entry<Integer, JarVersionedRuntime> entry = this.versionedRuntimeMap.floorEntry(version);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public JarVersionedRuntime getBestFitJarVersionedRuntimeBySystemProperty(String key) {
        Objects.requireNonNull(key, "key cannot null");
        String property = System.getProperty(key);
        if (property == null) {
            throw new IllegalStateException("The value of the system property '" + key + "' is null");
        }
        try {
            Integer release = Integer.parseInt(property);
            return this.getBestFitJarVersionedRuntime(release);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("The value of the system property '" + key + "' [" + property + "] cannot be converted to an Integer", e);
        }
    }
}

