/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.scriptinterpreter;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.maven.shared.scriptinterpreter.ScriptEvaluationException;
import org.apache.maven.shared.scriptinterpreter.ScriptInterpreter;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.RootLoader;

class GroovyScriptInterpreter
implements ScriptInterpreter {
    private final RootLoader childFirstLoader = new RootLoader(new URL[0], Thread.currentThread().getContextClassLoader());

    GroovyScriptInterpreter() {
    }

    @Override
    public void setClassPath(List<String> classPath) {
        if (classPath == null || classPath.isEmpty()) {
            return;
        }
        classPath.stream().map(this::toUrl).forEach(arg_0 -> ((RootLoader)this.childFirstLoader).addURL(arg_0));
    }

    private URL toUrl(String path) {
        try {
            return new File(path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Object evaluateScript(String script, Map<String, ?> globalVariables, PrintStream scriptOutput) throws ScriptEvaluationException {
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        ClassLoader curentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (scriptOutput != null) {
                System.setErr(scriptOutput);
                System.setOut(scriptOutput);
            }
            GroovyShell interpreter = new GroovyShell((ClassLoader)this.childFirstLoader, new Binding(globalVariables), new CompilerConfiguration(CompilerConfiguration.DEFAULT));
            Thread.currentThread().setContextClassLoader((ClassLoader)this.childFirstLoader);
            Object object = interpreter.evaluate(script);
            return object;
        }
        catch (Throwable e) {
            throw new ScriptEvaluationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(curentClassLoader);
            System.setErr(origErr);
            System.setOut(origOut);
        }
    }

    @Override
    public void close() throws IOException {
        this.childFirstLoader.close();
    }
}

