/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jarsigner;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.io.IOUtil;

public class JarSignerUtil {
    private JarSignerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipFile(File file) {
        boolean result = false;
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
            try {
                result = zis.getNextEntry() != null;
            }
            finally {
                zis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsignArchive(File jarFile) throws IOException {
        File unsignedFile = new File(jarFile.getAbsolutePath() + ".unsigned");
        ZipInputStream zis = null;
        ZipOutputStream zos = null;
        try {
            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFile)));
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(unsignedFile)));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (!JarSignerUtil.isSignatureFile(ze.getName())) {
                    zos.putNextEntry(new ZipEntry(ze.getName()));
                    IOUtil.copy((InputStream)zis, (OutputStream)zos);
                }
                ze = zis.getNextEntry();
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(zis);
            IOUtil.close(zos);
            throw throwable;
        }
        IOUtil.close((InputStream)zis);
        IOUtil.close((OutputStream)zos);
        FileUtils.rename((File)unsignedFile, (File)jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isArchiveSigned(File jarFile) throws IOException {
        if (jarFile == null) {
            throw new NullPointerException("jarFile");
        }
        ZipInputStream in = null;
        boolean suppressExceptionOnClose = true;
        try {
            boolean signed = false;
            in = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFile)));
            ZipEntry ze = in.getNextEntry();
            while (ze != null) {
                if (JarSignerUtil.isSignatureFile(ze.getName())) {
                    signed = true;
                    break;
                }
                ze = in.getNextEntry();
            }
            suppressExceptionOnClose = false;
            boolean bl = signed;
            return bl;
        }
        finally {
            block11: {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    if (suppressExceptionOnClose) break block11;
                    throw e;
                }
            }
        }
    }

    private static boolean isSignatureFile(String entryName) {
        boolean result = false;
        if (entryName.regionMatches(true, 0, "META-INF", 0, 8) && (entryName = entryName.replace('\\', '/')).indexOf(47) == 8 && entryName.lastIndexOf(47) == 8) {
            if (entryName.regionMatches(true, entryName.length() - 3, ".SF", 0, 3)) {
                result = true;
            } else if (entryName.regionMatches(true, entryName.length() - 4, ".DSA", 0, 4)) {
                result = true;
            } else if (entryName.regionMatches(true, entryName.length() - 4, ".RSA", 0, 4)) {
                result = true;
            } else if (entryName.regionMatches(true, entryName.length() - 3, ".EC", 0, 3)) {
                result = true;
            }
        }
        return result;
    }
}

