/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.untag;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmUntagParameters;
import org.apache.maven.scm.command.untag.AbstractUntagCommand;
import org.apache.maven.scm.command.untag.UntagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.CustomizableSshSessionFactoryCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitTransportConfigCallback;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.apache.maven.scm.provider.git.jgit.command.PushException;
import org.apache.maven.scm.provider.git.jgit.command.ScmProviderAwareSshdSessionFactory;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.slf4j.Logger;

public class JGitUntagCommand
extends AbstractUntagCommand
implements GitCommand,
CustomizableSshSessionFactoryCommand {
    private BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier = ScmProviderAwareSshdSessionFactory::new;

    @Override
    public void setSshSessionFactorySupplier(BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier) {
        this.sshSessionFactorySupplier = sshSessionFactorySupplier;
    }

    protected ScmResult executeUntagCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmUntagParameters scmUntagParameters) throws ScmException {
        String tagName = scmUntagParameters.getTag();
        if (tagName == null || tagName.trim().isEmpty()) {
            throw new ScmException("tag name must be specified");
        }
        String escapedTagName = tagName.trim().replace(' ', '_');
        Git git = null;
        try {
            UntagScmResult refSpec;
            git = JGitUtils.openRepo(fileSet.getBasedir());
            if (git.tagDelete().setTags(new String[]{escapedTagName}).call().isEmpty()) {
                UntagScmResult untagScmResult = new UntagScmResult("JGit tagDelete", "Failed to delete tag", "", false);
                return untagScmResult;
            }
            if (repository.isPushChanges()) {
                refSpec = new RefSpec().setSource(null).setDestination("refs/tags/" + escapedTagName);
                JGitTransportConfigCallback transportConfigCallback = new JGitTransportConfigCallback(this.sshSessionFactorySupplier.apply((GitScmProviderRepository)repository, this.logger));
                this.logger.info("push delete tag [" + escapedTagName + "] to remote...");
                Iterable<PushResult> pushResultList = JGitUtils.push(git, (GitScmProviderRepository)repository, (RefSpec)refSpec, EnumSet.of(RemoteRefUpdate.Status.OK, RemoteRefUpdate.Status.UP_TO_DATE, RemoteRefUpdate.Status.NON_EXISTING), Optional.of(transportConfigCallback));
                if (this.logger.isInfoEnabled()) {
                    for (PushResult pushResult : pushResultList) {
                        Collection ru = pushResult.getRemoteUpdates();
                        for (RemoteRefUpdate remoteRefUpdate : ru) {
                            this.logger.info(remoteRefUpdate.getStatus() + " - " + remoteRefUpdate);
                        }
                    }
                }
            }
            refSpec = new UntagScmResult("JGit tagDelete");
            return refSpec;
        }
        catch (PushException e) {
            this.logger.debug("Failed to push tag deletion", (Throwable)e);
            UntagScmResult untagScmResult = new UntagScmResult("JGit tagDelete", "Failed to push tag deletion: " + e.getMessage(), "", false);
            return untagScmResult;
        }
        catch (IOException | GitAPIException e) {
            throw new ScmException("JGit tagDelete failure!", e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }
}

