/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.blame;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.blame.AbstractBlameCommand;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.blame.BlameResult;

public class JGitBlameCommand
extends AbstractBlameCommand
implements GitCommand {
    public BlameScmResult executeBlameCommand(ScmProviderRepository repo, ScmFileSet workingDirectory, String filename) throws ScmException {
        Git git = null;
        File basedir = workingDirectory.getBasedir();
        try {
            git = JGitUtils.openRepo(basedir);
            BlameResult blameResult = git.blame().setFilePath(filename).call();
            ArrayList<BlameLine> lines = new ArrayList<BlameLine>();
            int i = 0;
            while ((i = blameResult.computeNext()) != -1) {
                lines.add(new BlameLine(blameResult.getSourceAuthor(i).getWhen(), blameResult.getSourceCommit(i).getName(), blameResult.getSourceAuthor(i).getName(), blameResult.getSourceCommitter(i).getName()));
            }
            BlameScmResult blameScmResult = new BlameScmResult("JGit blame", lines);
            return blameScmResult;
        }
        catch (IOException | GitAPIException e) {
            throw new ScmException("JGit blame failure!", e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }
}

