/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider;

import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmBranchParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.blame.BlameScmRequest;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmRequest;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.command.mkdir.MkdirScmResult;
import org.apache.maven.scm.command.remoteinfo.RemoteInfoScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.unedit.UnEditScmResult;
import org.apache.maven.scm.command.untag.UntagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;

public interface ScmProvider {
    public String getScmType();

    public boolean requiresEditMode();

    public ScmProviderRepository makeProviderScmRepository(String var1, char var2) throws ScmRepositoryException;

    public ScmProviderRepository makeProviderScmRepository(File var1) throws ScmRepositoryException, UnknownRepositoryStructure;

    default public void setInteractive(boolean interactive) {
    }

    public List<String> validateScmUrl(String var1, char var2);

    public String getScmSpecificFilename();

    public boolean validateTagName(String var1);

    public String sanitizeTagName(String var1);

    public AddScmResult add(ScmRepository var1, ScmFileSet var2) throws ScmException;

    public AddScmResult add(ScmRepository var1, ScmFileSet var2, String var3) throws ScmException;

    public AddScmResult add(ScmRepository var1, ScmFileSet var2, CommandParameters var3) throws ScmException;

    public BranchScmResult branch(ScmRepository var1, ScmFileSet var2, String var3) throws ScmException;

    public BranchScmResult branch(ScmRepository var1, ScmFileSet var2, String var3, String var4) throws ScmException;

    public BranchScmResult branch(ScmRepository var1, ScmFileSet var2, String var3, ScmBranchParameters var4) throws ScmException;

    public ChangeLogScmResult changeLog(ScmRepository var1, ScmFileSet var2, Date var3, Date var4, int var5, String var6) throws ScmException;

    @Deprecated
    public ChangeLogScmResult changeLog(ScmRepository var1, ScmFileSet var2, Date var3, Date var4, int var5, ScmBranch var6) throws ScmException;

    @Deprecated
    public ChangeLogScmResult changeLog(ScmRepository var1, ScmFileSet var2, Date var3, Date var4, int var5, String var6, String var7) throws ScmException;

    public ChangeLogScmResult changeLog(ScmRepository var1, ScmFileSet var2, Date var3, Date var4, int var5, ScmBranch var6, String var7) throws ScmException;

    public ChangeLogScmResult changeLog(ChangeLogScmRequest var1) throws ScmException;

    @Deprecated
    public ChangeLogScmResult changeLog(ScmRepository var1, ScmFileSet var2, String var3, String var4) throws ScmException;

    @Deprecated
    public ChangeLogScmResult changeLog(ScmRepository var1, ScmFileSet var2, ScmVersion var3, ScmVersion var4) throws ScmException;

    @Deprecated
    public ChangeLogScmResult changeLog(ScmRepository var1, ScmFileSet var2, String var3, String var4, String var5) throws ScmException;

    @Deprecated
    public ChangeLogScmResult changeLog(ScmRepository var1, ScmFileSet var2, ScmVersion var3, ScmVersion var4, String var5) throws ScmException;

    public CheckInScmResult checkIn(ScmRepository var1, ScmFileSet var2, String var3, String var4) throws ScmException;

    public CheckInScmResult checkIn(ScmRepository var1, ScmFileSet var2, String var3) throws ScmException;

    public CheckInScmResult checkIn(ScmRepository var1, ScmFileSet var2, ScmVersion var3, String var4) throws ScmException;

    public CheckOutScmResult checkOut(ScmRepository var1, ScmFileSet var2, String var3) throws ScmException;

    public CheckOutScmResult checkOut(ScmRepository var1, ScmFileSet var2) throws ScmException;

    public CheckOutScmResult checkOut(ScmRepository var1, ScmFileSet var2, ScmVersion var3) throws ScmException;

    public CheckOutScmResult checkOut(ScmRepository var1, ScmFileSet var2, String var3, boolean var4) throws ScmException;

    public CheckOutScmResult checkOut(ScmRepository var1, ScmFileSet var2, boolean var3) throws ScmException;

    public CheckOutScmResult checkOut(ScmRepository var1, ScmFileSet var2, ScmVersion var3, boolean var4) throws ScmException;

    public CheckOutScmResult checkOut(ScmRepository var1, ScmFileSet var2, ScmVersion var3, CommandParameters var4) throws ScmException;

    public DiffScmResult diff(ScmRepository var1, ScmFileSet var2, String var3, String var4) throws ScmException;

    public DiffScmResult diff(ScmRepository var1, ScmFileSet var2, ScmVersion var3, ScmVersion var4) throws ScmException;

    public ExportScmResult export(ScmRepository var1, ScmFileSet var2, String var3) throws ScmException;

    public ExportScmResult export(ScmRepository var1, ScmFileSet var2) throws ScmException;

    public ExportScmResult export(ScmRepository var1, ScmFileSet var2, ScmVersion var3) throws ScmException;

    public ExportScmResult export(ScmRepository var1, ScmFileSet var2, String var3, String var4) throws ScmException;

    public ExportScmResult export(ScmRepository var1, ScmFileSet var2, ScmVersion var3, String var4) throws ScmException;

    public RemoveScmResult remove(ScmRepository var1, ScmFileSet var2, String var3) throws ScmException;

    public StatusScmResult status(ScmRepository var1, ScmFileSet var2) throws ScmException;

    public TagScmResult tag(ScmRepository var1, ScmFileSet var2, String var3) throws ScmException;

    public UntagScmResult untag(ScmRepository var1, ScmFileSet var2, CommandParameters var3) throws ScmException;

    public TagScmResult tag(ScmRepository var1, ScmFileSet var2, String var3, String var4) throws ScmException;

    public TagScmResult tag(ScmRepository var1, ScmFileSet var2, String var3, ScmTagParameters var4) throws ScmException;

    public UpdateScmResult update(ScmRepository var1, ScmFileSet var2) throws ScmException;

    public UpdateScmResult update(ScmRepository var1, ScmFileSet var2, String var3) throws ScmException;

    public UpdateScmResult update(ScmRepository var1, ScmFileSet var2, ScmVersion var3) throws ScmException;

    public UpdateScmResult update(ScmRepository var1, ScmFileSet var2, String var3, boolean var4) throws ScmException;

    public UpdateScmResult update(ScmRepository var1, ScmFileSet var2, boolean var3) throws ScmException;

    public UpdateScmResult update(ScmRepository var1, ScmFileSet var2, ScmVersion var3, boolean var4) throws ScmException;

    public UpdateScmResult update(ScmRepository var1, ScmFileSet var2, String var3, String var4) throws ScmException;

    public UpdateScmResult update(ScmRepository var1, ScmFileSet var2, ScmVersion var3, String var4) throws ScmException;

    public UpdateScmResult update(ScmRepository var1, ScmFileSet var2, String var3, Date var4) throws ScmException;

    public UpdateScmResult update(ScmRepository var1, ScmFileSet var2, ScmVersion var3, Date var4) throws ScmException;

    public UpdateScmResult update(ScmRepository var1, ScmFileSet var2, String var3, Date var4, String var5) throws ScmException;

    public UpdateScmResult update(ScmRepository var1, ScmFileSet var2, ScmVersion var3, Date var4, String var5) throws ScmException;

    public EditScmResult edit(ScmRepository var1, ScmFileSet var2) throws ScmException;

    public UnEditScmResult unedit(ScmRepository var1, ScmFileSet var2) throws ScmException;

    public ListScmResult list(ScmRepository var1, ScmFileSet var2, boolean var3, String var4) throws ScmException;

    public ListScmResult list(ScmRepository var1, ScmFileSet var2, boolean var3, ScmVersion var4) throws ScmException;

    public BlameScmResult blame(ScmRepository var1, ScmFileSet var2, String var3) throws ScmException;

    public BlameScmResult blame(BlameScmRequest var1) throws ScmException;

    public MkdirScmResult mkdir(ScmRepository var1, ScmFileSet var2, String var3, boolean var4) throws ScmException;

    public InfoScmResult info(ScmProviderRepository var1, ScmFileSet var2, CommandParameters var3) throws ScmException;

    public RemoteInfoScmResult remoteInfo(ScmProviderRepository var1, ScmFileSet var2, CommandParameters var3) throws ScmException;
}

