/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScmFileSet
implements Serializable {
    private static final long serialVersionUID = -5978597349974797556L;
    private static final String DELIMITER = ",";
    private static final String DEFAULT_EXCLUDES = StringUtils.join((Object[])DirectoryScanner.DEFAULTEXCLUDES, (String)",");
    private final File basedir;
    private String includes;
    private String excludes;
    private final List<File> files;

    public ScmFileSet(File basedir) {
        this(basedir, new ArrayList<File>(0));
    }

    public ScmFileSet(File basedir, File file) {
        this(basedir, new File[]{file});
    }

    public ScmFileSet(File basedir, String includes, String excludes) throws IOException {
        List fileList;
        this.basedir = basedir;
        excludes = excludes != null && excludes.length() > 0 ? excludes + DELIMITER + DEFAULT_EXCLUDES : DEFAULT_EXCLUDES;
        this.files = fileList = FileUtils.getFiles((File)basedir, (String)includes, (String)excludes, (boolean)false);
        this.includes = includes;
        this.excludes = excludes;
    }

    public ScmFileSet(File basedir, String includes) throws IOException {
        this(basedir, includes, null);
    }

    public ScmFileSet(File basedir, File[] files) {
        this(basedir, Arrays.asList(files));
    }

    public ScmFileSet(File basedir, List<File> files) {
        if (basedir == null) {
            throw new NullPointerException("basedir must not be null");
        }
        if (files == null) {
            throw new NullPointerException("files must not be null");
        }
        this.basedir = basedir;
        this.files = files;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public File[] getFiles() {
        return this.files.toArray(new File[0]);
    }

    public List<File> getFileList() {
        return this.files;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String toString() {
        return "basedir = " + this.basedir + "; files = " + this.files;
    }
}

