/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryKeyFunction;
import org.eclipse.aether.util.PathUtils;
import org.eclipse.aether.util.StringDigestUtil;

public final class RepositoryIdHelper {
    private RepositoryIdHelper() {
    }

    public static RepositoryKeyFunction getRepositoryKeyFunction(String keyTypeString) {
        RepositoryKeyType keyType = RepositoryKeyType.valueOf(keyTypeString.toUpperCase(Locale.ENGLISH));
        switch (keyType.ordinal()) {
            case 0: {
                return RepositoryIdHelper::simpleRepositoryKey;
            }
            case 1: {
                return RepositoryIdHelper::nidRepositoryKey;
            }
            case 2: {
                return RepositoryIdHelper::hurlRepositoryKey;
            }
            case 3: {
                return RepositoryIdHelper::nidAndHurlRepositoryKey;
            }
            case 4: {
                return RepositoryIdHelper::normalizedGloballyUniqueRepositoryKey;
            }
            case 5: {
                return RepositoryIdHelper::globallyUniqueRepositoryKey;
            }
        }
        throw new IllegalArgumentException("Unknown repository key type: " + keyType.name());
    }

    public static String simpleRepositoryKey(RemoteRepository repository, String context) {
        if (repository.isRepositoryManager()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(RepositoryIdHelper.idToPathSegment((ArtifactRepository)repository));
            buffer.append('-');
            TreeSet<String> subKeys = new TreeSet<String>();
            for (RemoteRepository mirroredRepo : repository.getMirroredRepositories()) {
                subKeys.add(mirroredRepo.getId());
            }
            StringDigestUtil sha1 = StringDigestUtil.sha1();
            sha1.update(context);
            for (String subKey : subKeys) {
                sha1.update(subKey);
            }
            buffer.append(sha1.digest());
            return buffer.toString();
        }
        return RepositoryIdHelper.idToPathSegment((ArtifactRepository)repository);
    }

    private static String nidRepositoryKey(RemoteRepository repository, String context) {
        String seed = null;
        if (repository.isRepositoryManager() && context != null && !context.isEmpty()) {
            seed = seed + context;
        }
        return RepositoryIdHelper.idToPathSegment((ArtifactRepository)repository) + (seed == null ? "" : "-" + StringDigestUtil.sha1(seed));
    }

    private static String hurlRepositoryKey(RemoteRepository repository, String context) {
        String seed = null;
        if (repository.isRepositoryManager() && context != null && !context.isEmpty()) {
            seed = seed + context;
        }
        return StringDigestUtil.sha1(repository.getUrl()) + (seed == null ? "" : "-" + StringDigestUtil.sha1(seed));
    }

    private static String nidAndHurlRepositoryKey(RemoteRepository repository, String context) {
        String seed = repository.getUrl();
        if (repository.isRepositoryManager() && context != null && !context.isEmpty()) {
            seed = seed + context;
        }
        return RepositoryIdHelper.idToPathSegment((ArtifactRepository)repository) + "-" + StringDigestUtil.sha1(seed);
    }

    private static String normalizedGloballyUniqueRepositoryKey(RemoteRepository repository, String context) {
        String seed = RepositoryIdHelper.remoteRepositoryDescription(repository, false);
        if (repository.isRepositoryManager() && context != null && !context.isEmpty()) {
            seed = seed + context;
        }
        return RepositoryIdHelper.idToPathSegment((ArtifactRepository)repository) + "-" + StringDigestUtil.sha1(seed);
    }

    private static String globallyUniqueRepositoryKey(RemoteRepository repository, String context) {
        String seed = RepositoryIdHelper.remoteRepositoryDescription(repository, true);
        if (repository.isRepositoryManager() && context != null && !context.isEmpty()) {
            seed = seed + context;
        }
        return RepositoryIdHelper.idToPathSegment((ArtifactRepository)repository) + "-" + StringDigestUtil.sha1(seed);
    }

    private static String idToPathSegment(ArtifactRepository repository) {
        if (repository instanceof RemoteRepository) {
            return PathUtils.stringToPathSegment(repository.getId());
        }
        return repository.getId();
    }

    private static String remoteRepositoryDescription(RemoteRepository repository, boolean mirrorDetails) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(repository.getId());
        buffer.append(" (").append(repository.getUrl());
        buffer.append(", ").append(repository.getContentType());
        boolean r = repository.getPolicy(false).isEnabled();
        boolean s = repository.getPolicy(true).isEnabled();
        if (r && s) {
            buffer.append(", releases+snapshots");
        } else if (r) {
            buffer.append(", releases");
        } else if (s) {
            buffer.append(", snapshots");
        } else {
            buffer.append(", disabled");
        }
        if (repository.isRepositoryManager()) {
            buffer.append(", managed");
        }
        if (!repository.getMirroredRepositories().isEmpty()) {
            if (mirrorDetails) {
                ArrayList<RemoteRepository> mirroredRepositories = new ArrayList<RemoteRepository>(repository.getMirroredRepositories());
                mirroredRepositories.sort(Comparator.comparing(RemoteRepository::getId));
                buffer.append(", mirrorOf(");
                for (RemoteRepository mirroredRepo : mirroredRepositories) {
                    buffer.append(RepositoryIdHelper.remoteRepositoryDescription(mirroredRepo, true));
                }
                buffer.append(")");
            } else {
                buffer.append(", isMirror");
            }
        }
        if (repository.isBlocked()) {
            buffer.append(", blocked");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static enum RepositoryKeyType {
        SIMPLE,
        NID,
        HURL,
        NID_HURL,
        NGURK,
        GURK;

    }
}

