/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.connector.transport.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.ConfigUtils;

public final class HttpTransporterUtils {
    private HttpTransporterUtils() {
    }

    public static String getUserAgent(RepositorySystemSession session, RemoteRepository repository) {
        return ConfigUtils.getString(session, "Aether", "aether.transport.http.userAgent", "aether.connector.userAgent");
    }

    public static String getHttpsSecurityMode(RepositorySystemSession session, RemoteRepository repository) {
        String result = ConfigUtils.getString(session, "default", "aether.transport.https.securityMode." + repository.getId(), "aether.transport.https.securityMode");
        if (!"default".equals(result) && !"insecure".equals(result)) {
            throw new IllegalArgumentException("Unsupported '" + result + "' HTTPS security mode.");
        }
        return result;
    }

    public static int getHttpConnectionMaxTtlSeconds(RepositorySystemSession session, RemoteRepository repository) {
        int result = ConfigUtils.getInteger(session, 300, "aether.transport.http.connectionMaxTtl." + repository.getId(), "aether.transport.http.connectionMaxTtl");
        if (result < 0) {
            throw new IllegalArgumentException("aether.transport.http.connectionMaxTtl value must be >= 0");
        }
        return result;
    }

    public static int getHttpMaxConnectionsPerRoute(RepositorySystemSession session, RemoteRepository repository) {
        int result = ConfigUtils.getInteger(session, 50, "aether.transport.http.maxConnectionsPerRoute." + repository.getId(), "aether.transport.http.maxConnectionsPerRoute");
        if (result < 1) {
            throw new IllegalArgumentException("aether.transport.http.maxConnectionsPerRoute value must be > 0");
        }
        return result;
    }

    public static Map<String, String> getHttpHeaders(RepositorySystemSession session, RemoteRepository repository) {
        return ConfigUtils.getMap(session, Collections.emptyMap(), "aether.transport.http.headers." + repository.getId(), "aether.transport.http.headers");
    }

    public static boolean isHttpPreemptiveAuth(RepositorySystemSession session, RemoteRepository repository) {
        return ConfigUtils.getBoolean(session, false, "aether.transport.http.preemptiveAuth." + repository.getId(), "aether.transport.http.preemptiveAuth");
    }

    public static boolean isHttpPreemptivePutAuth(RepositorySystemSession session, RemoteRepository repository) {
        return ConfigUtils.getBoolean(session, true, "aether.transport.http.preemptivePutAuth." + repository.getId(), "aether.transport.http.preemptivePutAuth");
    }

    public static boolean isHttpSupportWebDav(RepositorySystemSession session, RemoteRepository repository) {
        return ConfigUtils.getBoolean(session, false, "aether.transport.http.supportWebDav." + repository.getId(), "aether.transport.http.supportWebDav");
    }

    public static Charset getHttpCredentialsEncoding(RepositorySystemSession session, RemoteRepository repository) {
        return Charset.forName(ConfigUtils.getString(session, "ISO-8859-1", "aether.transport.http.credentialEncoding." + repository.getId(), "aether.transport.http.credentialEncoding"));
    }

    public static int getHttpConnectTimeout(RepositorySystemSession session, RemoteRepository repository) {
        return ConfigUtils.getInteger(session, 30000, "aether.transport.http.connectTimeout." + repository.getId(), "aether.transport.http.connectTimeout");
    }

    public static int getHttpRequestTimeout(RepositorySystemSession session, RemoteRepository repository) {
        return ConfigUtils.getInteger(session, 1800000, "aether.transport.http.requestTimeout." + repository.getId(), "aether.transport.http.requestTimeout");
    }

    public static int getHttpRetryHandlerCount(RepositorySystemSession session, RemoteRepository repository) {
        int result = ConfigUtils.getInteger(session, 3, "aether.transport.http.retryHandler.count." + repository.getId(), "aether.transport.http.retryHandler.count");
        if (result < 0) {
            throw new IllegalArgumentException("aether.transport.http.retryHandler.count value must be >= 0");
        }
        return result;
    }

    public static long getHttpRetryHandlerInterval(RepositorySystemSession session, RemoteRepository repository) {
        long result = ConfigUtils.getLong(session, 5000L, "aether.transport.http.retryHandler.interval." + repository.getId(), "aether.transport.http.retryHandler.interval");
        if (result < 0L) {
            throw new IllegalArgumentException("aether.transport.http.retryHandler.interval value must be >= 0");
        }
        return result;
    }

    public static long getHttpRetryHandlerIntervalMax(RepositorySystemSession session, RemoteRepository repository) {
        long result = ConfigUtils.getLong(session, 300000L, "aether.transport.http.retryHandler.intervalMax." + repository.getId(), "aether.transport.http.retryHandler.intervalMax");
        if (result < 0L) {
            throw new IllegalArgumentException("aether.transport.http.retryHandler.intervalMax value must be >= 0");
        }
        return result;
    }

    public static Optional<Boolean> getHttpExpectContinue(RepositorySystemSession session, RemoteRepository repository) {
        String expectContinue = ConfigUtils.getString(session, null, "aether.transport.http.expectContinue." + repository.getId(), "aether.transport.http.expectContinue");
        if (expectContinue != null) {
            return Optional.of(Boolean.parseBoolean(expectContinue));
        }
        return Optional.empty();
    }

    public static boolean isHttpReuseConnections(RepositorySystemSession session, RemoteRepository repository) {
        return ConfigUtils.getBoolean(session, true, "aether.transport.http.reuseConnections." + repository.getId(), "aether.transport.http.reuseConnections");
    }

    public static Set<Integer> getHttpServiceUnavailableCodes(RepositorySystemSession session, RemoteRepository repository) {
        String stringValue = ConfigUtils.getString(session, "429,503", "aether.transport.http.retryHandler.serviceUnavailable." + repository.getId(), "aether.transport.http.retryHandler.serviceUnavailable");
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            for (String code : ConfigUtils.parseCommaSeparatedUniqueNames(stringValue)) {
                result.add(Integer.parseInt(code));
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal HTTP codes for aether.transport.http.retryHandler.serviceUnavailable (list of integers): " + stringValue);
        }
        return result;
    }

    public static Optional<InetAddress> getHttpLocalAddress(RepositorySystemSession session, RemoteRepository repository) {
        String bindAddress = ConfigUtils.getString(session, null, "aether.transport.http.localAddress." + repository.getId(), "aether.transport.http.localAddress");
        if (bindAddress != null) {
            try {
                return Optional.of(InetAddress.getByName(bindAddress));
            }
            catch (UnknownHostException uhe) {
                throw new IllegalArgumentException("Given bind address (" + bindAddress + ") cannot be resolved for remote repository " + repository, uhe);
            }
        }
        return Optional.empty();
    }
}

