/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.SystemScopeHandler;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyManagement;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

public abstract class AbstractDependencyManager
implements DependencyManager {
    @Deprecated
    protected static final SystemScopeHandler SYSTEM_SCOPE_HANDLER = SystemScopeHandler.LEGACY;
    protected final int depth;
    protected final int deriveUntil;
    protected final int applyFrom;
    protected final Map<Object, String> managedVersions;
    protected final Map<Object, String> managedScopes;
    protected final Map<Object, Boolean> managedOptionals;
    protected final Map<Object, String> managedLocalPaths;
    protected final Map<Object, Collection<Exclusion>> managedExclusions;
    protected final SystemScopeHandler systemScopeHandler;
    private final int hashCode;

    protected AbstractDependencyManager(int deriveUntil, int applyFrom, SystemScopeHandler systemScopeHandler) {
        this(0, deriveUntil, applyFrom, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), systemScopeHandler);
    }

    protected AbstractDependencyManager(int depth, int deriveUntil, int applyFrom, Map<Object, String> managedVersions, Map<Object, String> managedScopes, Map<Object, Boolean> managedOptionals, Map<Object, String> managedLocalPaths, Map<Object, Collection<Exclusion>> managedExclusions, SystemScopeHandler systemScopeHandler) {
        this.depth = depth;
        this.deriveUntil = deriveUntil;
        this.applyFrom = applyFrom;
        this.managedVersions = Objects.requireNonNull(managedVersions);
        this.managedScopes = Objects.requireNonNull(managedScopes);
        this.managedOptionals = Objects.requireNonNull(managedOptionals);
        this.managedLocalPaths = Objects.requireNonNull(managedLocalPaths);
        this.managedExclusions = Objects.requireNonNull(managedExclusions);
        this.systemScopeHandler = Objects.requireNonNull(systemScopeHandler);
        this.hashCode = Objects.hash(depth, deriveUntil, applyFrom, managedVersions, managedScopes, managedOptionals, managedLocalPaths, managedExclusions);
    }

    protected abstract DependencyManager newInstance(Map<Object, String> var1, Map<Object, String> var2, Map<Object, Boolean> var3, Map<Object, String> var4, Map<Object, Collection<Exclusion>> var5);

    public DependencyManager deriveChildManager(DependencyCollectionContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        if (this.depth >= this.deriveUntil) {
            return this;
        }
        Map<Object, String> managedVersions = this.managedVersions;
        Map<Object, String> managedScopes = this.managedScopes;
        Map<Object, Boolean> managedOptionals = this.managedOptionals;
        Map<Object, String> managedLocalPaths = this.managedLocalPaths;
        Map<Object, Collection<Exclusion>> managedExclusions = this.managedExclusions;
        for (Dependency managedDependency : context.getManagedDependencies()) {
            Collection exclusions;
            String localPath;
            Boolean optional;
            String scope;
            Artifact artifact = managedDependency.getArtifact();
            Key key = new Key(artifact);
            String version = artifact.getVersion();
            if (!version.isEmpty() && !managedVersions.containsKey(key)) {
                if (managedVersions == this.managedVersions) {
                    managedVersions = new HashMap<Object, String>(this.managedVersions);
                }
                managedVersions.put(key, version);
            }
            if (!(scope = managedDependency.getScope()).isEmpty() && !managedScopes.containsKey(key)) {
                if (managedScopes == this.managedScopes) {
                    managedScopes = new HashMap<Object, String>(this.managedScopes);
                }
                managedScopes.put(key, scope);
            }
            if ((optional = managedDependency.getOptional()) != null && !managedOptionals.containsKey(key)) {
                if (managedOptionals == this.managedOptionals) {
                    managedOptionals = new HashMap<Object, Boolean>(this.managedOptionals);
                }
                managedOptionals.put(key, optional);
            }
            if ((localPath = this.systemScopeHandler.getSystemPath(managedDependency.getArtifact())) != null && !managedLocalPaths.containsKey(key)) {
                if (managedLocalPaths == this.managedLocalPaths) {
                    managedLocalPaths = new HashMap<Object, String>(this.managedLocalPaths);
                }
                managedLocalPaths.put(key, localPath);
            }
            if ((exclusions = managedDependency.getExclusions()).isEmpty()) continue;
            if (managedExclusions == this.managedExclusions) {
                managedExclusions = new HashMap<Object, Collection<Exclusion>>(this.managedExclusions);
            }
            Collection managed = managedExclusions.computeIfAbsent(key, k -> new LinkedHashSet());
            managed.addAll(exclusions);
        }
        return this.newInstance(managedVersions, managedScopes, managedOptionals, managedLocalPaths, managedExclusions);
    }

    public DependencyManagement manageDependency(Dependency dependency) {
        Collection<Exclusion> exclusions;
        Objects.requireNonNull(dependency, "dependency cannot be null");
        DependencyManagement management = null;
        Key key = new Key(dependency.getArtifact());
        if (this.depth >= this.applyFrom) {
            Boolean optional;
            String localPath;
            String scope;
            String version = this.managedVersions.get(key);
            if (version != null) {
                management = new DependencyManagement();
                management.setVersion(version);
            }
            if ((scope = this.managedScopes.get(key)) != null) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                management.setScope(scope);
                if (!this.systemScopeHandler.isSystemScope(scope) && this.systemScopeHandler.getSystemPath(dependency.getArtifact()) != null) {
                    HashMap properties = new HashMap(dependency.getArtifact().getProperties());
                    this.systemScopeHandler.setSystemPath(properties, null);
                    management.setProperties(properties);
                }
            }
            if ((this.systemScopeHandler.isSystemScope(scope) || scope == null && this.systemScopeHandler.isSystemScope(dependency.getScope())) && (localPath = this.managedLocalPaths.get(key)) != null) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                HashMap properties = new HashMap(dependency.getArtifact().getProperties());
                this.systemScopeHandler.setSystemPath(properties, localPath);
                management.setProperties(properties);
            }
            if ((optional = this.managedOptionals.get(key)) != null) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                management.setOptional(optional);
            }
        }
        if ((exclusions = this.managedExclusions.get(key)) != null) {
            if (management == null) {
                management = new DependencyManagement();
            }
            LinkedHashSet<Exclusion> result = new LinkedHashSet<Exclusion>(dependency.getExclusions());
            result.addAll(exclusions);
            management.setExclusions(result);
        }
        return management;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractDependencyManager that = (AbstractDependencyManager)obj;
        return this.depth == that.depth && this.deriveUntil == that.deriveUntil && this.applyFrom == that.applyFrom && this.managedVersions.equals(that.managedVersions) && this.managedScopes.equals(that.managedScopes) && this.managedOptionals.equals(that.managedOptionals) && this.managedExclusions.equals(that.managedExclusions);
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected static class Key {
        private final Artifact artifact;
        private final int hashCode;

        Key(Artifact artifact) {
            this.artifact = artifact;
            this.hashCode = Objects.hash(artifact.getGroupId(), artifact.getArtifactId());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifact.getArtifactId().equals(that.artifact.getArtifactId()) && this.artifact.getGroupId().equals(that.artifact.getGroupId()) && this.artifact.getExtension().equals(that.artifact.getExtension()) && this.artifact.getClassifier().equals(that.artifact.getClassifier());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return String.valueOf(this.artifact);
        }
    }
}

