/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public final class FileUtils {
    private FileUtils() {
    }

    public static TempFile newTempFile() throws IOException {
        final Path tempFile = Files.createTempFile("resolver", "tmp", new FileAttribute[0]);
        return new TempFile(){

            @Override
            public Path getPath() {
                return tempFile;
            }

            @Override
            public void close() throws IOException {
                Files.deleteIfExists(tempFile);
            }
        };
    }

    public static TempFile newTempFile(Path file) throws IOException {
        Objects.requireNonNull(file.getParent(), "file must have parent");
        final Path tempFile = Files.createTempFile(file.getParent(), file.getFileName().toString(), "tmp", new FileAttribute[0]);
        return new TempFile(){

            @Override
            public Path getPath() {
                return tempFile;
            }

            @Override
            public void close() throws IOException {
                Files.deleteIfExists(tempFile);
            }
        };
    }

    public static void writeFile(Path target, FileWriter writer) throws IOException {
        FileUtils.writeFile(target, writer, false);
    }

    public static void writeFileWithBackup(Path target, FileWriter writer) throws IOException {
        FileUtils.writeFile(target, writer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeFile(Path target, FileWriter writer, boolean doBackup) throws IOException {
        Objects.requireNonNull(target, "target is null");
        Objects.requireNonNull(writer, "writer is null");
        Path parent = Objects.requireNonNull(target.getParent(), "target must have parent");
        Path temp = null;
        Files.createDirectories(parent, new FileAttribute[0]);
        try {
            temp = Files.createTempFile(parent, "writer", "tmp", new FileAttribute[0]);
            writer.write(temp);
            if (doBackup && Files.isRegularFile(target, new LinkOption[0])) {
                Files.copy(target, parent.resolve(target.getFileName() + ".bak"), StandardCopyOption.REPLACE_EXISTING);
            }
            Files.move(temp, target, StandardCopyOption.ATOMIC_MOVE);
            if (temp == null) return;
        }
        catch (Throwable throwable) {
            if (temp == null) throw throwable;
            Files.deleteIfExists(temp);
            throw throwable;
        }
        Files.deleteIfExists(temp);
    }

    @FunctionalInterface
    public static interface FileWriter {
        public void write(Path var1) throws IOException;
    }

    public static interface TempFile
    extends Closeable {
        public Path getPath();
    }
}

