/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.apache;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLInitializationException;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.transport.apache.ConnMgrConfig;
import org.eclipse.aether.util.ConfigUtils;

final class GlobalState
implements Closeable {
    private static final String KEY = GlobalState.class.getName();
    private static final String CONFIG_PROP_CACHE_STATE = "aether.transport.apache.cacheState";
    private final ConcurrentMap<ConnMgrConfig, HttpClientConnectionManager> connectionManagers = new ConcurrentHashMap<ConnMgrConfig, HttpClientConnectionManager>();
    private final ConcurrentMap<CompoundKey, Object> userTokens = new ConcurrentHashMap<CompoundKey, Object>();
    private final ConcurrentMap<CompoundKey, Boolean> expectContinues = new ConcurrentHashMap<CompoundKey, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalState get(RepositorySystemSession session) {
        RepositoryCache repoCache = session.getCache();
        if (repoCache == null) return null;
        if (!ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{CONFIG_PROP_CACHE_STATE})) {
            return null;
        }
        Object tmp = repoCache.get(session, (Object)KEY);
        if (tmp instanceof GlobalState) {
            return (GlobalState)tmp;
        }
        Class<GlobalState> clazz = GlobalState.class;
        synchronized (GlobalState.class) {
            tmp = repoCache.get(session, (Object)KEY);
            if (tmp instanceof GlobalState) {
                return (GlobalState)tmp;
            }
            GlobalState cache = new GlobalState();
            repoCache.put(session, (Object)KEY, (Object)cache);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return cache;
        }
    }

    private GlobalState() {
    }

    @Override
    public void close() {
        Iterator it = this.connectionManagers.entrySet().iterator();
        while (it.hasNext()) {
            HttpClientConnectionManager connMgr = (HttpClientConnectionManager)it.next().getValue();
            it.remove();
            connMgr.shutdown();
        }
    }

    public HttpClientConnectionManager getConnectionManager(ConnMgrConfig config) {
        return this.connectionManagers.computeIfAbsent(config, GlobalState::newConnectionManager);
    }

    public static HttpClientConnectionManager newConnectionManager(ConnMgrConfig connMgrConfig) {
        RegistryBuilder registryBuilder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        int connectionMaxTtlSeconds = 300;
        int maxConnectionsPerRoute = 50;
        if (connMgrConfig == null) {
            registryBuilder.register("https", (Object)SSLConnectionSocketFactory.getSystemSocketFactory());
        } else {
            connectionMaxTtlSeconds = connMgrConfig.connectionMaxTtlSeconds;
            maxConnectionsPerRoute = connMgrConfig.maxConnectionsPerRoute;
            SSLSocketFactory sslSocketFactory = connMgrConfig.context != null ? connMgrConfig.context.getSocketFactory() : null;
            HostnameVerifier hostnameVerifier = connMgrConfig.verifier;
            if ("default".equals(connMgrConfig.httpsSecurityMode)) {
                if (sslSocketFactory == null) {
                    sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                }
                if (hostnameVerifier == null) {
                    hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
                }
            } else if ("insecure".equals(connMgrConfig.httpsSecurityMode)) {
                if (sslSocketFactory == null) {
                    try {
                        sslSocketFactory = new SSLContextBuilder().loadTrustMaterial(null, (chain, auth) -> true).build().getSocketFactory();
                    }
                    catch (Exception e) {
                        throw new SSLInitializationException("Could not configure '" + connMgrConfig.httpsSecurityMode + "' HTTPS security mode", (Throwable)e);
                    }
                }
                if (hostnameVerifier == null) {
                    hostnameVerifier = NoopHostnameVerifier.INSTANCE;
                }
            } else {
                throw new IllegalArgumentException("Unsupported '" + connMgrConfig.httpsSecurityMode + "' HTTPS security mode.");
            }
            registryBuilder.register("https", (Object)new SSLConnectionSocketFactory(sslSocketFactory, connMgrConfig.protocols, connMgrConfig.cipherSuites, hostnameVerifier));
        }
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager((HttpClientConnectionOperator)new DefaultHttpClientConnectionOperator((Lookup)registryBuilder.build(), (SchemePortResolver)DefaultSchemePortResolver.INSTANCE, (DnsResolver)SystemDefaultDnsResolver.INSTANCE), (HttpConnectionFactory)ManagedHttpClientConnectionFactory.INSTANCE, (long)connectionMaxTtlSeconds, TimeUnit.SECONDS);
        connMgr.setMaxTotal(maxConnectionsPerRoute * 2);
        connMgr.setDefaultMaxPerRoute(maxConnectionsPerRoute);
        return connMgr;
    }

    public Object getUserToken(CompoundKey key) {
        return this.userTokens.get(key);
    }

    public void setUserToken(CompoundKey key, Object userToken) {
        if (userToken != null) {
            this.userTokens.put(key, userToken);
        } else {
            this.userTokens.remove(key);
        }
    }

    public Boolean getExpectContinue(CompoundKey key) {
        return (Boolean)this.expectContinues.get(key);
    }

    public void setExpectContinue(CompoundKey key, boolean enabled) {
        this.expectContinues.put(key, enabled);
    }

    static class CompoundKey {
        private final Object[] keys;

        CompoundKey(Object ... keys) {
            this.keys = keys;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            CompoundKey that = (CompoundKey)obj;
            return Arrays.equals(this.keys, that.keys);
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + Arrays.hashCode(this.keys);
            return hash;
        }

        public String toString() {
            return Arrays.toString(this.keys);
        }
    }
}

