/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.apache;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.http.ChecksumExtractor;
import org.eclipse.aether.spi.connector.transport.http.HttpTransporter;
import org.eclipse.aether.spi.connector.transport.http.HttpTransporterFactory;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.apache.ApacheTransporter;

@Named(value="apache")
public final class ApacheTransporterFactory
implements HttpTransporterFactory {
    public static final String NAME = "apache";
    private float priority = 5.0f;
    private final ChecksumExtractor checksumExtractor;

    @Inject
    public ApacheTransporterFactory(ChecksumExtractor checksumExtractor) {
        this.checksumExtractor = Objects.requireNonNull(checksumExtractor, "checksumExtractor");
    }

    public float getPriority() {
        return this.priority;
    }

    public ApacheTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public HttpTransporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return new ApacheTransporter(repository, session, this.checksumExtractor);
    }
}

