/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.spi.ToolProvider;
import java.util.stream.Stream;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.codehaus.plexus.util.io.CachingWriter;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AST;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Javadoc;
import org.jboss.forge.roaster.model.JavaDocCapable;
import org.jboss.forge.roaster.model.JavaDocTag;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.impl.JavaDocImpl;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import picocli.CommandLine;

@CommandLine.Command(name="docgen", description={"Maven Documentation Generator"})
public class CollectConfiguration
implements Callable<Integer> {
    protected static final String KEY = "key";
    @CommandLine.Option(names={"-m", "--mode"}, arity="1", paramLabel="mode", description={"The mode of generator (what is being scanned?), supported modes are 'maven', 'resolver'"})
    protected Mode mode;
    @CommandLine.Option(names={"-t", "--templates"}, arity="1", split=",", paramLabel="template", description={"The template names to write content out without '.vm' extension"})
    protected List<String> templates;
    @CommandLine.Parameters(index="0", description={"The root directory to process sources from"})
    protected Path rootDirectory;
    @CommandLine.Parameters(index="1", description={"The directory to generate output(s) to"})
    protected Path outputDirectory;
    protected static final Pattern CONSTANT_PATTERN = Pattern.compile(".*static final.* ([A-Z_]+) = (.*);");
    protected static final ToolProvider JAVAP = ToolProvider.findFirst("javap").orElseThrow();

    public static void main(String[] args) {
        new CommandLine((Object)new CollectConfiguration()).execute(args);
    }

    @Override
    public Integer call() {
        try {
            ArrayList discoveredKeys;
            block16: {
                this.rootDirectory = this.rootDirectory.toAbsolutePath().normalize();
                this.outputDirectory = this.outputDirectory.toAbsolutePath().normalize();
                discoveredKeys = new ArrayList();
                try (Stream<Path> stream = Files.walk(this.rootDirectory, new FileVisitOption[0]);){
                    if (this.mode == Mode.maven) {
                        System.out.println("Processing Maven sources from " + String.valueOf(this.rootDirectory));
                        stream.map(Path::toAbsolutePath).filter(p -> p.getFileName().toString().endsWith(".class")).filter(p -> p.toString().contains("/target/classes/")).forEach(p -> this.processMavenClass((Path)p, discoveredKeys));
                        break block16;
                    }
                    if (this.mode == Mode.resolver) {
                        System.out.println("Processing Resolver sources from " + String.valueOf(this.rootDirectory));
                        stream.map(Path::toAbsolutePath).filter(p -> p.getFileName().toString().endsWith(".java")).filter(p -> p.toString().contains("/src/main/java/")).filter(p -> !p.toString().endsWith("/module-info.java")).forEach(p -> this.processResolverClass((Path)p, discoveredKeys));
                        break block16;
                    }
                    throw new IllegalStateException("Unsupported mode " + String.valueOf((Object)this.mode));
                }
            }
            Collections.sort(discoveredKeys, Comparator.comparing(e -> (String)e.get(KEY)));
            Properties properties = new Properties();
            properties.setProperty("resource.loaders", "classpath");
            properties.setProperty("resource.loader.classpath.class", ClasspathResourceLoader.class.getName());
            VelocityEngine velocityEngine = new VelocityEngine();
            velocityEngine.init(properties);
            VelocityContext context = new VelocityContext();
            context.put("keys", discoveredKeys);
            for (String template : this.templates) {
                Path output = this.outputDirectory.resolve(template);
                System.out.println("Writing out to " + String.valueOf(output));
                try (CachingWriter fileWriter = new CachingWriter(output, StandardCharsets.UTF_8);){
                    velocityEngine.getTemplate(template + ".vm").merge((Context)context, (Writer)fileWriter);
                }
            }
            return 0;
        }
        catch (Exception e2) {
            e2.printStackTrace(System.err);
            return 1;
        }
    }

    protected void processMavenClass(final Path path, final List<Map<String, String>> discoveredKeys) {
        try {
            ClassReader classReader = new ClassReader(Files.newInputStream(path, new OpenOption[0]));
            classReader.accept(new ClassVisitor(589824){

                public FieldVisitor visitField(int fieldAccess, final String fieldName, String fieldDescriptor, String fieldSignature, final Object fieldValue) {
                    return new FieldVisitor(589824){

                        public AnnotationVisitor visitAnnotation(String annotationDescriptor, boolean annotationVisible) {
                            if (annotationDescriptor.equals("Lorg/apache/maven/api/annotations/Config;")) {
                                return new AnnotationVisitor(589824){
                                    final Map<String, Object> values;
                                    {
                                        this.values = new HashMap<String, Object>();
                                    }

                                    public void visit(String name, Object value) {
                                        this.values.put(name, value);
                                    }

                                    public void visitEnum(String name, String descriptor, String value) {
                                        this.values.put(name, value);
                                    }

                                    public void visitEnd() {
                                        JavaType<?> jtype = CollectConfiguration.this.parse(Paths.get(path.toString().replace("/target/classes/", "/src/main/java/").replace(".class", ".java"), new String[0]));
                                        FieldSource f = ((JavaClassSource)jtype).getField(fieldName);
                                        String fqName = null;
                                        String desc = CollectConfiguration.this.cloneJavadoc(f.getJavaDoc()).removeAllTags().getFullText().replace("*", "\\*");
                                        String since = CollectConfiguration.this.getSince((JavaDocCapable<?>)f);
                                        String source = switch ((this.values.get("source") != null ? (String)this.values.get("source") : "USER_PROPERTIES").toLowerCase()) {
                                            case "model" -> "Model properties";
                                            case "user_properties" -> "User properties";
                                            default -> throw new IllegalStateException();
                                        };
                                        String type = switch (this.values.get("type") != null ? (String)this.values.get("type") : "java.lang.String") {
                                            case "java.lang.String" -> "String";
                                            case "java.lang.Integer" -> "Integer";
                                            case "java.lang.Boolean" -> "Boolean";
                                            default -> throw new IllegalStateException();
                                        };
                                        discoveredKeys.add(Map.of(CollectConfiguration.KEY, fieldValue.toString(), "defaultValue", this.values.get("defaultValue") != null ? this.values.get("defaultValue").toString() : "", "fqName", CollectConfiguration.this.nvl(fqName, ""), "description", desc, "since", CollectConfiguration.this.nvl(since, ""), "configurationSource", source, "configurationType", type));
                                    }
                                };
                            }
                            return null;
                        }
                    };
                }
            }, 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processResolverClass(Path path, List<Map<String, String>> discoveredKeys) {
        JavaType<?> type = this.parse(path);
        if (type instanceof JavaClassSource) {
            JavaClassSource javaClassSource = (JavaClassSource)type;
            javaClassSource.getFields().stream().filter(this::hasConfigurationSource).forEach(f -> {
                Map<String, String> constants = CollectConfiguration.extractConstants(Paths.get(path.toString().replace("/src/main/java/", "/target/classes/").replace(".java", ".class"), new String[0]));
                String name = f.getName();
                String key = constants.get(name);
                String fqName = ((JavaClassSource)f.getOrigin()).getCanonicalName() + "." + name;
                String configurationType = this.getConfigurationType((JavaDocCapable<?>)f);
                String defValue = this.getTag((JavaDocCapable<?>)f, "@configurationDefaultValue");
                if (defValue != null && defValue.startsWith("{@link #") && defValue.endsWith("}")) {
                    String lookupValue = constants.get(defValue.substring(8, defValue.length() - 1));
                    if (lookupValue == null) {
                        throw new IllegalArgumentException("Could not look up " + defValue + " for configuration " + fqName);
                    }
                    defValue = lookupValue;
                    if ("java.lang.Long".equals(configurationType) && (defValue.endsWith("l") || defValue.endsWith("L"))) {
                        defValue = defValue.substring(0, defValue.length() - 1);
                    }
                }
                discoveredKeys.add(Map.of(KEY, key, "defaultValue", this.nvl(defValue, ""), "fqName", fqName, "description", this.cleanseJavadoc((FieldSource<JavaClassSource>)f), "since", this.nvl(this.getSince((JavaDocCapable<?>)f), ""), "configurationSource", this.getConfigurationSource((JavaDocCapable<?>)f), "configurationType", configurationType, "supportRepoIdSuffix", this.toYesNo(this.getTag((JavaDocCapable<?>)f, "@configurationRepoIdSuffix"))));
            });
        }
    }

    protected JavaDocSource<Object> cloneJavadoc(JavaDocSource<?> javaDoc) {
        Javadoc jd = (Javadoc)javaDoc.getInternal();
        return new JavaDocImpl(javaDoc.getOrigin(), (Javadoc)ASTNode.copySubtree((AST)AST.newAST((int)jd.getAST().apiLevel(), (boolean)false), (ASTNode)jd));
    }

    protected String cleanseJavadoc(FieldSource<JavaClassSource> javaClassSource) {
        JavaDocSource javaDoc = javaClassSource.getJavaDoc();
        String[] text = javaDoc.getFullText().split("\n");
        StringBuilder result = new StringBuilder();
        for (String line : text) {
            if (line.startsWith("@") || line.trim().isEmpty()) continue;
            result.append(line);
        }
        return this.cleanseTags(result.toString());
    }

    protected String cleanseTags(String text) {
        Pattern pattern = Pattern.compile("(\\{@\\w\\w\\w\\w (.+?)})");
        Matcher matcher = pattern.matcher(text);
        if (!matcher.find()) {
            return text;
        }
        int prevEnd = 0;
        StringBuilder result = new StringBuilder();
        do {
            result.append(text, prevEnd, matcher.start(1));
            result.append("<code>");
            result.append(matcher.group(2));
            result.append("</code>");
            prevEnd = matcher.end(1);
        } while (matcher.find());
        result.append(text, prevEnd, text.length());
        return result.toString();
    }

    protected JavaType<?> parse(Path path) {
        try {
            return Roaster.parse((File)path.toFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String toYesNo(String value) {
        return "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) ? "Yes" : "No";
    }

    protected String nvl(String string, String def) {
        return string == null ? def : string;
    }

    protected boolean hasConfigurationSource(JavaDocCapable<?> javaDocCapable) {
        return this.getTag(javaDocCapable, "@configurationSource") != null;
    }

    protected String getConfigurationType(JavaDocCapable<?> javaDocCapable) {
        String type = this.getTag(javaDocCapable, "@configurationType");
        if (type != null) {
            String javaLangPackage;
            String linkPrefix = "{@link ";
            String linkSuffix = "}";
            if (type.startsWith(linkPrefix) && type.endsWith(linkSuffix)) {
                type = type.substring(linkPrefix.length(), type.length() - linkSuffix.length());
            }
            if (type.startsWith(javaLangPackage = "java.lang.")) {
                type = type.substring(javaLangPackage.length());
            }
        }
        return this.nvl(type, "n/a");
    }

    protected String getConfigurationSource(JavaDocCapable<?> javaDocCapable) {
        String source = this.getTag(javaDocCapable, "@configurationSource");
        if ("{@link RepositorySystemSession#getConfigProperties()}".equals(source)) {
            return "Session Configuration";
        }
        if ("{@link System#getProperty(String,String)}".equals(source)) {
            return "Java System Properties";
        }
        return source;
    }

    protected String getSince(JavaDocCapable<?> javaDocCapable) {
        if (javaDocCapable != null) {
            JavaClassSource classSource;
            List tags;
            if (javaDocCapable instanceof FieldSource) {
                FieldSource fieldSource = (FieldSource)javaDocCapable;
                List tags2 = fieldSource.getJavaDoc().getTags("@since");
                if (tags2.isEmpty()) {
                    return this.getSince((JavaDocCapable)fieldSource.getOrigin());
                }
                return ((JavaDocTag)tags2.get(0)).getValue();
            }
            if (javaDocCapable instanceof JavaClassSource && !(tags = (classSource = (JavaClassSource)javaDocCapable).getJavaDoc().getTags("@since")).isEmpty()) {
                return ((JavaDocTag)tags.get(0)).getValue();
            }
        }
        return null;
    }

    protected String getTag(JavaDocCapable<?> javaDocCapable, String tagName) {
        if (javaDocCapable != null && javaDocCapable instanceof FieldSource) {
            FieldSource fieldSource = (FieldSource)javaDocCapable;
            List tags = fieldSource.getJavaDoc().getTags(tagName);
            if (tags.isEmpty()) {
                return this.getTag((JavaDocCapable)fieldSource.getOrigin(), tagName);
            }
            return ((JavaDocTag)tags.get(0)).getValue();
        }
        return null;
    }

    protected static Map<String, String> extractConstants(Path file) {
        StringWriter out = new StringWriter();
        JAVAP.run(new PrintWriter(out), new PrintWriter(System.err), "-constants", file.toString());
        HashMap<String, String> result = new HashMap<String, String>();
        out.getBuffer().toString().lines().forEach(l -> {
            Matcher matcher = CONSTANT_PATTERN.matcher((CharSequence)l);
            if (matcher.matches()) {
                result.put(matcher.group(1), matcher.group(2));
            }
        });
        return result;
    }

    static enum Mode {
        maven,
        resolver;

    }
}

