/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NodeDefinition {
    static final String ID = "\\(([-_a-zA-Z0-9]+)\\)";
    static final String IDREF = "\\^([-_a-zA-Z0-9]+)";
    static final String COORDS = "([^: \\(]+):([^: ]+)(?::([^: ]*)(?::([^: ]+))?)?:([^: \\[\\(<]+)";
    private static final String COORDS_NC = "([^: \\(]+):([^: ]+)(?::([^: ]*)(?::([^: ]+))?)?:([^: \\[\\(<]+)".replaceAll("\\((?=\\[)", "(?:");
    private static final String RANGE_NC = "[\\(\\[][^\\(\\)\\[\\]]+[\\)\\]]";
    static final String RANGE = "([\\(\\[][^\\(\\)\\[\\]]+[\\)\\]])";
    static final String SCOPE = "(?:scope\\s*=\\s*)?((?!optional)[-_a-zA-Z0-9]+)(?:<([-_a-zA-Z0-9]+))?";
    static final String OPTIONAL = "(!?optional)";
    static final String RELOCATIONS = "relocations\\s*=\\s*(" + COORDS_NC + "(?:\\s*,\\s*" + COORDS_NC + ")*)";
    static final String KEY_VAL = "(?:[-_a-zA-Z0-9]+)\\s*:\\s*(?:[-_a-zA-Z0-9]*)";
    static final String PROPS = "props\\s*=\\s*((?:[-_a-zA-Z0-9]+)\\s*:\\s*(?:[-_a-zA-Z0-9]*)(?:\\s*,\\s*(?:[-_a-zA-Z0-9]+)\\s*:\\s*(?:[-_a-zA-Z0-9]*))*)";
    static final String COORDSX = "(" + COORDS_NC + ")" + "([\\(\\[][^\\(\\)\\[\\]]+[\\)\\]])" + "?(?:<((?:" + "[\\(\\[][^\\(\\)\\[\\]]+[\\)\\]]" + ")|\\S+))?";
    static final String NODE = COORDSX + "(?:\\s+" + "props\\s*=\\s*((?:[-_a-zA-Z0-9]+)\\s*:\\s*(?:[-_a-zA-Z0-9]*)(?:\\s*,\\s*(?:[-_a-zA-Z0-9]+)\\s*:\\s*(?:[-_a-zA-Z0-9]*))*)" + ")?(?:\\s+" + "(?:scope\\s*=\\s*)?((?!optional)[-_a-zA-Z0-9]+)(?:<([-_a-zA-Z0-9]+))?" + ")?(?:\\s+" + "(!?optional)" + ")?(?:\\s+" + RELOCATIONS + ")?(?:\\s+" + "\\(([-_a-zA-Z0-9]+)\\)" + ")?";
    static final String LINE = "(?:\\^([-_a-zA-Z0-9]+))|(?:" + NODE + ")";
    private static final Pattern PATTERN = Pattern.compile(LINE);
    private final String def;
    String coords;
    Map<String, String> properties;
    String range;
    String premanagedVersion;
    String scope;
    String premanagedScope;
    Boolean optional;
    List<String> relocations;
    String id;
    String reference;

    NodeDefinition(String definition) {
        this.def = definition.trim();
        Matcher m = PATTERN.matcher(this.def);
        if (!m.matches()) {
            throw new IllegalArgumentException("bad syntax: " + this.def);
        }
        this.reference = m.group(1);
        if (this.reference != null) {
            return;
        }
        this.coords = m.group(2);
        this.range = m.group(3);
        this.premanagedVersion = m.group(4);
        String props = m.group(5);
        if (props != null) {
            this.properties = new LinkedHashMap<String, String>();
            for (String prop : props.split("\\s*,\\s*")) {
                int sep = prop.indexOf(58);
                String key = prop.substring(0, sep);
                String val = prop.substring(sep + 1);
                this.properties.put(key, val);
            }
        }
        this.scope = m.group(6);
        this.premanagedScope = m.group(7);
        this.optional = m.group(8) != null ? !m.group(8).startsWith("!") : Boolean.FALSE;
        String relocs = m.group(9);
        if (relocs != null) {
            this.relocations = new ArrayList<String>();
            Collections.addAll(this.relocations, relocs.split("\\s*,\\s*"));
        }
        this.id = m.group(10);
    }

    public String toString() {
        return this.def;
    }
}

