/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util.http;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.ByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.test.util.http.HttpTransporterTest;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmHelper;
import org.eclipse.aether.spi.connector.transport.http.RFC9457.RFC9457Payload;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.compression.server.CompressionConfig;
import org.eclipse.jetty.compression.server.CompressionHandler;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServer.class);
    private File repoDir;
    private boolean rangeSupport = true;
    private boolean webDav;
    private ExpectContinue expectContinue = ExpectContinue.PROPER;
    private ChecksumHeader checksumHeader;
    private Server server;
    private ServerConnector httpConnector;
    private ServerConnector httpsConnector;
    private String username;
    private String password;
    private String proxyUsername;
    private String proxyPassword;
    private final AtomicInteger connectionsToClose = new AtomicInteger(0);
    private final AtomicInteger serverErrorsBeforeWorks = new AtomicInteger(0);
    private int serverErrorStatusCode;
    private final List<LogEntry> logEntries = Collections.synchronizedList(new ArrayList());
    private static final Pattern SIMPLE_RANGE = Pattern.compile("bytes=([0-9])+-");

    public String getHost() {
        return "localhost";
    }

    public int getHttpPort() {
        return this.httpConnector != null ? this.httpConnector.getLocalPort() : -1;
    }

    public int getHttpsPort() {
        return this.httpsConnector != null ? this.httpsConnector.getLocalPort() : -1;
    }

    public String getHttpUrl() {
        return "http://" + this.getHost() + ":" + this.getHttpPort();
    }

    public String getHttpsUrl() {
        return "https://" + this.getHost() + ":" + this.getHttpsPort();
    }

    public HttpServer addSslConnector() {
        return this.addSslConnector(true, true);
    }

    public HttpServer addSelfSignedSslConnector() {
        return this.addSslConnector(false, true);
    }

    public HttpServer addSelfSignedSslConnectorHttp2Only() {
        return this.addSslConnector(false, false);
    }

    private HttpServer addSslConnector(boolean needClientAuth, boolean needHttp11) {
        if (this.httpsConnector == null) {
            SslContextFactory.Server ssl = new SslContextFactory.Server();
            ssl.setNeedClientAuth(needClientAuth);
            if (!needClientAuth) {
                ssl.setKeyStorePath(HttpTransporterTest.KEY_STORE_SELF_SIGNED_PATH.toAbsolutePath().toString());
                ssl.setKeyStorePassword("server-pwd");
                ssl.setSniRequired(false);
            } else {
                ssl.setKeyStorePath(HttpTransporterTest.KEY_STORE_PATH.toAbsolutePath().toString());
                ssl.setKeyStorePassword("server-pwd");
                ssl.setTrustStorePath(HttpTransporterTest.TRUST_STORE_PATH.toAbsolutePath().toString());
                ssl.setTrustStorePassword("client-pwd");
                ssl.setSniRequired(false);
            }
            HttpConfiguration httpsConfig = new HttpConfiguration();
            SecureRequestCustomizer customizer = new SecureRequestCustomizer();
            customizer.setSniHostCheck(false);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)customizer);
            HttpConnectionFactory http1 = null;
            if (needHttp11) {
                http1 = new HttpConnectionFactory(httpsConfig);
            }
            HTTP2ServerConnectionFactory http2 = new HTTP2ServerConnectionFactory(httpsConfig);
            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
            alpn.setDefaultProtocol(http1 != null ? http1.getProtocol() : http2.getProtocol());
            SslConnectionFactory tls = new SslConnectionFactory(ssl, alpn.getProtocol());
            this.httpsConnector = http1 != null ? new ServerConnector(this.server, new ConnectionFactory[]{tls, alpn, http2, http1}) : new ServerConnector(this.server, new ConnectionFactory[]{tls, alpn, http2});
            this.server.addConnector((Connector)this.httpsConnector);
            try {
                this.httpsConnector.start();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this;
    }

    public List<LogEntry> getLogEntries() {
        return this.logEntries;
    }

    public HttpServer setRepoDir(File repoDir) {
        this.repoDir = repoDir;
        return this;
    }

    public HttpServer setRangeSupport(boolean rangeSupport) {
        this.rangeSupport = rangeSupport;
        return this;
    }

    public HttpServer setWebDav(boolean webDav) {
        this.webDav = webDav;
        return this;
    }

    public HttpServer setExpectSupport(ExpectContinue expectContinue) {
        this.expectContinue = expectContinue;
        return this;
    }

    public HttpServer setChecksumHeader(ChecksumHeader checksumHeader) {
        this.checksumHeader = checksumHeader;
        return this;
    }

    public HttpServer setAuthentication(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public HttpServer setProxyAuthentication(String username, String password) {
        this.proxyUsername = username;
        this.proxyPassword = password;
        return this;
    }

    public HttpServer setConnectionsToClose(int connectionsToClose) {
        this.connectionsToClose.set(connectionsToClose);
        return this;
    }

    public HttpServer setServerErrorsBeforeWorks(int serverErrorsBeforeWorks) {
        return this.setServerErrorsBeforeWorks(serverErrorsBeforeWorks, 500);
    }

    public HttpServer setServerErrorsBeforeWorks(int serverErrorsBeforeWorks, int errorStatusCode) {
        this.serverErrorsBeforeWorks.set(serverErrorsBeforeWorks);
        this.serverErrorStatusCode = errorStatusCode;
        return this;
    }

    public HttpServer start() throws Exception {
        if (this.server != null) {
            return this;
        }
        this.server = new Server();
        this.httpConnector = new ServerConnector(this.server);
        this.server.addConnector((Connector)this.httpConnector);
        this.server.setHandler((Handler)new LogHandler((Handler)new CompressionEnforcingHandler((Handler)new Handler.Sequence(new Handler[]{new ConnectionClosingHandler(), new ServerErrorHandler(), new ProxyAuthHandler(), new AuthHandler(), new RedirectHandler(), new RepoHandler(), new RFC9457Handler()}))));
        this.server.start();
        return this;
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
            this.httpConnector = null;
            this.httpsConnector = null;
        }
    }

    private void writeResponseBodyMessage(Request request, Response response, String message) throws IOException {
        try (Blocker.Callback callback = Blocker.callback();){
            Content.Sink.write((Content.Sink)response, (boolean)false, (String)message, (Callback)callback);
            callback.block();
        }
    }

    private String buildRFC9457Message(RFC9457Payload payload) {
        return new Gson().toJson((Object)payload, RFC9457Payload.class);
    }

    static boolean checkBasicAuth(String credentials, String username, String password) {
        String method;
        int space;
        if (credentials != null && (space = credentials.indexOf(32)) > 0 && "basic".equalsIgnoreCase(method = credentials.substring(0, space))) {
            credentials = credentials.substring(space + 1);
            credentials = new String(Base64.getDecoder().decode(credentials), StandardCharsets.ISO_8859_1);
            int i = credentials.indexOf(58);
            if (i > 0) {
                String user = credentials.substring(0, i);
                String pass = credentials.substring(i + 1);
                if (username.equals(user) && password.equals(pass)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static enum ExpectContinue {
        FAIL,
        PROPER,
        BROKEN;

    }

    public static enum ChecksumHeader {
        NEXUS,
        XCHECKSUM;

    }

    private class LogHandler
    extends Handler.Wrapper {
        LogHandler(Handler handler) {
            super(handler);
        }

        public boolean handle(Request req, Response response, Callback callback) throws Exception {
            LOGGER.info("{} {}{}", new Object[]{req.getMethod(), req.getHttpURI().getDecodedPath(), req.getHttpURI().getQuery() != null ? "?" + req.getHttpURI().getQuery() : ""});
            Map<String, String> requestHeaders = this.toUnmodifiableMap(req.getHeaders());
            LogEntry logEntry = new LogEntry(req.getMethod(), req.getHttpURI().getPathQuery(), requestHeaders);
            HttpServer.this.logEntries.add(logEntry);
            boolean result = super.handle(req, response, callback);
            logEntry.setResponseHeaders(this.toUnmodifiableMap((HttpFields)response.getHeaders()));
            if (result) {
                callback.succeeded();
            }
            return result;
        }

        Map<String, String> toUnmodifiableMap(HttpFields headers) {
            TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            for (HttpField header : headers) {
                map.put(header.getName(), header.getValueList().stream().collect(Collectors.joining(", ")));
            }
            return Collections.unmodifiableMap(map);
        }
    }

    private class CompressionEnforcingHandler
    extends CompressionHandler {
        private final PathMappings<CompressionConfig> pathConfigs;

        CompressionEnforcingHandler(Handler handler) {
            super(handler);
            this.pathConfigs = new PathMappings();
            this.putConfiguration("/br/*", CompressionConfig.builder().compressIncludeEncoding("br").build());
            this.putConfiguration("/zstd/*", CompressionConfig.builder().compressIncludeEncoding("zstd").build());
            this.putConfiguration("/gzip/*", CompressionConfig.builder().compressIncludeEncoding("gzip").build());
            this.putConfiguration("/deflate/*", CompressionConfig.builder().compressIncludeEncoding("deflate").build());
        }

        public CompressionConfig putConfiguration(PathSpec pathSpec, CompressionConfig config) {
            return (CompressionConfig)this.pathConfigs.put(pathSpec, (Object)config);
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            Handler next = this.getHandler();
            if (next == null) {
                return false;
            }
            String pathInContext = Request.getPathInContext((Request)request);
            MatchedResource matchedConfig = this.pathConfigs.getMatched(pathInContext);
            if (matchedConfig == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("skipping compression: path {} has no matching compression config", (Object)pathInContext);
                }
                return next.handle(request, response, callback);
            }
            super.putConfiguration(PathSpec.from((String)"/*"), (CompressionConfig)matchedConfig.getResource());
            return super.handle((Request)new StripLeadingPathSegmentsRequestWrapper(request, 1), response, callback);
        }
    }

    private class ConnectionClosingHandler
    extends Handler.Abstract {
        private ConnectionClosingHandler() {
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            if (HttpServer.this.connectionsToClose.getAndDecrement() > 0) {
                request.getConnectionMetaData().getConnection().close();
            }
            return false;
        }
    }

    private class ServerErrorHandler
    extends Handler.Abstract {
        private ServerErrorHandler() {
        }

        public boolean handle(Request request, Response response, Callback callback) throws IOException {
            if (HttpServer.this.serverErrorsBeforeWorks.getAndDecrement() > 0) {
                response.setStatus(HttpServer.this.serverErrorStatusCode);
                HttpServer.this.writeResponseBodyMessage(request, response, "Oops, come back later!");
                return true;
            }
            return false;
        }
    }

    private class ProxyAuthHandler
    extends Handler.Abstract {
        private ProxyAuthHandler() {
        }

        public boolean handle(Request req, Response response, Callback callback) throws Exception {
            if (HttpServer.this.proxyUsername != null && HttpServer.this.proxyPassword != null) {
                if (HttpServer.checkBasicAuth(req.getHeaders().get(HttpHeader.PROXY_AUTHORIZATION), HttpServer.this.proxyUsername, HttpServer.this.proxyPassword)) {
                    return false;
                }
                response.getHeaders().add(HttpHeader.PROXY_AUTHENTICATE, "basic realm=\"Test-Realm\"");
                response.setStatus(407);
                return true;
            }
            return false;
        }
    }

    private class AuthHandler
    extends Handler.Abstract {
        private AuthHandler() {
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            if (ExpectContinue.BROKEN.equals((Object)HttpServer.this.expectContinue) && "100-continue".equalsIgnoreCase(request.getHeaders().get(HttpHeader.EXPECT))) {
                Request.asInputStream((Request)request);
            }
            if (HttpServer.this.username != null && HttpServer.this.password != null) {
                if (HttpServer.checkBasicAuth(request.getHeaders().get(HttpHeader.AUTHORIZATION), HttpServer.this.username, HttpServer.this.password)) {
                    return false;
                }
                response.getHeaders().add(HttpHeader.WWW_AUTHENTICATE, "Basic realm=\"Test-Realm\"");
                response.setStatus(401);
                return true;
            }
            return false;
        }
    }

    private class RedirectHandler
    extends Handler.Abstract {
        private RedirectHandler() {
        }

        public boolean handle(Request req, Response response, Callback callback) throws Exception {
            String path = req.getHttpURI().getPath();
            if (!path.startsWith("/redirect/")) {
                return false;
            }
            StringBuilder location = new StringBuilder(128);
            String scheme = Request.getParameters((Request)req).getValue("scheme");
            location.append(scheme != null ? scheme : req.getHttpURI().getScheme());
            location.append("://");
            location.append(Request.getServerName((Request)req));
            location.append(":");
            if ("http".equalsIgnoreCase(scheme)) {
                location.append(HttpServer.this.getHttpPort());
            } else if ("https".equalsIgnoreCase(scheme)) {
                location.append(HttpServer.this.getHttpsPort());
            } else {
                location.append(Request.getServerPort((Request)req));
            }
            location.append("/repo").append(path.substring(9));
            Response.sendRedirect((Request)req, (Response)response, (Callback)callback, (int)301, (String)location.toString(), (boolean)false);
            return true;
        }
    }

    private class RepoHandler
    extends Handler.Abstract {
        private RepoHandler() {
        }

        public boolean handle(Request req, Response response, Callback callback) throws Exception {
            String path = req.getHttpURI().getDecodedPath().substring(1);
            if (!path.startsWith("repo/")) {
                return false;
            }
            if (ExpectContinue.FAIL.equals((Object)HttpServer.this.expectContinue) && req.getHeaders().get(HttpHeader.EXPECT) != null) {
                response.setStatus(417);
                HttpServer.this.writeResponseBodyMessage(req, response, "Expectation was set to fail");
                return true;
            }
            File file = new File(HttpServer.this.repoDir, path.substring(5));
            if (HttpMethod.GET.is(req.getMethod()) || HttpMethod.HEAD.is(req.getMethod())) {
                if (!file.isFile() || path.endsWith("/")) {
                    response.setStatus(404);
                    HttpServer.this.writeResponseBodyMessage(req, response, "Not found");
                    return true;
                }
                long ifUnmodifiedSince = req.getHeaders().getDateField(HttpHeader.IF_UNMODIFIED_SINCE);
                if (ifUnmodifiedSince != -1L && file.lastModified() > ifUnmodifiedSince) {
                    response.setStatus(412);
                    HttpServer.this.writeResponseBodyMessage(req, response, "Precondition failed");
                    return true;
                }
                long offset = 0L;
                String range = req.getHeaders().get(HttpHeader.RANGE);
                if (range != null && HttpServer.this.rangeSupport) {
                    Matcher m = SIMPLE_RANGE.matcher(range);
                    if (m.matches() && (offset = Long.parseLong(m.group(1))) >= file.length()) {
                        response.setStatus(416);
                        HttpServer.this.writeResponseBodyMessage(req, response, "Range not satisfiable");
                        return true;
                    }
                    String encoding = req.getHeaders().get(HttpHeader.ACCEPT_ENCODING);
                    if (encoding != null && !"identity".equals(encoding) || ifUnmodifiedSince == -1L) {
                        response.setStatus(400);
                        return true;
                    }
                }
                response.setStatus(offset > 0L ? 206 : 200);
                response.getHeaders().add(HttpHeader.LAST_MODIFIED, DateGenerator.formatDate((long)file.lastModified()));
                response.getHeaders().add(HttpHeader.CONTENT_LENGTH, Long.toString(file.length() - offset));
                if (offset > 0L) {
                    response.getHeaders().add(HttpHeader.CONTENT_RANGE, "bytes " + offset + "-" + (file.length() - 1L) + "/" + file.length());
                }
                if (HttpServer.this.checksumHeader != null) {
                    Map checksums = ChecksumAlgorithmHelper.calculate((File)file, Collections.singletonList(new Sha1ChecksumAlgorithmFactory()));
                    if (HttpServer.this.checksumHeader == ChecksumHeader.NEXUS) {
                        response.getHeaders().add(HttpHeader.ETAG.asString(), "{SHA1{" + (String)checksums.get("SHA-1") + "}}");
                    } else if (HttpServer.this.checksumHeader == ChecksumHeader.XCHECKSUM) {
                        response.getHeaders().add("x-checksum-sha1", (String)checksums.get("SHA-1"));
                    }
                }
                if (HttpMethod.HEAD.is(req.getMethod())) {
                    return true;
                }
                Content.Source contentSource = Content.Source.from((ByteBufferPool.Sized)new ByteBufferPool.Sized(null), (Path)file.toPath(), (long)offset, (long)-1L);
                try (Blocker.Callback fileReadCallback = Blocker.callback();){
                    Content.copy((Content.Source)contentSource, (Content.Sink)response, (Callback)fileReadCallback);
                    fileReadCallback.block();
                }
            }
            if (HttpMethod.PUT.is(req.getMethod())) {
                if (!HttpServer.this.webDav) {
                    file.getParentFile().mkdirs();
                }
                if (file.getParentFile().exists()) {
                    try (SeekableByteChannel channel = Files.newByteChannel(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                         Blocker.Callback fileWriteCallback = Blocker.callback();){
                        Content.copy((Content.Source)req, (Content.Sink)Content.Sink.from((ByteChannel)channel), (Callback)fileWriteCallback);
                        fileWriteCallback.block();
                    }
                    catch (IOException e) {
                        file.delete();
                        throw e;
                    }
                    response.setStatus(204);
                } else {
                    response.setStatus(403);
                }
            } else if (HttpMethod.OPTIONS.is(req.getMethod())) {
                if (HttpServer.this.webDav) {
                    response.getHeaders().add("DAV", "1,2");
                }
                response.getHeaders().add(HttpHeader.ALLOW, "GET, PUT, HEAD, OPTIONS");
                response.setStatus(200);
            } else if (HttpServer.this.webDav && "MKCOL".equals(req.getMethod())) {
                if (file.exists()) {
                    response.setStatus(405);
                } else if (file.mkdir()) {
                    response.setStatus(201);
                } else {
                    response.setStatus(409);
                }
            } else {
                response.setStatus(405);
            }
            return true;
        }
    }

    private class RFC9457Handler
    extends Handler.Abstract {
        private RFC9457Handler() {
        }

        public boolean handle(Request req, Response response, Callback callback) throws Exception {
            String path = req.getHttpURI().getPath().substring(1);
            if (!path.startsWith("rfc9457/")) {
                return false;
            }
            if (HttpMethod.GET.is(req.getMethod())) {
                response.setStatus(403);
                response.getHeaders().add(HttpHeader.CONTENT_TYPE.asString(), "application/problem+json");
                RFC9457Payload rfc9457Payload = path.endsWith("missing_fields.txt") ? new RFC9457Payload(null, null, null, null, null) : new RFC9457Payload(URI.create("https://example.com/probs/out-of-credit"), Integer.valueOf(403), "You do not have enough credit.", "Your current balance is 30, but that costs 50.", URI.create("/account/12345/msgs/abc"));
                HttpServer.this.writeResponseBodyMessage(req, response, HttpServer.this.buildRFC9457Message(rfc9457Payload));
            }
            return true;
        }
    }

    private static class StripLeadingPathSegmentsRequestWrapper
    extends Request.Wrapper {
        private final HttpURI modifiedURI;

        StripLeadingPathSegmentsRequestWrapper(Request wrapped, int segmentsToStrip) {
            super(wrapped);
            this.modifiedURI = StripLeadingPathSegmentsRequestWrapper.stripPathSegments(wrapped.getHttpURI(), segmentsToStrip);
        }

        private static HttpURI stripPathSegments(HttpURI originalURI, int segmentsToStrip) {
            if (segmentsToStrip <= 0) {
                return originalURI;
            }
            String originalPath = originalURI.getPath();
            if (originalPath == null || originalPath.isEmpty()) {
                return originalURI;
            }
            String[] segments = originalPath.split("/");
            StringBuilder newPath = new StringBuilder();
            int skipCount = 0;
            for (int i = 0; i < segments.length; ++i) {
                if (segments[i].isEmpty() && i == 0) continue;
                if (skipCount < segmentsToStrip) {
                    ++skipCount;
                    continue;
                }
                newPath.append("/").append(segments[i]);
            }
            if (newPath.isEmpty()) {
                newPath.append("/");
            }
            return HttpURI.build((HttpURI)originalURI).path(newPath.toString()).asImmutable();
        }

        public HttpURI getHttpURI() {
            return this.modifiedURI;
        }
    }

    public static class LogEntry {
        private final String method;
        private final String path;
        private final Map<String, String> requestHeaders;
        private Map<String, String> responseHeaders;
        CountDownLatch responseHeadersAvailableSignal = new CountDownLatch(1);

        public LogEntry(String method, String path, Map<String, String> requestHeaders) {
            this.method = method;
            this.path = path;
            this.requestHeaders = requestHeaders;
        }

        public String getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, String> getRequestHeaders() {
            return this.requestHeaders;
        }

        public Map<String, String> getResponseHeaders() {
            try {
                if (!this.responseHeadersAvailableSignal.await(30L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Timeout waiting for response headers to be available");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while waiting for response headers to be available", e);
            }
            return this.responseHeaders;
        }

        public void setResponseHeaders(Map<String, String> responseHeaders) {
            this.responseHeaders = responseHeaders;
            this.responseHeadersAvailableSignal.countDown();
        }

        public String toString() {
            return this.method + " " + this.path;
        }
    }
}

