/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.synccontext;

import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Priority(value=0x7FFFFFFF)
@Singleton
public class GlobalSyncContextFactory
implements SyncContextFactory {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        return new GlobalSyncContext(shared ? this.lock.readLock() : this.lock.writeLock(), shared);
    }

    static class GlobalSyncContext
    implements SyncContext {
        private static final Logger LOGGER = LoggerFactory.getLogger(GlobalSyncContext.class);
        private final Lock lock;
        private final boolean shared;
        private int lockHoldCount;

        private GlobalSyncContext(Lock lock, boolean shared) {
            this.lock = lock;
            this.shared = shared;
        }

        public void acquire(Collection<? extends Artifact> artifact, Collection<? extends Metadata> metadata) {
            LOGGER.trace("Acquiring global {} lock (currently held: {})", (Object)(this.shared ? "read" : "write"), (Object)this.lockHoldCount);
            this.lock.lock();
            ++this.lockHoldCount;
        }

        public void close() {
            while (this.lockHoldCount > 0) {
                LOGGER.trace("Releasing global {} lock (currently held: {})", (Object)(this.shared ? "read" : "write"), (Object)this.lockHoldCount);
                this.lock.unlock();
                --this.lockHoldCount;
            }
        }
    }
}

